<?php
	include('modules/session-handler.php');
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="build/images/favicon.ico" type="image/ico" />

        <title>IMS | Login</title>

        <link href="build/css/login.css" rel="stylesheet">
        <link href="vendors/sweetalert/sweetalert.css" rel="stylesheet" />
    </head> 
    <body>
        <div class="materialContainer">
            <div class="box">
                <div class="title">LOGIN</div>
                    <div class="input">
                        <label for="name">Username</label>
                        <input type="text" name="name" id="name">
                        <span class="spin"></span>
                    </div> 
                    <div class="input">
                        <label for="pass">Password</label>
                        <input type="password" name="pass" id="pass">
                        <span class="spin"></span>
                    </div> 
                    <div class="button login">
                        <button onclick="login();"><span>LOGIN</span> <i class="fa fa-check"></i></button>
                    </div> 
                    <a href="javascript:forgetPass();" class="pass-forgot">Forgot your password?</a>
                </div>
                <div class="overbox">
                    <div class="material-button alt-2"><span class="shape"></span></div>
                        <div class="title">REGISTER</div>
                            <div class="input">
                                <label for="regname">Username</label>
                                <input type="text" name="regname" id="regname">
                                <span class="spin"></span>
                            </div> 
                            <div class="input">
                                <label for="regpass">Password</label>
                                <input type="password" name="regpass" id="regpass">
                                <span class="spin"></span>
                            </div> 
                            <div class="input">
                                <label for="reregpass">Repeat Password</label>
                                <input type="password" name="reregpass" id="reregpass">
                                <span class="spin"></span>
                            </div> 
                            <div class="button">
                                <button onclick="register();"><span>NEXT</span></button>
                            </div> 
                        </div> 
                    </div>
                </div>  
            </div>
        </div>
        <!-- jQuery -->
        <script src="vendors/jquery/dist/jquery.min.js"></script>
        <!-- Bootstrap -->
        <script src="vendors/bootstrap/dist/js/bootstrap.min.js"></script>
        <!--Sweet Alert-->
	    <script src="vendors/sweetalert/sweetalert.min.js"></script>
        <!-- Custom -->
        <script src="build/js/login.js"></script>

        <script>
            function forgetPass(){
                swal({
                    title: "Forgot Password",
                    text: "Enter Email Address",
                    type: "input",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    animation: "slide-from-top",
                    inputPlaceholder: "Email Address"
                    },
                    function(inputValue){  
                        if(validateEmail(inputValue) == true){
                            $.ajax({
                                url: "modules/property-process.php",
                                type: "POST",
                                data: {email: inputValue ,task: "forgot-pass"},
                                async: true,
                                dataType: 'json',
                                cache: false,  
                                success: function(data)
                                {
                                    if(JSON.stringify(data) == "\"success\""){
                                        swal("Success","Email sent!" + '\nPlease check your email for your password', "success");
                                    }
                                    else{
                                        swal("Error","Email Not Exist!", "error");
                                    }
                                },
                                error: function (jqXHR, exception) { 
                                    if (jqXHR.status === 0) {
                                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                                    } else if (jqXHR.status == 404) {
                                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                                    } else if (jqXHR.status == 500) {
                                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                                    } else if (exception === 'parsererror') { 
                                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                                    } else if (exception === 'timeout') { 
                                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                                    } else if (exception === 'abort') { 
                                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                                    } else { 
                                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                                    }
                                }
                            });  
                        }
                        else{
                            swal("Error!", "Invalid Input", "error");
                            return false
                        } 
                    }
                );
            }
            function validateEmail(email) {
                var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
                return re.test(String(email).toLowerCase());
            }

            $(document).on('keypress',function(e) {
                if(e.which == 13) {
                    login();
                }
            });

        </script>
    </body>
</html>