<?php
   $mindate = isset($_GET['min']) ? $_GET['min'] : null;
   $maxdate = isset($_GET['max']) ? $_GET['max'] : null;

    include_once('../modules/connect.php'); 
    session_start();
  
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);

    function getAllDates($startDate, $endDate) {
        try {
            // Create DateTime objects for the start and end dates
            $start = new DateTime($startDate);
            $end = new DateTime($endDate);
    
            // Ensure the end date is inclusive
            $end->modify('+1 day');
    
            // Array to hold all dates
            $allDates = [];
    
            // Loop through each day from start to end
            while ($start < $end) {
                $allDates[] = $start->format('Y-m-d');
                $start->modify('+1 day');
            }
    
            return $allDates;
        } catch (Exception $e) {
            // Handle invalid date formats
            echo 'Error: ' . $e->getMessage();
            return [];
        }
    } 

    function formatDateFromTimestamp($timestamp) {
        // Format the timestamp as MM-dd-yyyy
        return date('m-d-Y', $timestamp);
    }  

    function setCellValueAndStyle($sheet, $cell, $value, $bold = false, $align = 'left') {
        $sheet->setCellValue($cell, $value);
        if ($bold) {
            $sheet->getStyle($cell)->applyFromArray($bold);
        }
        $alignment = $align === 'center' ? $alignCenter : ($align === 'right' ? $alignRight : $alignLeft);
        $sheet->getStyle($cell)->getAlignment()->applyFromArray($alignment);
    }

    use PhpOffice\PhpSpreadsheet\Helper\Sample;
    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    require_once __DIR__ . '/../vendors/phpoffice/phpspreadsheet/src/Bootstrap.php';  

    $helper = new Sample();
    if ($helper->isCli()) {  
        return;
    }
    // Create new Spreadsheet object
    $spreadsheet = new Spreadsheet();  

    $bold = [
        'font' => [ 
            'bold' => true,
        ], 
    ];

    $alignCenter = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    ];
        
    $alignRight = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,  
    ];

    $alignLeft = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,  
    ];

    $borderArray = [
        'borders' => [
            'outline' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
            ],
        ],
    ];

    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setName('Arial');
    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setSize('10');

    $spreadsheet->getActiveSheet()->mergeCells("A1:F1"); 
    $spreadsheet->getActiveSheet()->mergeCells("A2:F2"); 

    $spreadsheet->getActiveSheet()->getStyle('A1:J5')->applyFromArray($bold); 
    $spreadsheet->getActiveSheet()->setCellValue('A1', 'MLE TRADING');   
    $spreadsheet->getActiveSheet()->setCellValue('A2', 'Activity Report');    
    $spreadsheet->getActiveSheet()->setCellValue('A3', 'From: ' . $mindate .' to ' . $maxdate);    

    $spreadsheet->getActiveSheet()->getStyle('A5:J5')->getAlignment()->applyFromArray($alignCenter); 
    $spreadsheet->getActiveSheet()->setCellValue('A5', 'EMPLOYEE ID');
    $spreadsheet->getActiveSheet()->setCellValue('B5', 'EMPLOYEE');
    $spreadsheet->getActiveSheet()->setCellValue('C5', 'TIME IN');
    $spreadsheet->getActiveSheet()->setCellValue('D5', 'TIME OUT'); 
    $spreadsheet->getActiveSheet()->setCellValue('E5', 'ACTIVITY');
    $spreadsheet->getActiveSheet()->setCellValue('F5', 'REPITITION');
    $spreadsheet->getActiveSheet()->setCellValue('G5', 'RATE');
    $spreadsheet->getActiveSheet()->setCellValue('H5', 'TOTAL SERVICE RATE');
    $spreadsheet->getActiveSheet()->setCellValue('I5', 'FIXED RATE');
    $spreadsheet->getActiveSheet()->setCellValue('J5', 'GRAND TOTAL');

    $spreadsheet->getActiveSheet()->getStyle('A5:J5')->applyFromArray($borderArray); 

    $allDates = getAllDates($mindate, $maxdate);
    if (!empty($allDates)) { 
        $row = 6;
        foreach ($allDates as $date) { 
            $timestamp = strtotime($date);
            $formattedDate = formatDateFromTimestamp($timestamp); 

            $spreadsheet->getActiveSheet()->setCellValue('A'. $row, $formattedDate);     
            $spreadsheet->getActiveSheet()->getStyle('A'. $row)->applyFromArray($bold); 
            $spreadsheet->getActiveSheet()->getStyle('A'. $row)->getAlignment()->applyFromArray($alignCenter); 

            $row++;

            $itemSQL = "SELECT empID, UPPER(fullname) fullname, FORMAT(source.dRate, '#,##0.00') dRate, ISNULL(att.timeIn, '') timeIn, ISNULL(att.timeOut, '') timeOut, ISNULL(att.attDate, '". $date ."') attDate FROM G_Employee source OUTER APPLY (SELECT attDate, CASE WHEN timeIn IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeIn, 24) END timeIn, CASE WHEN timeOut IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeOut, 24) END timeOut FROM T_Att att where empID = source.empID and attDate = '". $date ."') att where source.archiveID = '0' ORDER BY fullname";
            $itemOBJ = $mssql->prepare($itemSQL);
            $itemOBJ->execute(); 
            $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH); 
            if($itemOBJ ->rowCount() > 0){    
                foreach($itemRES as $prow){  
                    $spreadsheet->getActiveSheet()->setCellValue('A'. $row, $prow['empID']); 
                    $spreadsheet->getActiveSheet()->setCellValue('B'. $row, $prow['fullname']);   
                    $spreadsheet->getActiveSheet()->setCellValue('C'. $row, $prow['timeIn']); 
                    $spreadsheet->getActiveSheet()->setCellValue('D'. $row, $prow['timeOut']);     
                    
                    // if(!empty($prow['timeIn'])){
                    //     $spreadsheet->getActiveSheet()->setCellValue('I'. $row, (float)str_replace(',','',$prow['dRate']));   
                    // }else{
                    //     $spreadsheet->getActiveSheet()->setCellValue('I'. $row, (float) '0.00');   
                    // }
                   
                    //$spreadsheet->getActiveSheet()->setCellValue('J'. $row, '=SUM(H'.$row.':I'.$row.')'); 
 
                    //$actSQL = "SELECT actName, SUM(CAST(REPLACE(repitition,',','') as decimal(20,4))) repitition, SUM(CAST(REPLACE(rate,',','') as decimal(20,4))) repitition, SUM(CASE WHEN ROW_NUMBER() OVER(PARTITION BY empID ORDER BY actID ASC) = '1' THEN '0.00' ELSE fixRate END) fRates FROM T_Activities where attDate = '". $date ."' and empID = '". $prow['empID'] ."' and archiveID = '0' GROUP BY actName";

                    $actSQL = "SELECT actName, repitition, rate, CASE WHEN ROW_NUMBER() OVER(PARTITION BY empID ORDER BY actID ASC) = '1' THEN '0.00' ELSE fixRate END fRates FROM T_Activities where attDate = '". $date ."' and empID = '". $prow['empID'] ."' and archiveID = '0'";

                    $actOBJ = $mssql->prepare($actSQL);
                    $actOBJ->execute(); 
                    $actRES = $actOBJ->fetchAll(PDO::FETCH_BOTH); 
                    if($actOBJ ->rowCount() > 0){    
                        $totalRows = count($actRES);
                        foreach($actRES as $index=>$arow){    
                            $repitition = (float) str_replace(',', '', $arow['repitition']);
                            $rate = (float) str_replace(',', '', $arow['rate']);
                            $fRates = (float) str_replace(',', '', $arow['fRates']);


                            if ($index === $totalRows - 1) { 
                                $spreadsheet->getActiveSheet()->setCellValue('E'. $row, $arow['actName']); 
                                $spreadsheet->getActiveSheet()->setCellValue('F'. $row, $arow['repitition']);   
                                $spreadsheet->getActiveSheet()->setCellValue('G'. $row, str_replace(',','',$arow['rate'])); 
                                $spreadsheet->getActiveSheet()->setCellValue('H'. $row, (string)($repitition * $rate));    
                                $spreadsheet->getActiveSheet()->setCellValue('I'. $row, str_replace(',','',$arow['fRates'])); 
                                $spreadsheet->getActiveSheet()->setCellValue('J'. $row, (string)(($repitition * $rate) + $fRates)); 

                                $spreadsheet->getActiveSheet()->getStyle('G'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('H'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('I'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('J'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('J'. $row)->applyFromArray($bold);  

                                $spreadsheet->getActiveSheet()->getStyle('A'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('B'. $row)->getAlignment()->applyFromArray($alignLeft); 
                                $spreadsheet->getActiveSheet()->getStyle('C'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('D'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('E'. $row)->getAlignment()->applyFromArray($alignLeft); 
                                $spreadsheet->getActiveSheet()->getStyle('F'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('G'. $row. ':J'. $row)->getAlignment()->applyFromArray($alignRight);  
                            }
                            else{
                                $spreadsheet->getActiveSheet()->setCellValue('E'. $row, $arow['actName']); 
                                $spreadsheet->getActiveSheet()->setCellValue('F'. $row, $arow['repitition']);   
                                $spreadsheet->getActiveSheet()->setCellValue('G'. $row, str_replace(',','',$arow['rate'])); 
                                $spreadsheet->getActiveSheet()->setCellValue('H'. $row, (string)($repitition * $rate));    
                                $spreadsheet->getActiveSheet()->setCellValue('I'. $row, str_replace(',','',$arow['fRates'])); 
                                $spreadsheet->getActiveSheet()->setCellValue('J'. $row, (string)(($repitition * $rate) + $fRates)); 

                                $spreadsheet->getActiveSheet()->getStyle('G'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('H'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('I'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('J'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                                $spreadsheet->getActiveSheet()->getStyle('J'. $row)->applyFromArray($bold);  

                                $spreadsheet->getActiveSheet()->getStyle('A'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('B'. $row)->getAlignment()->applyFromArray($alignLeft); 
                                $spreadsheet->getActiveSheet()->getStyle('C'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('D'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('E'. $row)->getAlignment()->applyFromArray($alignLeft); 
                                $spreadsheet->getActiveSheet()->getStyle('F'. $row)->getAlignment()->applyFromArray($alignCenter); 
                                $spreadsheet->getActiveSheet()->getStyle('G'. $row. ':J'. $row)->getAlignment()->applyFromArray($alignRight); 

                                $row++;
                            } 
                        }
                    } 

                    $spreadsheet->getActiveSheet()->getStyle('G'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                    $spreadsheet->getActiveSheet()->getStyle('H'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                    $spreadsheet->getActiveSheet()->getStyle('I'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                    $spreadsheet->getActiveSheet()->getStyle('J'. $row)->getNumberFormat()->setFormatCode('#,##0.00');
                    $spreadsheet->getActiveSheet()->getStyle('J'. $row)->applyFromArray($bold);  

                    $spreadsheet->getActiveSheet()->getStyle('A'. $row)->getAlignment()->applyFromArray($alignCenter); 
                    $spreadsheet->getActiveSheet()->getStyle('B'. $row)->getAlignment()->applyFromArray($alignLeft); 
                    $spreadsheet->getActiveSheet()->getStyle('C'. $row)->getAlignment()->applyFromArray($alignCenter); 
                    $spreadsheet->getActiveSheet()->getStyle('D'. $row)->getAlignment()->applyFromArray($alignCenter); 
                    $spreadsheet->getActiveSheet()->getStyle('E'. $row)->getAlignment()->applyFromArray($alignLeft); 
                    $spreadsheet->getActiveSheet()->getStyle('F'. $row)->getAlignment()->applyFromArray($alignCenter); 
                    $spreadsheet->getActiveSheet()->getStyle('G'. $row. ':J'. $row)->getAlignment()->applyFromArray($alignRight); 
                    $row++;
                }  
            }   
            $row = $row + 2;
        }
    } 

    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(14);
    $spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(40);
    $spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(12);
    $spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(12);
    $spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('E')->setWidth(45);
    $spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('F')->setWidth(12);
    $spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(25);  
    $spreadsheet->getActiveSheet()->getColumnDimension('H')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('H')->setWidth(25);  
    $spreadsheet->getActiveSheet()->getColumnDimension('I')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('I')->setWidth(25);  
    $spreadsheet->getActiveSheet()->getColumnDimension('J')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('J')->setWidth(25);  

    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $spreadsheet->setActiveSheetIndex(0);

    // Redirect output to a client’s web browser (Xlsx)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="activity-report.xlsx"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');

    // If you're serving to IE over SSL, then the following may be needed
    header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
    header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header('Pragma: public'); // HTTP/1.0

    $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
    $writer->save('php://output');
    exit;   
?>