<?php 
    $slCMB = $_GET['slCMB'];

    include_once('../modules/connect.php'); 
    session_start();
  
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);

    function getAllDates($startDate, $endDate) {
        try {
            // Create DateTime objects for the start and end dates
            $start = new DateTime($startDate);
            $end = new DateTime($endDate);
    
            // Ensure the end date is inclusive
            $end->modify('+1 day');
    
            // Array to hold all dates
            $allDates = [];
    
            // Loop through each day from start to end
            while ($start < $end) {
                $allDates[] = $start->format('Y-m-d');
                $start->modify('+1 day');
            }
    
            return $allDates;
        } catch (Exception $e) {
            // Handle invalid date formats
            echo 'Error: ' . $e->getMessage();
            return [];
        }
    } 

    function formatDateFromTimestamp($timestamp) {
        // Format the timestamp as MM-dd-yyyy
        return date('m-d-Y', $timestamp);
    }  

    function setCellValueAndStyle($sheet, $cell, $value, $bold = false, $align = 'left') {
        $sheet->setCellValue($cell, $value);
        if ($bold) {
            $sheet->getStyle($cell)->applyFromArray($bold);
        }
        $alignment = $align === 'center' ? $alignCenter : ($align === 'right' ? $alignRight : $alignLeft);
        $sheet->getStyle($cell)->getAlignment()->applyFromArray($alignment);
    }

    function numberToColumnLetter($num) {
        $letter = '';
        while ($num > 0) {
            $num--;
            $letter = chr($num % 26 + 65) . $letter; // Convert to ASCII
            $num = intval($num / 26);
        }
        return $letter;
    }

    use PhpOffice\PhpSpreadsheet\Helper\Sample;
    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    require_once __DIR__ . '/../vendors/phpoffice/phpspreadsheet/src/Bootstrap.php';  

    $helper = new Sample();
    if ($helper->isCli()) {  
        return;
    }
    // Create new Spreadsheet object
    $spreadsheet = new Spreadsheet();  

    $bold = [
        'font' => [ 
            'bold' => true,
        ], 
    ];

    $alignCenter = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    ];
        
    $alignRight = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,  
    ];

    $alignLeft = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,  
    ];

    $borderArray = [
        'borders' => [
            'outline' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
            ],
        ],
    ]; 

    $borderTop = [
        'borders' => [
            'top' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
            ],
        ],
    ];

    $posSQL = "SELECT itemName FROM G_Items source where itemID = '". $slCMB ."'";
    $posOBJ = $mssql->prepare($posSQL);
    $posOBJ->execute();
    $posRES = $posOBJ->fetchAll(PDO::FETCH_BOTH);
    if($posOBJ ->rowCount() > 0){ 
        foreach($posRES as $row){ 
            $slRef = $row['itemName'];
        }
    } 

    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setName('Arial');
    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setSize('10');

    $spreadsheet->getActiveSheet()->mergeCells("A1:F1"); 
    $spreadsheet->getActiveSheet()->mergeCells("A2:F2"); 

    // QUERY
    // SELECT locationName, itemName, dateFill, mainAcct, SUM(expense.amount) totalExp, glCode, expense.coaName
    // FROM G_Locations source INNER JOIN G_Items item ON source.itemCode = item.itemID
    // OUTER APPLY (SELECT mainAcct ,amount, glCode, coa.coaName FROM O_CA main 
    // INNER JOIN O_CADet det ON main.caRef = det.caRef 
    // INNER JOIN G_Coa coa ON coa.coaGL = det.glCode
    // where caDate BETWEEN source.dateFill and CAST(GETDATE() AS DATE) and det.locNo = source.locationID) expense
  
  
    // where source.locationID = '1008'  
    // GROUP BY locationName, itemName, dateFill, mainAcct, glCode, expense.coaName

    $spreadsheet->getActiveSheet()->setCellValue('A1', 'MLE TRADING');   
    $spreadsheet->getActiveSheet()->setCellValue('A2', 'Summary of Expenses');    
    $spreadsheet->getActiveSheet()->setCellValue('A3',  $slRef);    
  
    $spreadsheet->getActiveSheet()->getStyle('A1:A4')->applyFromArray($bold); 

    $itemSQL = "SELECT expense.caRef,expense.caDate, REPLACE(mainAcct,'PURCHASES -','') mainAcct, SUM(expense.amount) totalExp, glCode 
    FROM G_Locations source INNER JOIN G_Items item ON source.itemCode = item.itemID
    OUTER APPLY (SELECT main.caRef, mainAcct ,amount, glCode, caDate FROM O_CA main 
    INNER JOIN O_CADet det ON main.caRef = det.caRef  
    where caDate BETWEEN source.dateFill and CAST(GETDATE() AS DATE) and det.locNo = source.locationID) expense 
    where source.itemCode = '". $slCMB ."'  
    GROUP BY expense.caRef, mainAcct, glCode, expense.caDate ORDER BY CASE WHEN mainAcct like '%PURCHASES -%' THEN 1 ELSE 2 END ASC"; 
    $itemOBJ = $mssql->prepare($itemSQL);
    $itemOBJ->execute(); 
    $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH); 

    $item = [];
    $cell = []; 

    $spreadsheet->getActiveSheet()->setCellValue('A6', 'DATE');
    $spreadsheet->getActiveSheet()->getStyle('A6')->getAlignment()->applyFromArray($alignCenter); 
    $spreadsheet->getActiveSheet()->getStyle('A6')->applyFromArray($bold); 

    if($itemOBJ ->rowCount() > 0){  
        $i = 2;  
        $row = 7;
        $caRef = "";
        foreach($itemRES as $prow){  
            array_push($item, $prow['mainAcct']);  

            if($caRef == $prow['caRef']){
                $row = $row - 1;   
                 
                $spreadsheet->getActiveSheet()->setCellValue('A' . $row, $prow['caDate']); 
                $spreadsheet->getActiveSheet()->getStyle('A' . $row)->getAlignment()->applyFromArray($alignCenter); 
    
                $columnLetter = numberToColumnLetter($i); 
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '6', $prow['mainAcct']);  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->getAlignment()->applyFromArray($alignCenter); 
    
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $row, $prow['totalExp']);  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $row)->getAlignment()->applyFromArray($alignRight);  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $row)->getNumberFormat()->setFormatCode('#,##0.00'); 
            }
            else{
                $caRef = $prow['caRef'];    

                $uniqueArray = array_unique($item); 
                $uniqueArray = array_values($uniqueArray);
                $index = array_search($prow['mainAcct'], $uniqueArray);  
                
                if ($index !== false) { 
                    $i = $index + 2;
                }     

                $spreadsheet->getActiveSheet()->setCellValue('A' . $row, $prow['caDate']); 
                $spreadsheet->getActiveSheet()->getStyle('A' . $row)->getAlignment()->applyFromArray($alignCenter); 
    
                $columnLetter = numberToColumnLetter($i); 
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '6', $prow['mainAcct']);  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->getAlignment()->applyFromArray($alignCenter);  
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $row, $prow['totalExp']);  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $row)->getAlignment()->applyFromArray($alignRight); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $row)->getNumberFormat()->setFormatCode('#,##0.00'); 
                $i++;  
                $row++;     
            } 
        }   

        if(count($item) == 1){
            $title = $i; 
            $columnLetter = numberToColumnLetter($title); 
            $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '6', "SUBTOTAL");  
            $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->applyFromArray($bold); 
            $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->getAlignment()->applyFromArray($alignCenter);  
            
            $spreadsheet->getActiveSheet()->getStyle('A6:'. $columnLetter. '6')->applyFromArray($borderArray);  
    
            for($x = 7;$x < $row;$x++){
                $columnLetter = numberToColumnLetter($title); 
                $last = $title - 1;
                $lastIndex = numberToColumnLetter($last); 
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $x, "=SUM(B". $x . ":" . $lastIndex . $x . ")");
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->getAlignment()->applyFromArray($alignRight); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->getNumberFormat()->setFormatCode('#,##0.00');   
            }  
            $lRow = $row;
            $cRow = $i + 1;
            for($x = 2;$x < $cRow;$x++){
                $columnLetter = numberToColumnLetter($x);  
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $lRow, "=SUM(". $columnLetter . "7:" . $columnLetter . $row . ")");  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->getAlignment()->applyFromArray($alignRight); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->getNumberFormat()->setFormatCode('#,##0.00');   
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $lRow)->applyFromArray($borderTop);  
            }  
        }
        else{
            $title = $i + 1; 
            $columnLetter = numberToColumnLetter($title); 
            $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '6', "SUBTOTAL");  
            $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->applyFromArray($bold); 
            $spreadsheet->getActiveSheet()->getStyle($columnLetter. '6')->getAlignment()->applyFromArray($alignCenter);  
            
            $spreadsheet->getActiveSheet()->getStyle('A6:'. $columnLetter. '6')->applyFromArray($borderArray);  
    
            for($x = 7;$x <= $row;$x++){
                $columnLetter = numberToColumnLetter($title); 
                $last = $title - 1;
                $lastIndex = numberToColumnLetter($last); 
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $x, "=SUM(B". $x . ":" . $lastIndex . $x . ")");
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->getAlignment()->applyFromArray($alignRight); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $x)->getNumberFormat()->setFormatCode('#,##0.00');   
            }  
            $lRow = $row + 1;
            $cRow = $i + 1;
            for($x = 2;$x <= $cRow;$x++){
                $columnLetter = numberToColumnLetter($x);  
                $spreadsheet->getActiveSheet()->setCellValue($columnLetter . $lRow, "=SUM(". $columnLetter . "7:" . $columnLetter . $row . ")");  
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->getAlignment()->applyFromArray($alignRight); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->applyFromArray($bold); 
                $spreadsheet->getActiveSheet()->getStyle($columnLetter . $lRow)->getNumberFormat()->setFormatCode('#,##0.00');   
                $spreadsheet->getActiveSheet()->getStyle($columnLetter. $lRow)->applyFromArray($borderTop);  
            }  
        } 
    }    

    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(15);
    for ($col = 'B'; $col <= 'Z'; $col++) {  
        $spreadsheet->getActiveSheet()->getColumnDimension($col)->setAutoSize(false); 
        $spreadsheet->getActiveSheet()->getColumnDimension($col)->setWidth(35);
    }

    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $spreadsheet->setActiveSheetIndex(0);

    // Redirect output to a client’s web browser (Xlsx)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="summary-exp-report.xlsx"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');

    // If you're serving to IE over SSL, then the following may be needed
    header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
    header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header('Pragma: public'); // HTTP/1.0

    $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
    $writer->save('php://output');
    exit;   
?>