<?php   
    include_once('../modules/connect.php'); 
    session_start();

    $fullname = $_SESSION['firstName'] . ' ' . $_SESSION['lastName'];
  
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL); 

    function escapeSingleQuote($input) { 
        return str_replace("'", "''", $input);
    }

    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ipAddress = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipAddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ipAddress = $_SERVER['REMOTE_ADDR'];
    }

    function str_contain($haystack, $needle) {
        return strpos($haystack, $needle) !== false;
    }

    function getDatesBetween($startDate, $endDate) {
        // Create DateTime objects from the input strings
        $start = new DateTime($startDate);
        $end = new DateTime($endDate);
        
        // Ensure the end date is inclusive
        $end->modify('+1 day');
    
        // Array to hold all dates between the range
        $dates = [];
    
        // Loop through each day in the range
        $current = $start;
        while ($current < $end) {
            // Format and add the current date to the array
            $dates[] = $current->format('Y-m-d');
            // Move to the next day
            $current->modify('+1 day');
        }
    
        return $dates;
    }

    date_default_timezone_set('Asia/Manila');
    $dateToday = date("m-d-Y");
    $timeToday = date("h:i a");   
    $otherFormat = date("Y-m-d"); 

    if($_SERVER["REQUEST_METHOD"] == "GET"){
        $task = filter_var(mysqli_real_escape_string($db,$_GET['task']));
    }
    else{
        $task = filter_var(mysqli_real_escape_string($db,$_POST['task']));
    }
     
    // -- MASTER DATA -- // 
    // ITEM
    if($task == "new-item"){ 
        $itemCode = filter_var(mysqli_real_escape_string($db,$_POST['itemCode']));
        $itemName = filter_var(mysqli_real_escape_string($db,$_POST['itemName']));
        $setup = filter_var(mysqli_real_escape_string($db,$_POST['setup']));
        $chartCode = filter_var(mysqli_real_escape_string($db,$_POST['chartCode']));
        $chartName = filter_var(mysqli_real_escape_string($db,$_POST['chartName']));
        $hchartCode = filter_var(mysqli_real_escape_string($db,$_POST['hchartCode']));
        $hchartName = filter_var(mysqli_real_escape_string($db,$_POST['hchartName']));

        $itemSQL = "SELECT * FROM G_Items where itemCode = '". $itemCode ."' and archiveID = '0'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() <= 0){    
            $newSQL = "INSERT INTO G_Items (itemCode, itemName, archiveID, assets, revenue) VALUES ('". $itemCode ."','". escapeSingleQuote(strtoupper($itemName)) ."','0', '". escapeSingleQuote(strtoupper($chartCode)) ."', '". escapeSingleQuote(strtoupper($hchartCode)) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    
            
            if($setup == "new"){
                $newSQL = "INSERT INTO G_Coa (coaName, coaGL, coaParentID, coaLevel, coaType, archiveID) VALUES ('". escapeSingleQuote(strtoupper($chartName)) ."','". escapeSingleQuote(strtoupper($chartCode)) ."','11031000', '5', 'ASSETS', '0')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   

                $newSQL = "INSERT INTO G_Coa (coaName, coaGL, coaParentID, coaLevel, coaType, archiveID) VALUES ('". escapeSingleQuote(strtoupper($hchartName)) ."','". escapeSingleQuote(strtoupper($hchartCode)) ."','41011000', '5', 'SALES OF SERVICES', '0')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   
            }

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Item - ". escapeSingleQuote(strtoupper($itemName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");   
        }   
        else{
            echo json_encode("duplicated");  
        }
    } 
    else if($task == "revise-item"){ 
        $itemCode = filter_var(mysqli_real_escape_string($db,$_POST['itemCode']));
        $nitemName = filter_var(mysqli_real_escape_string($db,$_POST['nitemName']));
        $oitemName = filter_var(mysqli_real_escape_string($db,$_POST['oitemName']));
        $chartCode = filter_var(mysqli_real_escape_string($db,$_POST['chartCode']));
        $hchartCode = filter_var(mysqli_real_escape_string($db,$_POST['hchartCode'])); 

        $itemSQL = "SELECT itemName FROM G_Items where itemCode = '". $itemCode ."' and archiveID = '0'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $citemName = $row['itemName'];
            }  

            if($citemName == $oitemName){
                $newSQL = "UPDATE G_Items SET itemName = '". escapeSingleQuote(strtoupper($nitemName)) ."', assets = '". escapeSingleQuote(strtoupper($chartCode)) ."', revenue = '". escapeSingleQuote(strtoupper($hchartCode)) ."' where itemCode = '". $itemCode ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();  
    
                $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Item - ". escapeSingleQuote(strtoupper($nitemName)) .")', '". $ipAddress ."')"; 
                $logsOBJ = $mssql->prepare($logSQL);
                $logsOBJ->execute(); 

                echo json_encode("saved");  
            }
            else{
                echo json_encode("duplicated");  
            }
        }    
    } 
    else if($task == "archive-item"){ 
        $itemID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Items SET archiveID = '1' where itemID = '". $itemID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT itemName FROM G_Items where itemID = '". $itemID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $itemName = $row['itemName'];
            }  
        }

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Item - ". escapeSingleQuote(strtoupper($itemName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }

    // LOCATION
    else if($task == "new-location"){ 
        $locationName = filter_var(mysqli_real_escape_string($db,$_POST['locationName']));
        $location = filter_var(mysqli_real_escape_string($db,$_POST['location']));
        $capacity = filter_var(mysqli_real_escape_string($db,$_POST['capacity']));
        
        $newSQL = "INSERT INTO G_Locations (locationName, location, occupied, itemCode, capacity, remaining, archiveID) VALUES ('". escapeSingleQuote(strtoupper($locationName)) ."','". escapeSingleQuote(strtoupper($location)) ."','0','','". escapeSingleQuote(strtoupper($capacity)) ."','". escapeSingleQuote(strtoupper($capacity)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Location - ". escapeSingleQuote(strtoupper($locationName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-location"){ 
        $locationID = filter_var(mysqli_real_escape_string($db,$_POST['locationID']));
        $locationName = filter_var(mysqli_real_escape_string($db,$_POST['locationName']));
        $location = filter_var(mysqli_real_escape_string($db,$_POST['location'])); 
        
        $newSQL = "UPDATE G_Locations SET locationName = '". escapeSingleQuote(strtoupper($locationName)) ."', location = '". escapeSingleQuote(strtoupper($location)) ."' where locationID = '". $locationID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Location - ". escapeSingleQuote(strtoupper($locationName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-location"){ 
        $locID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Locations SET archiveID = '1' where locationID = '". $locID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT locationName FROM G_Locations where locationID = '". $locID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $locationName = $row['locationName'];
            }  
        }


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Location - ". escapeSingleQuote(strtoupper($locationName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }   

    // SUPPLIER
    else if($task == "new-supplier"){ 
        $buying = filter_var(mysqli_real_escape_string($db,$_POST['buying']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo']));  
        
        $newSQL = "INSERT INTO G_Buying (buyName, tinNo, archiveID, isSupplier) VALUES ('". escapeSingleQuote(strtoupper($buying)) ."','". escapeSingleQuote(strtoupper($tinNo)) ."','0','1')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Supplier - ". escapeSingleQuote(strtoupper($buying)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-supplier"){ 
        $buyingID = filter_var(mysqli_real_escape_string($db,$_POST['buyingID']));
        $buying = filter_var(mysqli_real_escape_string($db,$_POST['buying']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo'])); 
        
        $newSQL = "UPDATE G_Buying SET buyName = '". escapeSingleQuote(strtoupper($buying)) ."', tinNo = '". escapeSingleQuote(strtoupper($tinNo)) ."' where buyingID = '". $buyingID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Supplier - ". escapeSingleQuote(strtoupper($buying)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-supplier"){ 
        $buyID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Buying SET archiveID = '1' where buyingID = '". $buyID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT buyName FROM G_Buying where buyingID = '". $buyID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $buyName = $row['buyName'];
            }  
        }


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Supplier - ". escapeSingleQuote(strtoupper($buyName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  

    // BUYING STATION
    else if($task == "new-bs"){ 
        $buying = filter_var(mysqli_real_escape_string($db,$_POST['buying']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo']));  
        
        $newSQL = "INSERT INTO G_Buying (buyName, tinNo, archiveID, isSupplier) VALUES ('". escapeSingleQuote(strtoupper($buying)) ."','". escapeSingleQuote(strtoupper($tinNo)) ."','0','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Buying Station - ". escapeSingleQuote(strtoupper($buying)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-bs"){ 
        $buyingID = filter_var(mysqli_real_escape_string($db,$_POST['buyingID']));
        $buying = filter_var(mysqli_real_escape_string($db,$_POST['buying']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo'])); 
        
        $newSQL = "UPDATE G_Buying SET buyName = '". escapeSingleQuote(strtoupper($buying)) ."', tinNo = '". escapeSingleQuote(strtoupper($tinNo)) ."' where buyingID = '". $buyingID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Buying Station - ". escapeSingleQuote(strtoupper($buying)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-bs"){ 
        $buyID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Buying SET archiveID = '1' where buyingID = '". $buyID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT buyName FROM G_Buying where buyingID = '". $buyID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $buyName = $row['buyName'];
            }  
        }


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Buying Station - ". escapeSingleQuote(strtoupper($buyName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  


    // CLIENT
    else if($task == "new-client"){ 
        $client = filter_var(mysqli_real_escape_string($db,$_POST['client']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo'])); 
        
        $newSQL = "INSERT INTO G_Client (clientName, tinNo, archiveID, isSupplier) VALUES ('". escapeSingleQuote(strtoupper($client)) ."','". escapeSingleQuote(strtoupper($tinNo)) ."','0', '0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Client - ". escapeSingleQuote(strtoupper($client)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-client"){ 
        $clientID = filter_var(mysqli_real_escape_string($db,$_POST['clientID']));
        $client = filter_var(mysqli_real_escape_string($db,$_POST['client']));
        $tinNo = filter_var(mysqli_real_escape_string($db,$_POST['tinNo'])); 
        
        $newSQL = "UPDATE G_Client SET clientName = '". escapeSingleQuote(strtoupper($client)) ."', tinNo = '". escapeSingleQuote(strtoupper($tinNo)) ."' where clientID = '". $clientID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Client - ". escapeSingleQuote(strtoupper($client)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-client"){ 
        $clientID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Client SET archiveID = '1' where clientID = '". $clientID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT clientName FROM G_Client where clientID = '". $clientID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $clientName = $row['clientName'];
            }  
        }


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Client - ". escapeSingleQuote(strtoupper($clientName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  

    // EMPLOYEE
    else if($task == "new-employee"){  
        $first = filter_var(mysqli_real_escape_string($db,$_POST['first']));
        $middle = filter_var(mysqli_real_escape_string($db,$_POST['middle']));
        $last = filter_var(mysqli_real_escape_string($db,$_POST['last']));
        $rate = filter_var(mysqli_real_escape_string($db,$_POST['rate']));
        $posName = filter_var(mysqli_real_escape_string($db,$_POST['posName'])); 

        $fullname = $first . ' ' . $middle . ' ' . $last;
        
        $newSQL = "INSERT INTO G_Employee (fullname, fName, mName, lName, posID, dRate, archiveID) VALUES ('". escapeSingleQuote(strtoupper($fullname)) ."','". escapeSingleQuote(strtoupper($first)) ."','". escapeSingleQuote(strtoupper($middle)) ."','". escapeSingleQuote(strtoupper($last)) ."','". escapeSingleQuote(strtoupper($posName)) ."','". escapeSingleQuote(strtoupper($rate)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Employee - ". escapeSingleQuote(strtoupper($fullname)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-employee"){ 
        $empID = filter_var(mysqli_real_escape_string($db,$_POST['empID']));
        $first = filter_var(mysqli_real_escape_string($db,$_POST['first']));
        $middle = filter_var(mysqli_real_escape_string($db,$_POST['middle']));
        $last = filter_var(mysqli_real_escape_string($db,$_POST['last']));
        $rate = filter_var(mysqli_real_escape_string($db,$_POST['rate']));
        $posName = filter_var(mysqli_real_escape_string($db,$_POST['posName'])); 

        $fullname = $first . ' ' . $middle . ' ' . $last;
        
        $newSQL = "UPDATE G_Employee SET fName = '". escapeSingleQuote(strtoupper($first)) ."', mName = '". escapeSingleQuote(strtoupper($middle)) ."', lName = '". escapeSingleQuote(strtoupper($last)) ."', dRate = '". escapeSingleQuote(strtoupper($rate)) ."', posID = '". escapeSingleQuote(strtoupper($posName)) ."' where empID = '". $empID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Employee - ". escapeSingleQuote(strtoupper($fullname)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-employee"){ 
        $empID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Employee SET archiveID = '1' where empID = '". $empID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT fullname FROM G_Employee where empID = '". $empID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $fullname = $row['fullname'];
            }  
        }


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Employee - ". escapeSingleQuote(strtoupper($fullname)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  

     // TRUCK
    else if($task == "new-truck"){  
        $subCon = filter_var(mysqli_real_escape_string($db,$_POST['subCon']));
        $truckName = filter_var(mysqli_real_escape_string($db,$_POST['truckName'])); 
        $plateNumber = filter_var(mysqli_real_escape_string($db,$_POST['plateNumber'])); 
        
        $newSQL = "INSERT INTO G_Truck (subConName, truckName, plateNumber, archiveID) VALUES ('". escapeSingleQuote(strtoupper($subCon)) ."','". escapeSingleQuote(strtoupper($truckName)) ."','". escapeSingleQuote(strtoupper($plateNumber)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Truck - ". escapeSingleQuote(strtoupper($truckName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-truck"){ 
        $truckID = filter_var(mysqli_real_escape_string($db,$_POST['truckID']));
        $subCon = filter_var(mysqli_real_escape_string($db,$_POST['subCon']));
        $truckName = filter_var(mysqli_real_escape_string($db,$_POST['truckName'])); 
        $plateNumber = filter_var(mysqli_real_escape_string($db,$_POST['plateNumber'])); 
        
        $newSQL = "UPDATE G_Truck SET subConName = '". escapeSingleQuote(strtoupper($subCon)) ."', truckName = '". escapeSingleQuote(strtoupper($truckName)) ."', plateNumber = '". escapeSingleQuote(strtoupper($plateNumber)) ."' where truckID = '". $truckID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Truck - ". escapeSingleQuote(strtoupper($truckName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-truck"){ 
        $truckID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_Truck SET archiveID = '1' where truckID = '". $truckID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT truckName FROM G_Truck where truckID = '". $truckID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $truckName = $row['truckName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Truck - ". escapeSingleQuote(strtoupper($truckName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  

 
    // USER
    else if($task == "new-user"){  
        $first = filter_var(mysqli_real_escape_string($db,$_POST['first']));
        $last = filter_var(mysqli_real_escape_string($db,$_POST['last'])); 
        $uName = filter_var(mysqli_real_escape_string($db,$_POST['uName'])); 
        $pWord = filter_var(mysqli_real_escape_string($db,$_POST['pWord'])); 

        
        $newSQL = "INSERT INTO G_User (firstName, lastName, uName, pWord, archiveID) VALUES ('". escapeSingleQuote(strtoupper($first)) ."','". escapeSingleQuote(strtoupper($last)) ."','". escapeSingleQuote(strtoupper($uName)) ."','". escapeSingleQuote(strtoupper($pWord)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New User - ". escapeSingleQuote(strtoupper($uName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "revise-truck"){ 
        $truckID = filter_var(mysqli_real_escape_string($db,$_POST['truckID']));
        $subCon = filter_var(mysqli_real_escape_string($db,$_POST['subCon']));
        $truckName = filter_var(mysqli_real_escape_string($db,$_POST['truckName'])); 
        $plateNumber = filter_var(mysqli_real_escape_string($db,$_POST['plateNumber'])); 
        
        $newSQL = "UPDATE G_Truck SET subConName = '". escapeSingleQuote(strtoupper($subCon)) ."', truckName = '". escapeSingleQuote(strtoupper($truckName)) ."', plateNumber = '". escapeSingleQuote(strtoupper($plateNumber)) ."' where truckID = '". $truckID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Truck - ". escapeSingleQuote(strtoupper($truckName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "archive-user"){ 
        $userID = filter_var(mysqli_real_escape_string($db,$_POST['id'])); 
        $newSQL = "UPDATE G_User SET archiveID = '1' where userID = '". $userID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT uName FROM G_User where userID = '". $userID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $uName = $row['uName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive User - ". escapeSingleQuote(strtoupper($uName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }  
    
    // CHART OF ACCOUNTS 
    else if($task == "check-coa"){
        $level = $_GET['coaLevel'];   
        $itemSQL = "SELECT coaID, UPPER(source.coaName) coaName, coaGL, UPPER(parent.coaName) parent, coaLevel, coaType FROM G_Coa source OUTER APPLY (SELECT coaName FROM G_Coa where LTRIM(RTRIM(coaGL)) = LTRIM(RTRIM(source.coaParentID))) parent where archiveID = '0' and coaLevel = '". $level ."'"; 

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        header('Content-Type: application/json');
        echo json_encode($itemRES);   
    }
    else if($task == "check-parents"){
        $level = filter_var(mysqli_real_escape_string($db,$_POST['coaLevel'])); 
        $level = $level - 1;
        $itemSQL = "SELECT UPPER(coaName) coaName, coaGL FROM G_Coa where archiveID = '0' and coaLevel = '". $level ."'"; 

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){  
            foreach($itemRES as $row){  
                $itemJSON = $itemRES;
            }    
        }
        else{
            $itemJSON = '';
        }  
        echo json_encode($itemJSON);
    }
    else if($task == "check-lastGL"){
        $cVal = filter_var(mysqli_real_escape_string($db,$_POST['cVal']));  
        $itemSQL = "SELECT coaGL FROM G_Coa where archiveID = '0' and coaParentID = '". TRIM($cVal) ."'"; 

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){  
            foreach($itemRES as $row){  
                $coaGL = $row['coaGL'];
            }    
        }
        else{
            $coaGL = '';
        }  
        echo json_encode($coaGL);
    }
    else if($task == "new-coa"){
        try{
            $cName = filter_var(mysqli_real_escape_string($db,$_POST['cName'])); 
            $cType = filter_var(mysqli_real_escape_string($db,$_POST['cType'])); 
            $cLevel = filter_var(mysqli_real_escape_string($db,$_POST['cLevel'])); 
            $cCode = filter_var(mysqli_real_escape_string($db,$_POST['cCode'])); 
            $cParent = filter_var(mysqli_real_escape_string($db,$_POST['cParent']));  
    
            $newSQL = "INSERT INTO G_Coa (coaName, coaGL, coaParentID, coaLevel, coaType, archiveID) values ('". escapeSingleQuote(strtoupper($cName)) ."','". escapeSingleQuote(strtoupper($cCode)) ."','". escapeSingleQuote(strtoupper($cParent)) ."','". escapeSingleQuote(strtoupper($cLevel)) ."','". escapeSingleQuote(strtoupper($cType)) ."','0')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New COA - ". escapeSingleQuote(strtoupper($cName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        }  
    }
    else if($task == "modify-coa"){
        $cID = filter_var(mysqli_real_escape_string($db,$_POST['cID'])); 
        $cName = filter_var(mysqli_real_escape_string($db,$_POST['cName'])); 
        $cType = filter_var(mysqli_real_escape_string($db,$_POST['cType'])); 
        $cLevel = filter_var(mysqli_real_escape_string($db,$_POST['cLevel'])); 
        $cCode = filter_var(mysqli_real_escape_string($db,$_POST['cCode'])); 
        $cParent = filter_var(mysqli_real_escape_string($db,$_POST['cParent']));  

        $newSQL = "UPDATE G_Coa SET coaName = '". escapeSingleQuote(strtoupper($cName)) ."', coaGL = '". escapeSingleQuote(strtoupper($cCode)) ."', coaParentID = '". escapeSingleQuote(strtoupper($cParent)) ."', coaLevel = '". escapeSingleQuote(strtoupper($cLevel)) ."', coaType = '". escapeSingleQuote(strtoupper($cType)) ."' where coaID = '". $cID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify COA - ". escapeSingleQuote(strtoupper($cName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    }
    else if($task == "archive-coa"){ 
        $coaID = filter_var(mysqli_real_escape_string($db,$_POST['code'])); 
        $newSQL = "UPDATE G_Coa SET archiveID = '1' where coaID = '". $coaID ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT coaName FROM G_Coa where coaID = '". $coaID ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $coaName = $row['coaName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive COA - ". escapeSingleQuote(strtoupper($coaName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    } 

    //  ACTIVITIES
    else if($task == "new-act"){
        try{
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $actName = filter_var(mysqli_real_escape_string($db,$_POST['actName']));  
            $coaGLid = filter_var(mysqli_real_escape_string($db,$_POST['coaGLid']));  
    
            $newSQL = "INSERT INTO G_Activity (glCode, actName, archiveID, isAct) values ('". escapeSingleQuote(strtoupper($coaGLid)) ."','". escapeSingleQuote(strtoupper($actName)) ."','0','1')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Activity - ". escapeSingleQuote(strtoupper($actName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        }  
    }
    else if($task == "modify-act"){
        try{
            $chargeCode = filter_var(mysqli_real_escape_string($db,$_POST['actCode'])); 
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $actName = filter_var(mysqli_real_escape_string($db,$_POST['actName']));  
    
            $newSQL = "UPDATE G_Activity SET glCode = '". escapeSingleQuote(strtoupper($coaGL)) ."', actName = '". escapeSingleQuote(strtoupper($actName)) ."' where activityID = '". $chargeCode ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Activity - ". escapeSingleQuote(strtoupper($actName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        }  
    } 
    else if($task == "archive-act"){
        $actCode = filter_var(mysqli_real_escape_string($db,$_POST['code'])); 
        $newSQL = "UPDATE G_Activity SET archiveID = '1' where activityID = '". $actCode ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT actName FROM G_Activity where activityID = '". $actCode ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $actName = $row['actName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Activity - ". escapeSingleQuote(strtoupper($actName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }

    //  CHARGES
    else if($task == "new-charges"){
        try{
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $chargesName = filter_var(mysqli_real_escape_string($db,$_POST['chargesName']));  
    
            $newSQL = "INSERT INTO G_Activity (glCode, actName, archiveID, isAct) values ('". escapeSingleQuote(strtoupper($coaGL)) ."','". escapeSingleQuote(strtoupper($chargesName)) ."','0','0')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Activity - ". escapeSingleQuote(strtoupper($chargesName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        }  
    }
    else if($task == "modify-charges"){
        try{
            $chargeCode = filter_var(mysqli_real_escape_string($db,$_POST['actCode'])); 
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $chargesName = filter_var(mysqli_real_escape_string($db,$_POST['chargesName']));  
    
            $newSQL = "UPDATE G_Activity SET glCode = '". escapeSingleQuote(strtoupper($coaGL)) ."', actName = '". escapeSingleQuote(strtoupper($chargesName)) ."' where activityID = '". $chargeCode ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Activity - ". escapeSingleQuote(strtoupper($chargesName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        } 
    }
    else if($task == "archive-charges"){
        $actCode = filter_var(mysqli_real_escape_string($db,$_POST['code'])); 
        $newSQL = "UPDATE G_Activity SET archiveID = '1' where activityID = '". $actCode ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT actName FROM G_Activity where activityID = '". $actCode ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $actName = $row['actName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Activity - ". escapeSingleQuote(strtoupper($actName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }

    // INCOMING CHARGES 
    else if($task == "new-icharges"){
        try{
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $chargesName = filter_var(mysqli_real_escape_string($db,$_POST['chargesName']));  
    
            $newSQL = "INSERT INTO G_Activity (glCode, actName, archiveID, isAct) values ('". escapeSingleQuote(strtoupper($coaGL)) ."','". escapeSingleQuote(strtoupper($chargesName)) ."','0','4')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (New Activity - ". escapeSingleQuote(strtoupper($chargesName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        }  
    }
    else if($task == "modify-icharges"){
        try{
            $chargeCode = filter_var(mysqli_real_escape_string($db,$_POST['actCode'])); 
            $coaGL = filter_var(mysqli_real_escape_string($db,$_POST['coaGL'])); 
            $chargesName = filter_var(mysqli_real_escape_string($db,$_POST['chargesName']));  
    
            $newSQL = "UPDATE G_Activity SET glCode = '". escapeSingleQuote(strtoupper($coaGL)) ."', actName = '". escapeSingleQuote(strtoupper($chargesName)) ."' where activityID = '". $chargeCode ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Modify Activity - ". escapeSingleQuote(strtoupper($chargesName)) .")', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");    
        }
        catch(Exception $e){
            if(str_contain($e,'duplicate')){
                echo json_encode("duplicate");    
            }else{
                echo json_encode("error");    
            }
        } 
    }
    else if($task == "archive-icharges"){
        $actCode = filter_var(mysqli_real_escape_string($db,$_POST['code'])); 
        $newSQL = "UPDATE G_Activity SET archiveID = '1' where activityID = '". $actCode ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $itemSQL = "SELECT actName FROM G_Activity where activityID = '". $actCode ."'";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){    
            foreach($itemRES as $row){  
                $actName = $row['actName'];
            }  
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Archive Activity - ". escapeSingleQuote(strtoupper($actName)) .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    } 

    // WORKLOAD
    else if($task == "check-attendance"){
        $min_date = $_GET['min_date'];    

        //$itemSQL = "SELECT empID, UPPER(fullname) fullname, act.isPresent, act.timeIn, act.timeOut, act.actID, act.actName, act.repitition, act.rate, act.fixRate, act.salary, act.locationName FROM G_Employee source OUTER APPLY (SELECT attDate, isPresent, CASE WHEN timeIn IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeIn, 24) END timeIn, CASE WHEN timeOut IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeOut, 24) END timeOut, actID, actName, FORMAT(repitition, '#,##0') repitition, FORMAT(rate, '#,##0.00') rate, FORMAT(fixRate, '#,##0.00') fixRate, FORMAT(((repitition * rate) + fixRate), '#,##0.00') salary, locs.locationName FROM T_Activities acts INNER JOIN G_Locations locs ON acts.locID = locs.locationID where empID = source.empID and attDate = '". $min_date ."') act where source.archiveID = '0'"; 

        $itemSQL = "SELECT empID, UPPER(fullname) fullname, FORMAT(source.dRate, '#,##0.00') dRate, att.timeIn, att.timeOut, att.attDate FROM G_Employee source OUTER APPLY (SELECT attDate, CASE WHEN timeIn IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeIn, 24) END timeIn, CASE WHEN timeOut IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeOut, 24) END timeOut FROM T_Att att where empID = source.empID and attDate = '". $min_date ."') att where source.archiveID = '0'";

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        header('Content-Type: application/json');
        echo json_encode($itemRES);  
    } 
    else if($task == "autocomplete-coaGL"){
        $searchTerm = $_GET['term'];

        $itemSQL = "select coaGL, source.coaName from G_Coa source where coaLevel = '5' and archiveID = '0' and coaName LIKE '%". $searchTerm ."%' ORDER BY coaGL";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['coaGL'], 
                    'value' => $row['coaName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "check-activity"){
        $min_date = $_GET['min_date'];  
        $empID = $_GET['empID'];  

        $itemSQL = "SELECT source.workID, source.isRel, source.glCode, source.actID, UPPER(source.actName) actName, FORMAT(source.repitition, '#,##0.00') repitition, FORMAT(source.rate, '#,##0.00') rate, FORMAT(source.totalRate, '#,##0.00') totalRate, location.locationName, item.itemName FROM T_Activities source OUTER APPLY (SELECT locationName FROM G_Locations where locationID = source.locID) location OUTER APPLY (SELECT itemName FROM G_Items where itemID = source.itemCode) item where empID = '". $empID ."' and attDate = '". $min_date ."'";

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        header('Content-Type: application/json');
        echo json_encode($itemRES);   
    }
    else if($task == "check-groupactivity"){
        $min_date = $_GET['min_date'];   

        $itemSQL = "SELECT source.isRel, source.glCode, source.actID, UPPER(source.actName) actName, FORMAT(source.repitition, '#,##0.00') repitition, FORMAT(source.rate, '#,##0.00') rate, FORMAT(source.totalRate, '#,##0.00') totalRate, location.locationName, item.itemName FROM T_Activities source OUTER APPLY (SELECT locationName FROM G_Locations where locationID = source.locID) location OUTER APPLY (SELECT itemName FROM G_Items where itemID = source.itemCode) item where attDate = '". $min_date ."' GROUP BY source.isRel, source.glCode, source.actID, UPPER(source.actName), FORMAT(source.repitition, '#,##0.00'), FORMAT(source.rate, '#,##0.00'), FORMAT(source.totalRate, '#,##0.00'), location.locationName, item.itemName";

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        header('Content-Type: application/json');
        echo json_encode($itemRES);   
    }
    else if($task == "save-attendance"){ 
        $pID = filter_var(mysqli_real_escape_string($db,$_POST['pID'])); 
        $pName = filter_var(mysqli_real_escape_string($db,$_POST['pName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pIn = filter_var(mysqli_real_escape_string($db,$_POST['pIn'])); 
        $pOut = filter_var(mysqli_real_escape_string($db,$_POST['pOut'])); 

        $newSQL = "INSERT INTO T_Att (empID, fullName, attDate, timeIn, timeOut, archiveID) VALUES ('". escapeSingleQuote(strtoupper($pID)) ."','". escapeSingleQuote(strtoupper($pName)) ."','". escapeSingleQuote(strtoupper($pDate)) ."','". escapeSingleQuote(strtoupper($pIn)) ."','". escapeSingleQuote(strtoupper($pOut)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Enter Attendance of ". escapeSingleQuote(strtoupper($pName)) ." dated ". $pDate ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    }
    else if($task == "revise-attendance"){ 
        $pID = filter_var(mysqli_real_escape_string($db,$_POST['pID'])); 
        $pName = filter_var(mysqli_real_escape_string($db,$_POST['pName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pIn = filter_var(mysqli_real_escape_string($db,$_POST['pIn'])); 
        $pOut = filter_var(mysqli_real_escape_string($db,$_POST['pOut'])); 

        $newSQL = "UPDATE T_Att SET timeIn = '". escapeSingleQuote(strtoupper($pIn)) ."', timeOut = '". escapeSingleQuote(strtoupper($pOut)) ."' where empID = '". escapeSingleQuote(strtoupper($pID)) ."' and attDate = '". escapeSingleQuote(strtoupper($pDate)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Modify Attendance of ". escapeSingleQuote(strtoupper($pName)) ." dated ". $pDate ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    } 
    else if($task == "reset-attendance"){
        $pID = filter_var(mysqli_real_escape_string($db,$_POST['empID']));  
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate']));  

        $newSQL = "DELETE FROM T_Att where empID = '". escapeSingleQuote(strtoupper($pID)) ."' and attDate = '". escapeSingleQuote(strtoupper($pDate)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Reset Attendance dated ". $pDate ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");   
    }
    else if($task == "autocomplete-location"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT locationID, locationName, item.itemID, item.itemName FROM G_Locations source OUTER APPLY (SELECT itemID, itemName FROM G_Items where itemID = source.itemCode) item where locationName like '%". escapeSingleQuote($searchTerm) ."%' and source.archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['locationID'], 
                    'value' => $row['locationName'],
                    'itemCode' => $row['itemID'],
                    'itemName' => $row['itemName']
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-item"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT itemID, itemName FROM G_Items source where itemName like '%". escapeSingleQuote($searchTerm) ."%' and source.archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [ 
                    'id' => $row['itemID'],
                    'value' => $row['itemName']
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-activity"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT activityID, actName, glCode FROM G_Activity source where actName like '%". escapeSingleQuote($searchTerm) ."%' and source.isAct = '1' and source.archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['activityID'], 
                    'value' => $row['actName'],
                    'glCode' => $row['glCode'],
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "remove-activity"){
        $workID = filter_var(mysqli_real_escape_string($db,$_POST['workID'])); 
        $aName = filter_var(mysqli_real_escape_string($db,$_POST['aName'])); 
        $aDate = filter_var(mysqli_real_escape_string($db,$_POST['aDate'])); 

        $newSQL = "DELETE FROM T_Activities where workID = '". $workID ."'";
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();     

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Delete Activity - ". escapeSingleQuote(strtoupper($aName)) ." dated ". $aDate .")', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }
    else if($task == "new-groupworkload"){
        $aDate = filter_var(mysqli_real_escape_string($db,$_POST['aDate'])); 
        $aID = filter_var(mysqli_real_escape_string($db,$_POST['aID']));  
        $aName = filter_var(mysqli_real_escape_string($db,$_POST['aName']));  
        $aActID = filter_var(mysqli_real_escape_string($db,$_POST['aActID']));  
        $aAct = filter_var(mysqli_real_escape_string($db,$_POST['aAct'])); 
        $aRep = filter_var(mysqli_real_escape_string($db,$_POST['aRep'])); 
        $aRate = filter_var(mysqli_real_escape_string($db,$_POST['aRate']));   
        $dRate = filter_var(mysqli_real_escape_string($db,$_POST['dRate']));  
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID']));  
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $aTotal = filter_var(mysqli_real_escape_string($db,$_POST['aTotal']));  
        $aActGL = filter_var(mysqli_real_escape_string($db,$_POST['aActGL']));      
        $mIn = filter_var(mysqli_real_escape_string($db,$_POST['mIn']));  
        $mOut = filter_var(mysqli_real_escape_string($db,$_POST['mOut']));  

        $empID = explode(", ", $aID);
        $empName = explode(", ", $aName);

        for($x = 0; $x < count($empID); $x++){

            $newSQL = "MERGE INTO T_Att AS target
            USING (SELECT '" . escapeSingleQuote(strtoupper($empID[$x])) . "' AS empID, 
                          '" . escapeSingleQuote(strtoupper($aDate)) . "' AS attDate,
                          '" . escapeSingleQuote(strtoupper($empName[$x])) . "' AS fullName,
                          '" . escapeSingleQuote(strtoupper($mIn)) . "' AS timeIn,
                          '" . escapeSingleQuote(strtoupper($mOut)) . "' AS timeOut) AS source
            ON target.empID = source.empID AND target.attDate = source.attDate
            WHEN MATCHED THEN
                UPDATE SET 
                    target.fullName = source.fullName,
                    target.timeIn = source.timeIn,
                    target.timeOut = source.timeOut,
                    target.archiveID = '0'
            WHEN NOT MATCHED THEN
                INSERT (empID, fullName, attDate, timeIn, timeOut, archiveID)
                VALUES (source.empID, source.fullName, source.attDate, source.timeIn, source.timeOut, '0');
            ";
            
            //newSQL = "INSERT INTO T_Att (empID, fullName, attDate, timeIn, timeOut, archiveID) VALUES ('". escapeSingleQuote(strtoupper($empID[$x])) ."','". escapeSingleQuote(strtoupper($empName[$x])) ."','". escapeSingleQuote(strtoupper($aDate)) ."','". escapeSingleQuote(strtoupper($mIn)) ."','". escapeSingleQuote(strtoupper($mOut)) ."','0')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Enter Attendance of ". escapeSingleQuote(strtoupper($empName[$x])) ." dated ". $aDate ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute();  

            $newSQL = "INSERT INTO T_Activities (attDate, empID, fullname, actID, actName, repitition, rate, fixRate, locID, itemCode, isRel, archiveID, totalRate, glCode) values ('". escapeSingleQuote(strtoupper($aDate)) ."','". escapeSingleQuote(strtoupper($empID[$x])) ."','". escapeSingleQuote(strtoupper($empName[$x])) ."','". escapeSingleQuote(strtoupper($aActID)) ."','". escapeSingleQuote(strtoupper($aAct)) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$aRep))) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$aRate))) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$dRate))) ."','". escapeSingleQuote(strtoupper($lID)) ."','". escapeSingleQuote(strtoupper($iID)) ."','0','0','". escapeSingleQuote(strtoupper(str_replace(',','',$aTotal))) ."','". escapeSingleQuote(strtoupper($aActGL)) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'New Workload - ". escapeSingleQuote(strtoupper($empName[$x])) ." dated ". $aDate . "', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 
        } 

        echo json_encode("saved");    
    }
    else if($task == "new-workload"){
        $aDate = filter_var(mysqli_real_escape_string($db,$_POST['aDate'])); 
        $aID = filter_var(mysqli_real_escape_string($db,$_POST['aID']));  
        $aName = filter_var(mysqli_real_escape_string($db,$_POST['aName']));  
        $aActID = filter_var(mysqli_real_escape_string($db,$_POST['aActID']));  
        $aAct = filter_var(mysqli_real_escape_string($db,$_POST['aAct'])); 
        $aRep = filter_var(mysqli_real_escape_string($db,$_POST['aRep'])); 
        $aRate = filter_var(mysqli_real_escape_string($db,$_POST['aRate']));   
        $dRate = filter_var(mysqli_real_escape_string($db,$_POST['dRate']));  
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID']));  
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $aTotal = filter_var(mysqli_real_escape_string($db,$_POST['aTotal']));  
        $aActGL = filter_var(mysqli_real_escape_string($db,$_POST['aActGL']));     

        $newSQL = "INSERT INTO T_Activities (attDate, empID, fullname, actID, actName, repitition, rate, fixRate, locID, itemCode, isRel, archiveID, totalRate, glCode) values ('". escapeSingleQuote(strtoupper($aDate)) ."','". escapeSingleQuote(strtoupper($aID)) ."','". escapeSingleQuote(strtoupper($aName)) ."','". escapeSingleQuote(strtoupper($aActID)) ."','". escapeSingleQuote(strtoupper($aAct)) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$aRep))) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$aRate))) ."','". escapeSingleQuote(strtoupper(str_replace(',','',$dRate))) ."','". escapeSingleQuote(strtoupper($lID)) ."','". escapeSingleQuote(strtoupper($iID)) ."','0','0','". escapeSingleQuote(strtoupper(str_replace(',','',$aTotal))) ."','". escapeSingleQuote(strtoupper($aActGL)) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'New Workload - ". escapeSingleQuote(strtoupper($aName)) ." dated ". $aDate . "', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    }
    else if($task == "check-workload"){
        $workID = filter_var(mysqli_real_escape_string($db,$_POST['workID']));  
        $itemSQL = "SELECT attDate, workID,  empID, fullname, actID, actName, repitition, rate, fixRate, locID, source.itemCode, isRel, archiveID, totalRate, glCode, loc.locationName, item.itemName FROM T_Activities source OUTER APPLY (SELECT locationName FROM G_Locations where locationID = source.locID) loc OUTER APPLY (SELECT itemName FROM G_Items where itemID = source.itemCode) item where workID = '". escapeSingleQuote($workID) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){  
            foreach($itemRES as $row){  
                $itemJSON = $itemRES;
            }    
        }
        else{
            $itemJSON = '';
        }  
        echo json_encode($itemJSON);
    }
    else if($task == "modify-workload"){
        $aDate = filter_var(mysqli_real_escape_string($db,$_POST['aDate'])); 
        $aID = filter_var(mysqli_real_escape_string($db,$_POST['aID']));  
        $aName = filter_var(mysqli_real_escape_string($db,$_POST['aName']));  
        $aActID = filter_var(mysqli_real_escape_string($db,$_POST['aActID']));  
        $aAct = filter_var(mysqli_real_escape_string($db,$_POST['aAct'])); 
        $aRep = filter_var(mysqli_real_escape_string($db,$_POST['aRep'])); 
        $aRate = filter_var(mysqli_real_escape_string($db,$_POST['aRate']));   
        $dRate = filter_var(mysqli_real_escape_string($db,$_POST['dRate']));  
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID']));  
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $aTotal = filter_var(mysqli_real_escape_string($db,$_POST['aTotal']));  
        $aActGL = filter_var(mysqli_real_escape_string($db,$_POST['aActGL']));     
        $workID = filter_var(mysqli_real_escape_string($db,$_POST['workID']));     

        $newSQL = "UPDATE T_Activities SET actID = '". escapeSingleQuote(strtoupper($aActID)) ."', actName = '". escapeSingleQuote(strtoupper($aAct)) ."', repitition = '". escapeSingleQuote(strtoupper(str_replace(',','',$aRep))) ."', rate = '". escapeSingleQuote(strtoupper(str_replace(',','',$aRate))) ."', locID = '". escapeSingleQuote(strtoupper($lID)) ."', itemCode = '". escapeSingleQuote(strtoupper($iID)) ."', totalRate = '". escapeSingleQuote(strtoupper(str_replace(',','',$aTotal))) ."', glCode = '". escapeSingleQuote(strtoupper($aActGL)) ."' where workID = '". escapeSingleQuote(strtoupper($workID)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Modify Workload - ". escapeSingleQuote(strtoupper($aName)) ." dated ". $aDate . "', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");    
    }
    else if($task == "gen-workload"){
        $mindate = filter_var(mysqli_real_escape_string($db,$_POST['mindate'])); 
        $maxdate = filter_var(mysqli_real_escape_string($db,$_POST['maxdate']));  

        // Example data
        $response = array(
            array(
                'min' => $mindate,
                'max' => $maxdate 
            )
        );

        echo json_encode($response); 
    }

    // LOANS
    else if($task == "autocomplete-loaner"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT 'G-'+ CAST(buyingID AS VARCHAR(20)) code, buyName + ' - SUPPLIER' loanerName  FROM G_Buying where isSupplier = '1' and archiveID = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'B-'+ CAST(buyingID AS VARCHAR(20)) code, buyName + ' - BUYING' loanerName  FROM G_Buying where isSupplier = '0' and archiveID = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'E-'+ CAST(empID AS VARCHAR(20)) code, fullname + ' - EMPLOYEE' loanerName FROM G_Employee where archiveID = '0' and fullname like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY loanerName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['loanerName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    } 
    else if($task == "new-loan"){
        $loanerID = filter_var(mysqli_real_escape_string($db,$_POST['loanerID'])); 
        $loanerName = filter_var(mysqli_real_escape_string($db,$_POST['loanerName']));  
        $loanerDate = filter_var(mysqli_real_escape_string($db,$_POST['loanerDate'])); 
        $loanerAmt = filter_var(mysqli_real_escape_string($db,$_POST['loanerAmt']));   
        $loanerDed = filter_var(mysqli_real_escape_string($db,$_POST['loanerDed']));   

        $date = new DateTime($loanerDate); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(loanRef,'L". $yearMonth ."-','') AS INT)), 0) AS max_num FROM L_Loans WHERE loanRef LIKE '%L". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
        }

        $nextNumber = $ref + 1;
        $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
        $loanRef = 'L' . $yearMonth . '-' . $formattedNumber;

        $checkSQL = "SELECT * FROM L_Loans where loanerCode = '". escapeSingleQuote(strtoupper($loanerID)) ."' and loanBal <> 0 and loanStats = '8'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            echo json_encode("existing");    
        }
        else{
            $newSQL = "INSERT INTO L_Loans (loanerCode, loanRef, loanerName, loanDate, loanStats, loanAmt, loanBal, deduction) VALUES ('". escapeSingleQuote(strtoupper($loanerID)) ."','". escapeSingleQuote(strtoupper($loanRef)) ."','". escapeSingleQuote(strtoupper($loanerName)) ."','". escapeSingleQuote(strtoupper($loanerDate)) ."','0','". escapeSingleQuote(strtoupper($loanerAmt)) ."','". escapeSingleQuote(strtoupper($loanerAmt)) ."', '". escapeSingleQuote(strtoupper($loanerDed)) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    
    
            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'New Loan for ". escapeSingleQuote(strtoupper($loanerName)) ." dated ". $loanerDate ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 

            echo json_encode("saved");   
        } 
    }
    else if($task == "rel-loan"){
        $loanerRef = filter_var(mysqli_real_escape_string($db,$_POST['loanerRef'])); 
        $releaseDate = filter_var(mysqli_real_escape_string($db,$_POST['releaseDate']));  
        $lAmt = filter_var(mysqli_real_escape_string($db,$_POST['lAmt']));  
         
        $newSQL = "UPDATE L_Loans SET loanStats = '8', releaseDate = '". escapeSingleQuote(strtoupper($releaseDate)) ."' where loanRef = '". escapeSingleQuote(strtoupper($loanerRef)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();     

        $newSQL = "INSERT INTO L_History (loanRef, paymentDate, paymentAmt, isCash, runningBal, remarks ,aType) values ('". escapeSingleQuote(strtoupper($loanerRef)) ."' , '". escapeSingleQuote(strtoupper($releaseDate)) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."','0', '". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."','LOAN RELEASED','release')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $caDate = date("Y-m-d"); 
        $particulars = "LOAN ADVANCES";   
        $preparedBy = $fullname;  
        $date = new DateTime($caDate); 
        $yearMonth = $date->format('Ym');
        
        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(caRef,'CA". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_CA WHERE caRef LIKE '%CA". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);     
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
        }  
        $nextNumber = $ref + 1;
        $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
        $caRef = 'CA' . $yearMonth . '-' . $formattedNumber;  

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(liqRef,'LIQ". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_LIQ WHERE liqRef LIKE '%LIQ". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            } 
            if($ref == "0"){
                $ref = "LIQ" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'LIQ' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "LIQ" . $yearMonth . "-00001";
        }    
        
        // CA PREPARATION
        $checkSQL = "SELECT 'E-' + CAST(empID as varchar) payeeID, fullName + ' - EMPLOYEE' payeeName FROM G_Employee where isPayroll = '1'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $payeeID = $row['payeeID'];
                $payeeName = $row['payeeName'];
            }
        }    


        $checkSQL = "SELECT loanerCode, loanerName FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanerRef)) ."'"; 
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $loanerCode = $row['loanerCode'];
                $loanerName = $row['loanerName'];
            }
        }    

        $checkSQL = "SELECT glCode, actName FROM G_Activity where isAct = '3' and actName = 'ADVANCES'"; 
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $glCode = $row['glCode'];
                $actName = $row['actName'];
            }
        }    

        $newSQL = "INSERT INTO O_CA (caRef, caDate, particulars, caAmt, balAmt, status, preparedBy, releasedBy, payeeID, payeeName, isCharge) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."', '0','8','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."','". escapeSingleQuote(strtoupper($loanerName)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName, slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','0','','0','','". escapeSingleQuote(strtoupper($loanerCode)) ."', '". escapeSingleQuote(strtoupper($loanerName)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  

        $newSQL = "INSERT INTO O_LIQ (liqRef, liqDate, particulars, liqAmt, preparedBy, payeeID, payeeName, status, caRef) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper(date("Y-m-d"))) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$preparedBy))) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."','". escapeSingleQuote(strtoupper($loanerName)) ."','0','". escapeSingleQuote(strtoupper($caRef)) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."', '". escapeSingleQuote(strtoupper($loanerName)) ."','ADVANCES','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanerRef)) ."', 'Loan # ". escapeSingleQuote(strtoupper($loanerRef)) ." Released', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("release");    
    }
    else if($task == "modify-loan"){
        $loanerID = filter_var(mysqli_real_escape_string($db,$_POST['loanerID'])); 
        $loanerName = filter_var(mysqli_real_escape_string($db,$_POST['loanerName']));  
        $loanerDate = filter_var(mysqli_real_escape_string($db,$_POST['loanerDate'])); 
        $loanerAmt = filter_var(mysqli_real_escape_string($db,$_POST['loanerAmt']));   
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));
        $loanerDed = filter_var(mysqli_real_escape_string($db,$_POST['loanerDed']));   
          
        $newSQL = "UPDATE L_Loans SET deduction = '". escapeSingleQuote(strtoupper(str_replace(",","",$loanerDed))) ."', loanerCode = '". escapeSingleQuote(strtoupper($loanerID)) ."', loanerName = '". escapeSingleQuote(strtoupper($loanerName)) ."', loanDate = '". escapeSingleQuote(strtoupper($loanerDate)) ."', loanAmt = '". escapeSingleQuote(strtoupper(str_replace(",","",$loanerAmt))) ."', loanBal = '". escapeSingleQuote(strtoupper(str_replace(",","",$loanerAmt))) ."' where loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Modify Loan for ". escapeSingleQuote(strtoupper($loanerName)) ." dated ". $loanerDate ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");  
    }
    else if($task == "remove-loan"){  
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));
          
        $newSQL = "UPDATE L_Loans SET loanStats = '3' where loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Cancel Loan # ". escapeSingleQuote(strtoupper($loanRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("archive");  
    }
    else if($task == "get-loan"){
        $loanerID = filter_var(mysqli_real_escape_string($db,$_POST['loanerID']));

        $itemSQL = "SELECT loanRef FROM L_Loans where loanerCOde = '". escapeSingleQuote(strtoupper($loanerID)) ."' and loanBal <> '0.0000' and loanStats = '8'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        }  
        else{
            $data[] = null;
        }
        echo json_encode($data);
    }
    else if($task == "get-bal"){
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));

        $itemSQL = "SELECT loanBal FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        }  
        echo json_encode($data);
    }
    else if($task == "new-adj"){
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));
        $loanBal = filter_var(mysqli_real_escape_string($db,$_POST['loanBal']));
        $adjType = filter_var(mysqli_real_escape_string($db,$_POST['adjType']));
        $mopType = filter_var(mysqli_real_escape_string($db,$_POST['mopType']));
        $loanerDate = filter_var(mysqli_real_escape_string($db,$_POST['loanerDate']));
        $loanerAmt = filter_var(mysqli_real_escape_string($db,$_POST['loanerAmt']));
   
        if($mopType == "cash") $isCash = "1";
        else if($mopType == "salary") $isCash = "2";
        else if($mopType == "item") $isCash = "3";
        else if($mopType == "others") $isCash = "0";

        if($adjType == "deduct") {
            $bal = $loanBal - $loanerAmt;  
            if($bal < 0){
                echo json_encode("less");  
            }else{
                $newSQL = "INSERT INTO L_History (loanRef, paymentDate, paymentAmt, isCash, runningBal, remarks, aType) values ('". escapeSingleQuote(strtoupper($loanRef)) ."' , '". escapeSingleQuote(strtoupper($loanerDate)) ."', '". escapeSingleQuote(strtoupper($loanerAmt)) ."','". $isCash ."', '". escapeSingleQuote(strtoupper($bal)) ."','LOAN DEDUCTION', '". $adjType ."')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $newSQL = "UPDATE L_Loans SET loanBal = '". $bal ."' where  loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Adjustment for Loan #". escapeSingleQuote(strtoupper($loanRef)) ."', '". $ipAddress ."')"; 
                $logsOBJ = $mssql->prepare($logSQL);
                $logsOBJ->execute(); 

                echo json_encode("saved");  
            }    
        }
        else if($adjType == "add"){
            $checkSQL = "SELECT loanAmt FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $loanTotal = $row['loanAmt'];
                }
            } 

            $bal = $loanBal + $loanerAmt;  

            if($bal > $loanTotal){
                echo json_encode("greater");  
            }else{
                $newSQL = "INSERT INTO L_History (loanRef, paymentDate, paymentAmt, isCash, runningBal, remarks, aType) values ('". escapeSingleQuote(strtoupper($loanRef)) ."' , '". escapeSingleQuote(strtoupper($loanerDate)) ."', '". escapeSingleQuote(strtoupper($loanerAmt)) ."','0', '". escapeSingleQuote(strtoupper($bal)) ."','LOAN - ADJUSTMENT', '". $adjType ."')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $newSQL = "UPDATE L_Loans SET loanBal = '". $bal ."' where  loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Adjustment for Loan #". escapeSingleQuote(strtoupper($loanRef)) ."', '". $ipAddress ."')"; 
                $logsOBJ = $mssql->prepare($logSQL);
                $logsOBJ->execute();   

                echo json_encode("saved");  
            }
        }     
    } 

    else if($task == "autocomplete-charges"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT glCode, actName FROM G_Activity where isAct = '0' and actName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY actName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['glCode'], 
                    'value' => $row['actName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-slref"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT 'C-'+ CAST(companyID AS VARCHAR(20)) code, companyName + ' - COMPANY' loanerName  FROM G_Company where archiveID = '0' and companyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'B-'+ CAST(buyingID AS VARCHAR(20)) code, buyName + ' - BUYING' loanerName  FROM G_Buying where archiveID = '0' and isSupplier = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'G-'+ CAST(buyingID AS VARCHAR(20)) code, buyName + ' - SUPPLIER' loanerName  FROM G_Buying where archiveID = '0' and isSupplier = '1' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'E-'+ CAST(empID AS VARCHAR(20)) code, fullname + ' - EMPLOYEE' loanerName FROM G_Employee where archiveID = '0' and fullname like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'W-'+CAST(locationID AS VARCHAR(20)) code, locationName + ' - LOCATION' FROM G_Locations where archiveID = '0' and locationName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'T-'+CAST(truckID AS VARCHAR(20)) code, truckName + ' - TRUCKING' FROM G_Truck where archiveID = '0' and truckName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' UNION ALL SELECT 'I-'+CAST(itemID AS VARCHAR(20)) code, itemName + ' - ITEM' FROM G_Items where archiveID = '0' and itemName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY code ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['loanerName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "new-ca"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName']));  
        $caDate = filter_var(mysqli_real_escape_string($db,$_POST['caDate'])); 
        $particulars = filter_var(mysqli_real_escape_string($db,$_POST['particulars']));   
        $preparedBy = filter_var(mysqli_real_escape_string($db,$_POST['preparedBy'])); 
        $totalcaAmt = filter_var(mysqli_real_escape_string($db,$_POST['totalcaAmt']));    
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime($caDate); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(caRef,'CA". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_CA WHERE caRef LIKE '%CA". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
        }

        $nextNumber = $ref + 1;
        $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
        $caRef = 'CA' . $yearMonth . '-' . $formattedNumber; 

        $newSQL = "INSERT INTO O_CA (caRef, caDate, particulars, caAmt, balAmt, status, preparedBy, releasedBy, payeeID, payeeName, isCharge) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."','0','". escapeSingleQuote(strtoupper($preparedBy)) ."','','". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    


        foreach ($tableData as $row) {  
            $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName,  slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."', '". escapeSingleQuote(strtoupper($row[4])) ."' , '". escapeSingleQuote(strtoupper($row[5])) ."', '". escapeSingleQuote(strtoupper($row[6])) ."', '". escapeSingleQuote(strtoupper($row[7])) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$row[8]))) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
        }

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Creation of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "modify-ca"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName']));  
        $caDate = filter_var(mysqli_real_escape_string($db,$_POST['caDate'])); 
        $particulars = filter_var(mysqli_real_escape_string($db,$_POST['particulars']));   
        $preparedBy = filter_var(mysqli_real_escape_string($db,$_POST['preparedBy'])); 
        $totalcaAmt = filter_var(mysqli_real_escape_string($db,$_POST['totalcaAmt']));    
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);
  
        $newSQL = "UPDATE O_CA SET particulars = '". escapeSingleQuote(strtoupper($particulars)) ."', caAmt = '". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', balAmt = '". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', payeeID = '". escapeSingleQuote(strtoupper($payeeID)) ."', payeeName = '". escapeSingleQuote(strtoupper($payeeName)) ."' where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $delSQL = "DELETE FROM O_CADet where caRef = '". $caRef ."'"; 
        $delOBJ = $mssql->prepare($delSQL);
        $delOBJ->execute(); 

        foreach ($tableData as $row) {  
            $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName,  slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."', '". escapeSingleQuote(strtoupper($row[4])) ."' , '". escapeSingleQuote(strtoupper($row[5])) ."', '". escapeSingleQuote(strtoupper($row[6])) ."', '". escapeSingleQuote(strtoupper($row[7])) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$row[8]))) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
        }

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Revision of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-ca"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
 
        $newSQL = "UPDATE O_CA SET status = '3' where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Cancellation of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "release-ca"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
        $fName = filter_var(mysqli_real_escape_string($db,$_POST['fName'])); 
 
        $newSQL = "UPDATE O_CA SET status = '8', releasedBy = '". escapeSingleQuote(strtoupper($fName)) ."' where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Releasing of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "unrelease-ca"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
        $fName = filter_var(mysqli_real_escape_string($db,$_POST['fName'])); 
 
        $newSQL = "UPDATE O_CA SET status = '0', releasedBy = NULL where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Unreleasing of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "get-ca"){ 
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID']));
  
        $itemSQL = "SELECT caRef FROM O_CA where payeeID = '". escapeSingleQuote(strtoupper($payeeID)) ."' and balAmt <> '0.0000' and status = '8'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        }  
        echo json_encode($data); 
    }
    else if($task == "get-cadetails"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef']));
  
        $itemSQL = "SELECT glCode, mainAcct, slID, slRef, '' orNo,  amount FROM O_CADet where caRef = '". escapeSingleQuote(strtoupper($caRef)) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $data = $itemOBJ->fetchAll(PDO::FETCH_ASSOC); 
        
        echo json_encode($data); 
    }
    else if($task == "get-cadetails2"){
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef']));
  
        $itemSQL = "SELECT caDate, particulars, FORMAT(balAmt, 'N2') balAmt, FORMAT(caAmt, 'N2') caAmt FROM O_CA where caRef = '". escapeSingleQuote(strtoupper($caRef)) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $data = $itemOBJ->fetchAll(PDO::FETCH_ASSOC); 
        
        echo json_encode($data); 
    } 

    else if($task == "new-liq"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName']));  
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
        $particulars = filter_var(mysqli_real_escape_string($db,$_POST['particulars']));   
        $preparedBy = filter_var(mysqli_real_escape_string($db,$_POST['preparedBy'])); 
        $totalBAL = filter_var(mysqli_real_escape_string($db,$_POST['totalBAL']));    
        $totalLIQ = filter_var(mysqli_real_escape_string($db,$_POST['totalLIQ']));
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime(date("Y-m-d")); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(liqRef,'LIQ". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_LIQ WHERE liqRef LIKE '%LIQ". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
 
            if($ref == "0"){
                $ref = "LIQ" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'LIQ' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "LIQ" . $yearMonth . "-00001";
        } 

        $newSQL = "INSERT INTO O_LIQ (liqRef, liqDate, particulars, liqAmt, preparedBy, payeeID, payeeName, status, caRef) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper(date("Y-m-d"))) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalLIQ))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$preparedBy))) ."','". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."','0','". escapeSingleQuote(strtoupper($caRef)) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  

        foreach ($tableData as $row) {  
            $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[4]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[5]))) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
        }

        $newBal = (float)str_replace(",","",$totalBAL) - (float)str_replace(",","",$totalLIQ); 

        if((float)str_replace(",","",$totalLIQ) == 0){
            $newSQL = "UPDATE O_CA SET balAmt = '0' where caRef = '". $caRef ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    
        }
        else{
            $newSQL = "UPDATE O_CA SET balAmt = '". str_replace(",","", $newBal) ."' where caRef = '". $caRef ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    
        } 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Liquidation #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "modify-liq"){
        $ref = filter_var(mysqli_real_escape_string($db,$_POST['liqRef'])); 
        $liqDate = filter_var(mysqli_real_escape_string($db,$_POST['liqDate'])); 
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName']));  
        $caRef = filter_var(mysqli_real_escape_string($db,$_POST['caRef'])); 
        $caDate = filter_var(mysqli_real_escape_string($db,$_POST['caDate'])); 
        $particulars = filter_var(mysqli_real_escape_string($db,$_POST['particulars']));   
        $preparedBy = filter_var(mysqli_real_escape_string($db,$_POST['preparedBy'])); 
        $totalBAL = filter_var(mysqli_real_escape_string($db,$_POST['totalBAL']));    
        $existingLiq = filter_var(mysqli_real_escape_string($db,$_POST['existingLiq']));    
        $totalLIQ = filter_var(mysqli_real_escape_string($db,$_POST['totalLIQ']));
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);
   
        $newSQL = "UPDATE O_LIQ SET particulars = '". escapeSingleQuote(strtoupper($particulars)) ."', liqAmt = '". escapeSingleQuote(strtoupper(str_replace(",","",$totalLIQ))) ."' where liqRef = '". escapeSingleQuote(strtoupper($ref)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  
 
        $newSQL = "DELETE FROM O_LiqDet where liqRef = '". escapeSingleQuote(strtoupper($ref)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        foreach ($tableData as $row) {  
            $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[4]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[5]))) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
        }

        $newBal = ((float)str_replace(",","",$totalBAL) + (float)str_replace(",","",$existingLiq)) - (float)str_replace(",","",$totalLIQ); 

        $newSQL = "UPDATE O_CA SET balAmt = '". str_replace(",","", $newBal) ."' where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Liquidation #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "approve-liq"){
        $liqRef = filter_var(mysqli_real_escape_string($db,$_POST['liqRef']));  
 
        $newSQL = "UPDATE O_Liq SET status = '1' where liqRef = '". $liqRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($liqRef)) ."', 'Approving of Liquidation #". escapeSingleQuote(strtoupper($liqRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-liq"){
        $liqRef = filter_var(mysqli_real_escape_string($db,$_POST['liqRef']));  
 
        $newSQL = "UPDATE O_Liq SET status = '3' where liqRef = '". $liqRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    
 
        $checkSQL = "SELECT SUM(amount) amount, source.caRef FROM O_Liq source INNER JOIN O_LiqDet det ON source.liqRef = det.liqRef WHERE source.liqRef = '". $liqRef ."' GROUP BY source.caRef";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $amount = $row['amount'];
                $caRef = $row['caRef'];
            }
        } 

        $checkSQL = "SELECT balAmt FROM O_CA WHERE caRef = '". $caRef ."'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $balAmt = $row['balAmt']; 
            }
        }  

        $newBal = $balAmt + $amount;

        $newSQL = "UPDATE O_Liq SET status = '3' where liqRef = '". $liqRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $newSQL = "UPDATE O_CA SET balAmt = '". $newBal ."' where caRef = '". $caRef ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($liqRef)) ."', 'Cancellation of Liquidation #". escapeSingleQuote(strtoupper($liqRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("cancelled");
    } 
    else if($task == "get-liqdetails"){
        $liqRef = filter_var(mysqli_real_escape_string($db,$_POST['liqRef']));
  
        $itemSQL = "SELECT glCode, mainAcct, slID, slRef, orNo, amount FROM O_LiqDet where liqRef = '". escapeSingleQuote(strtoupper($liqRef)) ."' ORDER BY mainAcct, slID ASC;";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $data = $itemOBJ->fetchAll(PDO::FETCH_ASSOC); 
        
        echo json_encode($data); 
    }
    else if($task == "get-liqdetails2"){
        $liqRef = filter_var(mysqli_real_escape_string($db,$_POST['liqRef']));
  
        $itemSQL = "SELECT particulars, FORMAT(caDet.balAmt, 'N2') balAmt, FORMAT(caDet.caAmt, 'N2') caAmt, caDet.caDate FROM O_Liq source OUTER APPLY(SELECT balAmt, caAmt, caDate FROM O_CA where caRef = source.caRef) caDet where liqRef = '". escapeSingleQuote(strtoupper($liqRef)) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $data = $itemOBJ->fetchAll(PDO::FETCH_ASSOC); 
        
        echo json_encode($data); 
    }   

    else if($task == "convert-salary"){
        $response = [];
        $checkedValues = $_POST['checkedValues']; 
        $startDate = filter_var(mysqli_real_escape_string($db,$_POST['startDate'])); 
        $endDate = filter_var(mysqli_real_escape_string($db,$_POST['endDate'])); 
        $fullname = filter_var(mysqli_real_escape_string($db,$_POST['fullname'])); 

        if (is_array($checkedValues)) {
            // Initialize an array to hold processed data
            $processedData = [];
    
            $caDate = date("Y-m-d"); 
            $particulars = "SALARY FOR DATE " .  $startDate . " TO " . $endDate;   
            $preparedBy = $fullname;  
            $date = new DateTime($caDate); 
            $yearMonth = $date->format('Ym');
            
            $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(caRef,'CA". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_CA WHERE caRef LIKE '%CA". $yearMonth ."-%'";
            $checkOBJ = $mssql->prepare($checkSQL);     
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $ref = $row['max_num'];
                }
            }  
            $nextNumber = $ref + 1;
            $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
            $caRef = 'CA' . $yearMonth . '-' . $formattedNumber;  

            $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(liqRef,'LIQ". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_LIQ WHERE liqRef LIKE '%LIQ". $yearMonth ."-%'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $ref = $row['max_num'];
                } 
                if($ref == "0"){
                    $ref = "LIQ" . $yearMonth . "-00001";
                }
                else{
                    $nextNumber = $ref + 1;
                    $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                    $ref = 'LIQ' . $yearMonth . '-' . $formattedNumber; 
                } 
            }
            else{
                $ref = "LIQ" . $yearMonth . "-00001";
            }   

            foreach ($checkedValues as $value) {
                // Process each item in checkedValues
                if (is_array($value)) {
                    $processedItem = [
                        'empID' => isset($value['empID']) ? intval($value['empID']) : null,
                        'empName' => isset($value['empName']) ? trim($value['empName']) : '',
                        'loanRef' => isset($value['loanRef']) ? trim($value['loanRef']) : '',
                        'totalGross' => isset($value['totalGross']) ? floatval(str_replace(',', '', $value['totalGross'])) : 0.0,
                        'activeDed' => isset($value['activeDed']) ? (bool)$value['activeDed'] : false,
                        'deduction' => isset($value['deduction']) ? floatval(str_replace(',', '', $value['deduction'])) : 0.0,
                        'totalNet' => isset($value['totalNet']) ? floatval(str_replace(',', '', $value['totalNet'])) : 0.0
                    ];
    
                    $processedData[] = $processedItem;

                    if (isset($processedItem['empID'])) {
                        $empIDs[] = $processedItem['empID'];
                    }

                    if (isset($processedItem['empName'])) {
                        $empNames[] = $processedItem['empName'];
                    }
                    
                    if (isset($processedItem['totalGross'])) {
                        $totalGross[] = $processedItem['totalGross'];
                    }

                    if (isset($processedItem['activeDed'])) {
                        $activeDed[] = $processedItem['activeDed'];
                    }

                    if (isset($processedItem['deduction'])) {
                        $deduction[] = $processedItem['deduction'];
                    }
                    
                    if (isset($processedItem['totalNet'])) {
                        $totalNet[] = $processedItem['totalNet'];
                    } 

                    if (isset($processedItem['loanRef'])) {
                        $loanRef[] = $processedItem['loanRef'];
                    } 

                    $totalGCA = 0;
                    for($x = 0;$x < count($totalNet);$x++){
                        $totalGCA = $totalGCA + $totalNet[$x];
                    } 
                    $totalcaAmt = $totalGCA;  

                    // CA PREPARATION
                    $checkSQL = "SELECT 'E-' + CAST(empID as varchar) payeeID, fullName payeeName FROM G_Employee where isPayroll = '1'";
                    $checkOBJ = $mssql->prepare($checkSQL);
                    $checkOBJ->execute();
                    $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                    if($checkOBJ ->rowCount() > 0){ 
                        foreach($checkRES as $row){
                            $payeeID = $row['payeeID'];
                            $payeeName = $row['payeeName'] . " - EMPLOYEE";
                        }
                    }    
 
                    $datesBetween = getDatesBetween($startDate, $endDate);
                    $run = 0;
                    foreach ($datesBetween as $date) { 
                        for($x = 0;$x < count($empIDs);$x++){
                            // // ALL ACTIVITIES //
                            $checkSQL = "SELECT source.itemCode, source.locID, item.itemName, location.locationName, 'E-' + CAST(empID as varchar) slID, fullName slRef, glCode, actName mainAcct, totalRate + fixRate amount FROM T_Activities source OUTER APPLY (SELECT itemName FROM G_Items where itemID = source.itemCode) item OUTER APPLY (SELECT locationName FROM G_Locations where locationID = source.locID) location where isRel = '0' and empID = '". $empIDs[$x] ."' and attDate = '". $date ."'";
                            $checkOBJ = $mssql->prepare($checkSQL);
                            $checkOBJ->execute();
                            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                            if($checkOBJ ->rowCount() > 0){ 
                                foreach($checkRES as $row){  
                                    $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName, slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($row['glCode'])) ."', '". escapeSingleQuote(strtoupper($row['mainAcct'])) ."', '". escapeSingleQuote(strtoupper($row['locID'])) ."', '". escapeSingleQuote(strtoupper($row['locationName'])) ."', '". escapeSingleQuote(strtoupper($row['itemCode'])) ."', '". escapeSingleQuote(strtoupper($row['itemName'])) ."', '". escapeSingleQuote(strtoupper($row['slID'])) ."', '". escapeSingleQuote(strtoupper($row['slRef']) ." - EMPLOYEE") ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row['amount']))) ."')"; 
                                    $newOBJ = $mssql->prepare($newSQL);
                                    $newOBJ->execute(); 

                                    $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($row['glCode'])) ."', '". escapeSingleQuote(strtoupper($row['mainAcct'])) ."','". escapeSingleQuote(strtoupper($row['slID'])) ."', '". escapeSingleQuote(strtoupper($row['slRef']) ." - EMPLOYEE") ."','SALARY','". escapeSingleQuote(strtoupper(str_replace(",","",$row['amount']))) ."')"; 
                                    $newOBJ = $mssql->prepare($newSQL);
                                    $newOBJ->execute();  
                                }
                            } 

                            $actSQL = "UPDATE T_Activities SET isRel = '1', caRef = '". $caRef ."', relDate = '". $dateToday ."' where empID = '". $empIDs[$x] ."' and attDate = '". $date ."'";
                            $actOBJ = $mssql->prepare($actSQL);
                            $actOBJ->execute(); 
 
                            // LOANS
                            if ($activeDed[$x] == true && $deduction[$x] != "0.00" && (!empty($loanRef[$x])) && $run == 0) {
                                $checkSQL = "SELECT loanBal FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanRef[$x])) ."'";
                                $checkOBJ = $mssql->prepare($checkSQL);
                                $checkOBJ->execute();
                                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                                if($checkOBJ ->rowCount() > 0){ 
                                    foreach($checkRES as $row){
                                        $loanBal = $row['loanBal']; 
                                    }
                                }    

                                $bal = $loanBal - $deduction[$x]; 

                                // SALARY DEDUCTION ON LOAN //

                                $newSQL = "INSERT INTO L_History (loanRef, paymentDate, paymentAmt, isCash, runningBal, remarks, aType) values ('". escapeSingleQuote(strtoupper($loanRef[$x])) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($deduction[$x])) ."','2', '". escapeSingleQuote(strtoupper($bal)) ."','LOAN DEDUCTION', 'deduction')"; 
                                $newOBJ = $mssql->prepare($newSQL);
                                $newOBJ->execute();

                                $newSQL = "UPDATE L_Loans SET loanBal = '". $bal ."' where  loanRef = '". escapeSingleQuote(strtoupper($loanRef[$x])) ."'"; 
                                $newOBJ = $mssql->prepare($newSQL);
                                $newOBJ->execute();  

                                // SALARY DEDUCTION ENTRY ON EXPENSE //

                                $checkSQL = "SELECT glCode, actName FROM G_Activity where actName = 'ADVANCES' and isAct = '3'";
                                $checkOBJ = $mssql->prepare($checkSQL);
                                $checkOBJ->execute();
                                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                                if($checkOBJ ->rowCount() > 0){ 
                                    foreach($checkRES as $row){
                                        $glCode = $row['glCode']; 
                                        $actName = $row['actName']; 
                                    }
                                }  

                                // CHECK SL REF
                                $checkSQL = "SELECT loanerCode slID, loanerName slRef FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanRef[$x])) ."'"; 
                                $checkOBJ = $mssql->prepare($checkSQL);
                                $checkOBJ->execute();
                                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                                if($checkOBJ ->rowCount() > 0){ 
                                    foreach($checkRES as $row){
                                        $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName, slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','0','','0','','". escapeSingleQuote(strtoupper($row['slID'])) ."', '". escapeSingleQuote(strtoupper($row['slRef'])) ."','". escapeSingleQuote(strtoupper(($deduction[$x] *-1))) ."')"; 
                                        $newOBJ = $mssql->prepare($newSQL);
                                        $newOBJ->execute(); 
        
                                        $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','". escapeSingleQuote(strtoupper($row['slID'])) ."', '". escapeSingleQuote(strtoupper($row['slRef'])) ."','SALARY','". escapeSingleQuote(strtoupper(($deduction[$x] *-1))) ."')"; 
                                        $newOBJ = $mssql->prepare($newSQL);
                                        $newOBJ->execute(); 
                                    }
                                }   

                                $run++; 
                            }
                        }
                    }   
                } 
            } 

            $newSQL = "INSERT INTO O_CA (caRef, caDate, particulars, caAmt, balAmt, status, preparedBy, releasedBy, payeeID, payeeName, isCharge) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', '0','8','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."','0')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    

            $newSQL = "INSERT INTO O_LIQ (liqRef, liqDate, particulars, liqAmt, preparedBy, payeeID, payeeName, status, caRef) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper(date("Y-m-d"))) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$preparedBy))) ."','". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."','0','". escapeSingleQuote(strtoupper($caRef)) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Convertion of Salary to Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute();  

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Convertion of Salary to Liquidation #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute();  

            echo json_encode("saved"); 
        }  
    }
    else if($task == "check-semp"){
        $startDateStr = filter_var(mysqli_real_escape_string($db,$_POST['startDateStr'])); 
        $endDateStr = filter_var(mysqli_real_escape_string($db,$_POST['endDateStr'])); 

        $itemSQL = "SELECT source.empID, source.fullname, ISNULL(loan.loanRef,'') loanRef, FORMAT(CAST(ISNULL(SUM(salary.gross), 0) AS DECIMAL(18, 2)), 'N', 'en-US') AS grossSal, FORMAT(CAST(ISNULL(deduction.deduction, 0) AS DECIMAL(18, 2)), 'N', 'en-US') AS deduction FROM G_Employee source OUTER APPLY (SELECT (fixRate + totalRate) AS gross FROM T_Activities WHERE empID = source.empID AND isRel = '0' AND attDate BETWEEN '". $startDateStr ."' AND '". $endDateStr ."') salary OUTER APPLY (SELECT SUM(CASE WHEN deduction > loanBal THEN loanBal ELSE deduction END) AS deduction FROM L_Loans WHERE loanerCode LIKE '%E-%' AND REPLACE(loanerCode, 'E-', '') = source.empID AND loanBal <> 0 and loanStats = '8') deduction OUTER APPLY (SELECT DISTINCT STUFF((SELECT '/' + loanRef FROM L_Loans loans WHERE loanBal <> 0 and loanStats = '8' AND loanerCode LIKE '%E-%' AND REPLACE(loanerCode, 'E-', '') = source.empID FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 1, '') AS loanRef FROM L_Loans) loan WHERE source.archiveID = '0' GROUP BY source.empID, source.fullname, deduction.deduction, loan.loanRef ORDER BY source.fullname ASC;";
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_ASSOC); 
        $data = []; 
        foreach ($itemRES as $index => $row) {
            $grossSalValue = str_replace([',', '$'], '', $row['grossSal']);
            $loanDeductionValue = str_replace([',', '$'], '', $row['deduction']);
            $data[] = [
                'empID' => $row['empID'],
                'fullname' => $row['fullname'],
                'loanRef' => $row['loanRef'],
                'grossSalValue' => $grossSalValue,
                'loanDeductionValue' => $loanDeductionValue,
            ];
        }

        echo json_encode($data);
    } 
    else if($task == "autocomplete-buyer"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT CAST(buyingID AS VARCHAR(20)) code, buyName  FROM G_Buying where archiveID = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY buyName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['buyName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-buyerlist"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT CAST(buyingID AS VARCHAR(20)) code, buyName  FROM G_Buying where isSupplier = '0' and archiveID = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY buyName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['buyName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }

    else if($task == "check-inventory"){ 
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID'])); 
        $lName = filter_var(mysqli_real_escape_string($db,$_POST['lName']));  
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName'])); 
        $iSack = filter_var(mysqli_real_escape_string($db,$_POST['iSack'])); 
        $iWeight = filter_var(mysqli_real_escape_string($db,$_POST['iWeight']));  
        $iDeduction = filter_var(mysqli_real_escape_string($db,$_POST['iDeduction']));  
        $iNet = filter_var(mysqli_real_escape_string($db,$_POST['iNet'])); 
        $iPrice = filter_var(mysqli_real_escape_string($db,$_POST['iPrice'])); 
        $tPrice = filter_var(mysqli_real_escape_string($db,$_POST['tPrice'])); 
        $iReceipt = filter_var(mysqli_real_escape_string($db,$_POST['iReceipt']));    

        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);
 
        $exist = false;
        $weights = 0;
        $eWeight = 0;

        // CHECK CAPACITY //
        $itemSQL = "SELECT itemCode FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($lID)) ."'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                if ($iID != $row['itemCode'])
                {
                    $exist = true;
                }  
            }
        }
        else{
            foreach ($tableData as $row) { 
                if ((isset($row[2]) && $row[2] != $iID) && (isset($row[0]) && $row[0] === $lID)) {
                    $exist = true;  
                }
            } 
        }

        if ($exist === false)
        {
            if(is_numeric($iWeight)){
                // CHECK CAPACITY //
                $itemSQL = "SELECT capacity FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($lID)) ."'";  
                $itemOBJ = $mssql->prepare($itemSQL);
                $itemOBJ->execute();
                $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
                if($itemOBJ ->rowCount() > 0){ 
                    foreach($itemRES as $row){
                        $cWeight = $row['capacity'];
                    }
                }  

                // CHECK CURRENT WEIGHT //
                $itemSQL = "SELECT weights FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($lID)) ."'";  
                $itemOBJ = $mssql->prepare($itemSQL);
                $itemOBJ->execute();
                $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
                if($itemOBJ ->rowCount() > 0){ 
                    foreach($itemRES as $row){
                        $weights = $row['weights'];
                    }
                }  

                $totalWeight = $weights + (float)$iWeight;

                if($totalWeight > $cWeight){
                    echo json_encode("exceed");   
                }
                else{
                    foreach ($tableData as $row) { 
                        if ((isset($row[0]) && strpos($row[0], $lID) !== false)) {
                            $eWeight = $eWeight + (float)str_replace(",", "", $row[5]);
                        }
                    } 
                    $totalWeight = $weights + $eWeight + (float)$iWeight;

                    if($totalWeight > $cWeight){
                        echo json_encode("exceed");   
                    }
                    else{
                        echo json_encode("noexist");   
                    }
                } 
            }
            else{
                echo json_encode("weight");   
            }
        }
        else{
            echo json_encode("exist");   
        } 
    }
    else if($task == "new-po"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pTime = filter_var(mysqli_real_escape_string($db,$_POST['pTime'])); 
        $iParticular = filter_var(mysqli_real_escape_string($db,$_POST['iParticular'])); 
        $deduction = filter_var(mysqli_real_escape_string($db,$_POST['deduction'])); 
        $check = filter_var(mysqli_real_escape_string($db,$_POST['checks'])); 
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime(date("Y-m-d")); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(purchaseNo,'PO". $yearMonth ."-','') AS INT)), 0) AS max_num FROM I_Incoming WHERE purchaseNo LIKE '%PO". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
 
            if($ref == "0"){
                $ref = "PO" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'PO' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "PO" . $yearMonth . "-00001";
        } 

        if($check == "false"){
            $deduction = 0.00;
        } 
        else{
            $checkSQL = "SELECT loanBal, loanRef FROM L_Loans where loanerCode = '". escapeSingleQuote(strtoupper('G-'.$payeeID)) ."' and loanBal <> '0.0000' and loanStats = '8'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $bal = $row['loanBal'];
                    $loanRef = $row['loanRef'];
                }
            } 

            $newBal = (float)$bal - (float)$deduction;

            $newSQL = "UPDATE L_Loans SET loanBal = '". $newBal ."' where loanerCode = '". escapeSingleQuote(strtoupper('G-'.$payeeID)) ."' and loanRef = '". $loanRef  ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();    

            $newSQL = "INSERT INTO L_History (loanRef, paymentDate, paymentAmt, isCash, remarks, runningBal, aType) values ('". $loanRef ."','". date("Y-m-d") ."','". $deduction ."','3','LOAN DEDUCTION','". $newBal ."', 'deduction')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
        }

        foreach ($tableData as $row) {    
            $newSQL = "INSERT INTO I_Incoming (purchaseNo, particular, buyerID, buyName, itemNo, itemName, weight, sck, ded, net, priceKG, incDate, incTime, orNo, locNo, locationName, status, loanDed) values ('". escapeSingleQuote(strtoupper($ref)) ."','". escapeSingleQuote(strtoupper($iParticular)) ."', '". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[5]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[4]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[6]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[7]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[8]))) ."','". escapeSingleQuote(strtoupper($pDate)) ."','". escapeSingleQuote(strtoupper($pTime)) ."','". escapeSingleQuote(strtoupper($row[10])) ."','". escapeSingleQuote(strtoupper($row[0])) ."','". escapeSingleQuote(strtoupper($row[1])) ."','0', ". $deduction .")"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
             
            // CHECK INVENTORY //
            $checkSQL = "SELECT weights FROM I_Inventory where itemCode = '". escapeSingleQuote(strtoupper($row[2])) ."' and locationID = '". escapeSingleQuote(strtoupper($row[0])) ."'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $rows){
                    $weights = $rows['weights'];
                }
                
                $tweights = $weights + str_replace(',','',$row[7]); 
                $newSQL = "UPDATE I_Inventory SET lastDUpdate = '". escapeSingleQuote(strtoupper($pDate)) ."', lastTUpdate = '". escapeSingleQuote(strtoupper($pTime)) ."', weights = ". escapeSingleQuote($tweights) ." where locationID = '". escapeSingleQuote(strtoupper($row[0])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row[2])) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   
            }
            else{
                $newSQL = "INSERT INTO I_Inventory (itemCode, itemName, lastDUpdate, lastTUpdate, locationID, weights) values ('". escapeSingleQuote(strtoupper($row[2])) ."' , '". escapeSingleQuote(strtoupper($row[3])) ."', '". escapeSingleQuote(strtoupper($pDate)) ."','". escapeSingleQuote(strtoupper($pTime)) ."', '". escapeSingleQuote(strtoupper($row[0])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[7]))) ."')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();  
            }    

            // DEDUCTION TO LOCATION CAPACITY //
            $checkSQL = "SELECT remaining FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($row[0])) ."' and archiveID = '0'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $rows){
                    $remaining = $rows['remaining'];
                }
            }

            $rem = (float)$remaining - str_replace(',','',$row[7]);

            if($rem <= 0){
                $newSQL = "UPDATE G_Locations SET dateFill = '". $pDate ."', remaining = '0', itemCode = '0' where locationID = '". escapeSingleQuote(strtoupper($row[0])) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();  
            }
            else{
                $newSQL = "UPDATE G_Locations SET dateFill = '". $pDate ."', remaining = '". escapeSingleQuote(strtoupper($rem)) ."', itemCode = '". escapeSingleQuote(strtoupper($row[2])) ."' where locationID = '". escapeSingleQuote(strtoupper($row[0])) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   
            } 
        }

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Puchase Number #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "modify-po"){
        $poNo = filter_var(mysqli_real_escape_string($db,$_POST['poNo'])); 
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pTime = filter_var(mysqli_real_escape_string($db,$_POST['pTime'])); 
        $iParticular = filter_var(mysqli_real_escape_string($db,$_POST['iParticular'])); 

        $newSQL = "UPDATE I_Incoming SET buyerID = '". escapeSingleQuote(strtoupper($payeeID)) ."', buyName = '". escapeSingleQuote(strtoupper($payeeName)) ."', incDate = '". escapeSingleQuote(strtoupper($pDate)) ."', incTime = '". escapeSingleQuote(strtoupper($pTime)) ."', particular = '". escapeSingleQuote(strtoupper($iParticular)) ."' where purchaseNo = '". escapeSingleQuote(strtoupper($poNo)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($purchaseNo)) ."', 'Modify Puchase Number #". escapeSingleQuote(strtoupper($poNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "approve-po"){
        $purchaseNo = filter_var(mysqli_real_escape_string($db,$_POST['purchaseNo'])); 

        $newSQL = "UPDATE I_Incoming SET status = '1' where purchaseNo = '". $purchaseNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($purchaseNo)) ."', 'Approving of Purchase #". escapeSingleQuote(strtoupper($purchaseNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "disapprove-po"){
        $purchaseNo = filter_var(mysqli_real_escape_string($db,$_POST['purchaseNo'])); 

        $newSQL = "UPDATE I_Incoming SET status = '0' where purchaseNo = '". $purchaseNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($purchaseNo)) ."', 'Disapproving of Purchase #". escapeSingleQuote(strtoupper($purchaseNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-po"){
        $purchaseNo = filter_var(mysqli_real_escape_string($db,$_POST['purchaseNo'])); 

        $newSQL = "UPDATE I_Incoming SET status = '3' where purchaseNo = '". $purchaseNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  
         
        $checkSQL = "SELECT itemNo, locNo, SUM(net) net FROM I_Incoming where purchaseNo = '". $purchaseNo ."' GROUP BY itemNo, locNo";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $net = $row['net'];

                // CHECK INVENTORY //
                $checkSQL = "SELECT weights FROM I_Inventory where itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."' and locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $weights = $rows['weights'];
                    }
                    
                    $tweights = $weights - $net; 
                    $newSQL = "UPDATE I_Inventory SET lastDUpdate = '". escapeSingleQuote(strtoupper(date("m-d-Y"))) ."', weights = ". escapeSingleQuote($tweights) ." where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();    

                    // DEDUCTION TO LOCATION CAPACITY //
                    $checkSQL = "SELECT remaining, capacity FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and archiveID = '0'";
                    $checkOBJ = $mssql->prepare($checkSQL);
                    $checkOBJ->execute();
                    $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                    if($checkOBJ ->rowCount() > 0){ 
                        foreach($checkRES as $rows){
                            $remaining = $rows['remaining'];
                        }
                    }

                    $rem = (float)$remaining + $net;
                    
                    if($rem == $rows['capacity']){
                        $newSQL = "DELETE FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();  

                        $newSQL = "UPDATE G_Locations SET itemCode = '0', dateFill = NULL, remaining = '". escapeSingleQuote(strtoupper($rows['capacity'])) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();  
                    }
                    else{
                        $newSQL = "UPDATE G_Locations SET remaining = '". escapeSingleQuote(strtoupper($rem)) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();   
                    } 
                }  
            }
        }  

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($purchaseNo)) ."', 'Cancellation of Purchase #". escapeSingleQuote(strtoupper($purchaseNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "autocomplete-po"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT 'G-'+ CAST(buyingID AS VARCHAR(20)) code, buyName + ' - SUPPLIER' loanerName  FROM G_Buying where isSupplier = '1' and archiveID = '0' and buyName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY loanerName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['loanerName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "check-GL"){
        $cVal = filter_var(mysqli_real_escape_string($db,$_POST['cVal']));  
        $itemSQL = "SELECT coaGL FROM G_Coa where archiveID = '0' and coaName = '". escapeSingleQuote(strtoupper($cVal)) ."'"; 

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        if($itemOBJ ->rowCount() > 0){  
            foreach($itemRES as $row){  
                $coaGL = $row['coaGL'];
            }    
        }
        else{
            $coaGL = '';
        }  
        echo json_encode($coaGL);
    }
    else if($task == "con-purchase"){
        $poNo = filter_var(mysqli_real_escape_string($db,$_POST['poNo'])); 
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName']));  
        $caDate = filter_var(mysqli_real_escape_string($db,$_POST['caDate'])); 
        $particulars = filter_var(mysqli_real_escape_string($db,$_POST['particulars']));   
        $preparedBy = filter_var(mysqli_real_escape_string($db,$_POST['preparedBy'])); 
        $totalcaAmt = filter_var(mysqli_real_escape_string($db,$_POST['totalcaAmt']));    
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime($caDate); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(caRef,'CA". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_CA WHERE caRef LIKE '%CA". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
        }

        $nextNumber = $ref + 1;
        $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
        $caRef = 'CA' . $yearMonth . '-' . $formattedNumber; 

        $newSQL = "INSERT INTO O_CA (caRef, caDate, particulars, caAmt, balAmt, status, preparedBy, releasedBy, payeeID, payeeName, isCharge) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$totalcaAmt))) ."','0','". escapeSingleQuote(strtoupper($preparedBy)) ."','','". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();     

        foreach ($tableData as $row) {  
            $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName,  slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."', '". escapeSingleQuote(strtoupper($row[3])) ."', '". escapeSingleQuote(strtoupper($row[4])) ."' , '". escapeSingleQuote(strtoupper($row[5])) ."', '". escapeSingleQuote(strtoupper($row[6])) ."', '". escapeSingleQuote(strtoupper($row[7])) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$row[8]))) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  
        }

        $checkSQL = "SELECT glCode, actName FROM G_Activity where isAct = '3' and actName = 'ADVANCES'"; 
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $glCode = $row['glCode'];
                $actName = $row['actName'];
            }
        }     

        $itemSQL = "SELECT loanDed FROM I_Incoming where purchaseNo = '". escapeSingleQuote(strtoupper($poNo)) ."' and loanDed <> '0.0000' GROUP BY loanDed";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){ 
                $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."','". escapeSingleQuote(strtoupper('-'.$row['loanDed'])) ."')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();  
            }
        }  

        $newSQL = "UPDATE I_Incoming SET status = '8', caRef = '". escapeSingleQuote(strtoupper($caRef)) ."' where purchaseNo = '". escapeSingleQuote(strtoupper($poNo)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($caRef)) ."', 'Creation of Cash Advance #". escapeSingleQuote(strtoupper($caRef)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "check-sloan"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID']));
        $data = [];
        $itemSQL = "SELECT FORMAT(loanBal,'N2') loanBal, FORMAT(deduction,'N2') deduction FROM L_Loans where loanerCode = '". escapeSingleQuote(strtoupper('G-'. $payeeID)) ."' and loanBal <> '0.0000'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        } 
        echo json_encode($data);
    }
    else if($task == "gen-disbursement"){ 
        $mindate = filter_var(mysqli_real_escape_string($db,$_POST['mindate'])); 
        $maxdate = filter_var(mysqli_real_escape_string($db,$_POST['maxdate']));  

        // Example data
        $response = array(
            array(
                'min' => $mindate,
                'max' => $maxdate 
            )
        );

        echo json_encode($response);              
    }
    else if($task == "gen-summary-exp"){ 
        $slCMB = filter_var(mysqli_real_escape_string($db,$_POST['slCMB']));    

        // Example data
        $response = array(
            array(
                'slCMB' => $slCMB 
            )
        );

        echo json_encode($response);              
    }
    else if($task == "autocomplete-client"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT CAST(clientID AS VARCHAR(20)) code, clientName  FROM G_Client where archiveID = '0' and clientName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY clientName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['clientName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-ocharges"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT glCode, actName FROM G_Activity where actName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY actName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['glCode'], 
                    'value' => $row['actName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-olocation"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT dateFill, locationID, locationName, item.itemID, item.itemName, FORMAT((source.capacity - source.remaining),'N2') totalWeight FROM G_Locations source OUTER APPLY (SELECT itemID, itemName FROM G_Items where itemID = source.itemCode) item where locationName like '%". escapeSingleQuote($searchTerm) ."%' and source.archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['locationID'], 
                    'value' => $row['locationName'],
                    'itemCode' => $row['itemID'],
                    'itemName' => $row['itemName'],
                    'totalWeight' => $row['totalWeight'],
                    'dateFill' => $row['dateFill']
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "search-inventory"){
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID']));  
        $lName = filter_var(mysqli_real_escape_string($db,$_POST['lName']));  
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID']));  
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName']));  
    }
    else if($task == "get-charges"){
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID']));  

        $itemSQL = "SELECT slID, slRef,
        source.locationID, source.locationName, source.itemCode, item.itemName, ISNULL(expense.revenue, glCode) glCode, REPLACE(mainAcct,'PURCHASES - ','') mainAcct,
        FORMAT(SUM(expense.amount),'N2') totalPrice, FORMAT(0.00, 'N2') sck, FORMAT(1.00, 'N2') net, 
		FORMAT(0.00, 'N2') ded, FORMAT(ISNULL(expense.net,1.00),'N2') weight, FORMAT(SUM(expense.amount),'N2') priceKG
        FROM G_Locations source INNER JOIN G_Items item ON source.itemCode = item.itemID
        OUTER APPLY (SELECT CASE WHEN slID LIKE '%I-%' THEN slID ELSE 'C-' + CAST(compSL.companyID as varchar) END slID, CASE WHEN slID LIKE '%I-%' THEN slRef ELSE UPPER(compSL.companyName) + ' - COMPANY' END slRef, revGL.revenue, main.caRef, mainAcct ,amount, glCode, caDate, net FROM O_CA main 
        INNER JOIN O_CADet det ON main.caRef = det.caRef  
        OUTER APPLY (SELECT revenue FROM G_Items where assets = det.glCode) revGL
        OUTER APPLY (SELECT SUM(net) net FROM I_Incoming where caRef = main.caRef) incoming
		OUTER APPLY (SELECT companyID, companyName FROM G_Company where unDel = '1') compSL
		where caDate BETWEEN source.dateFill and CAST(GETDATE() AS DATE) and det.locNo = source.locationID and main.isCharge = '0') expense  
        where source.locationID = '". $lID ."' 
        GROUP BY source.locationID, source.locationName, source.itemCode, item.itemName, source.capacity, source.remaining, slID, slRef, expense.net,
        expense.revenue, mainAcct, glCode 
        ORDER BY CASE WHEN mainAcct like '%PURCHASES -%' THEN 1 ELSE 2 END ASC"; 
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute(); 
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH); 
 
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = [
                    'locationID' => $row['locationID'], 
                    'locationName' => $row['locationName'], 
                    'slID' => $row['slID'], 
                    'slRef' => $row['slRef'], 
                    'itemCode' => $row['itemCode'], 
                    'itemName' => $row['itemName'], 
                    'glCode' => $row['glCode'], 
                    'mainAcct' => $row['mainAcct'], 
                    'sck' => $row['sck'], 
                    'weight' => $row['weight'], 
                    'ded' => $row['ded'], 
                    'net' => $row['net'], 
                    'priceKG' => $row['priceKG'], 
                    'totalPrice' => $row['totalPrice']
                ];
            }
        }    

        echo json_encode($data);
    }
    else if($task == "new-invoice"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pTime = filter_var(mysqli_real_escape_string($db,$_POST['pTime']));  
        $lID = filter_var(mysqli_real_escape_string($db,$_POST['lID'])); 
        $lName = filter_var(mysqli_real_escape_string($db,$_POST['lName'])); 
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName']));  
        $dFill = filter_var(mysqli_real_escape_string($db,$_POST['dFill']));   
        $totalExp = filter_var(mysqli_real_escape_string($db,$_POST['totalExp']));   
        
        $totalExp = str_replace(",","",$totalExp);

        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime(date("Y-m-d")); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(invoiceNo,'IV". $yearMonth ."-','') AS INT)), 0) AS max_num FROM I_Outgoing WHERE invoiceNo LIKE '%IV". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
 
            if($ref == "0"){
                $ref = "IV" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'IV' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "IV" . $yearMonth . "-00001";
        }  

        $invSQL = "INSERT INTO C_Invoice (invoiceNo, clientID, clientName, billingAmt, balanceAmt, statusID, dateCreated) values ('". escapeSingleQuote(strtoupper($ref)) ."', '". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."',  '". escapeSingleQuote(strtoupper($totalExp)) ."', '". escapeSingleQuote(strtoupper($totalExp)) ."', '0', '". escapeSingleQuote(strtoupper($pDate)) ."')";
        $invOBJ = $mssql->prepare($invSQL);
        $invOBJ->execute();  

        foreach ($tableData as $row) {    
            $newSQL = "INSERT INTO I_Outgoing (invoiceNo, clientID, clientName, outDate, outTime, locNo, locationName, itemNo, itemName, sck, ded, net, coaGL, charges, weight, priceKG, totalPrice, status, dFill) values ('". escapeSingleQuote(strtoupper($ref)) ."', '". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."', '". escapeSingleQuote(strtoupper($pDate)) ."','". escapeSingleQuote(strtoupper($pTime)) ."','". escapeSingleQuote(strtoupper($lID)) ."', '". escapeSingleQuote(strtoupper($lName)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$iID))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$iName))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[4]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[6]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[7]))) ."','". escapeSingleQuote(strtoupper($row[0])) ."','". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[5]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[8]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[9]))) ."','0','". escapeSingleQuote(strtoupper($dFill)) ."')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
             
            if($row[5] == "1.00" || $row[5] == "1"){
                $newSQL = "UPDATE source SET source.isCharge = '1' FROM O_CA source INNER JOIN O_CADet det ON source.caRef = det.caRef where det.locNo =  '". escapeSingleQuote(strtoupper($lID)) ."' and source.isCharge = '0' and source.caDate BETWEEN '". $dFill ."' and CAST(GETDATE() AS DATE)"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   
            }else{
                // CHECK INVENTORY //
                $checkSQL = "SELECT weights FROM I_Inventory where itemCode = '". escapeSingleQuote(strtoupper($iID)) ."' and locationID = '". escapeSingleQuote(strtoupper($lID)) ."'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $weights = $rows['weights'];
                    }
                    
                    $tweights = $weights - str_replace(',','',$row[5]); 

                    if($tweights == 0){
                        $newSQL = "DELETE FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($lID)) ."' and itemCode = '". escapeSingleQuote(strtoupper($iID)) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();   
                    }else{
                        $newSQL = "UPDATE I_Inventory SET lastDUpdate = '". escapeSingleQuote(strtoupper($pDate)) ."', lastTUpdate = '". escapeSingleQuote(strtoupper($pTime)) ."', weights = ". escapeSingleQuote($tweights) ." where locationID = '". escapeSingleQuote(strtoupper($lID)) ."' and itemCode = '". escapeSingleQuote(strtoupper($iID)) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();   
                    } 
                }   

                // DEDUCTION TO LOCATION CAPACITY //
                $checkSQL = "SELECT remaining, capacity FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($lID)) ."' and archiveID = '0'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $remaining = $rows['remaining'];
                        $capacity = $rows['capacity'];
                    }
                }

                $rem = (float)$remaining + str_replace(',','',$row[5]);
 
                if($capacity >= $rem){
                    $newSQL = "UPDATE G_Locations SET dateFill = null, remaining = '". escapeSingleQuote(strtoupper($rem)) ."', itemCode = '0' where locationID = '". escapeSingleQuote(strtoupper($lID)) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();    
                }
                else{
                    $newSQL = "UPDATE G_Locations SET dateFill = '". escapeSingleQuote(strtoupper($pDate)) ."', remaining = '". escapeSingleQuote(strtoupper($rem)) ."', itemCode = '". escapeSingleQuote(strtoupper($iID)) ."' where locationID = '". escapeSingleQuote(strtoupper($lID)) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();  
                }
            } 
        }

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Sales Invoice #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved"); 
    }
    else if($task == "autocomplete-plateno"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT truckID, subConName, truckName, plateNumber FROM G_Truck source where plateNumber like '%". escapeSingleQuote($searchTerm) ."%' and source.archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'truckID' => $row['truckID'], 
                    'subConName' => $row['subConName'],
                    'truckName' => $row['truckName'],
                    'value' => $row['plateNumber']
                ];
            }
        }  
        echo json_encode($suggestions); 
    }
    else if($task == "approve-invoice"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 

        $newSQL = "UPDATE I_Outgoing SET status = '1' where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $newSQL = "UPDATE C_Invoice SET statusID = '1' where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($invoiceNo)) ."', 'Approving of Invoice #". escapeSingleQuote(strtoupper($invoiceNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "disapprove-invoice"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 

        $newSQL = "UPDATE I_Outgoing SET status = '0', truckID = NULL, depTime = NULL, depDate = NULL  where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   
        
        $newSQL = "UPDATE C_Invoice SET statusID = '0' where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        $newSQL = "DELETE FROM I_Arrival where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($invoiceNo)) ."', 'Disapproving of Invoice #". escapeSingleQuote(strtoupper($invoiceNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-invoice"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 

        $newSQL = "UPDATE I_Outgoing SET status = '3', truckID = NULL, depTime = NULL, depDate = NULL  where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 
        
        $invSQL = "UPDATE C_Invoice SET statusID = '3' where invoiceNo = '". $invoiceNo ."'"; 
        $invOBJ = $mssql->prepare($invSQL);
        $invOBJ->execute(); 

        $checkSQL = "SELECT itemNo, itemName, dFill sDate, outDate eDate, locNo, SUM(CASE WHEN weight = 1.0000 THEN 0.00 ELSE weight END) weight FROM I_Outgoing where invoiceNo = '". $invoiceNo ."' GROUP BY itemNo, locNo, itemName, dFill, outDate";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $weight = $row['weight']; 
                $sDate = $row['sDate'];
                $eDate = $row['eDate'];

                $newSQL = "UPDATE source SET source.isCharge = '0' FROM O_CA source INNER JOIN O_CADet det ON source.caRef = det.caRef where det.locNo =  '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and source.isCharge = '1' and source.caDate BETWEEN '". $sDate ."' and '". $eDate ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();     

                // CHECK INVENTORY //
                $checkSQL = "SELECT weights FROM I_Inventory where itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."' and locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $weights = $rows['weights'];
                    } 

                    $tweights = $weights + $weight; 
                
                    $newSQL = "UPDATE I_Inventory SET lastDUpdate = '". escapeSingleQuote(strtoupper(date("m-d-Y"))) ."', weights = ". escapeSingleQuote($tweights) ." where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();    
                }  
                else{
                    $weights = 0;

                    $tweights = $weights + $weight; 
                
                    $newSQL = "INSERT INTO I_Inventory (itemCode, itemName, lastDUpdate, lastTUpdate, locationID, weights) values('". escapeSingleQuote(strtoupper($row['itemNo'])) ."', '". escapeSingleQuote(strtoupper($row['itemName'])) ."', '". escapeSingleQuote(strtoupper(date("m-d-Y"))) ."', '". escapeSingleQuote(strtoupper(date("H:i:s"))) ."', '". escapeSingleQuote(strtoupper($row['locNo'])) ."', ". escapeSingleQuote($tweights) .")"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();    
                } 

                // DEDUCTION TO LOCATION CAPACITY //
                $checkSQL = "SELECT remaining, capacity FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and archiveID = '0'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $remaining = $rows['remaining'];
                    }
                }

                $rem = (float)$remaining - $weight;
                    
                if($rem == $rows['capacity']){
                    $newSQL = "DELETE FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();  

                    $newSQL = "UPDATE G_Locations SET itemCode = '0', dateFill = NULL, remaining = '". escapeSingleQuote(strtoupper($rows['capacity'])) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();  
                }
                else{
                    $newSQL = "UPDATE G_Locations SET itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."', dateFill = '". escapeSingleQuote(strtoupper($sDate)) ."', remaining = '". escapeSingleQuote(strtoupper($rem)) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();   
                } 
            }
        }    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($invoiceNo)) ."', 'Cancellation of Invoice #". escapeSingleQuote(strtoupper($invoiceNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("cancel");
    }
    else if($task == "save-trucking"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 
        $subConID = filter_var(mysqli_real_escape_string($db,$_POST['subConID'])); 
        $depTime = filter_var(mysqli_real_escape_string($db,$_POST['depTime'])); 
        $depDate = filter_var(mysqli_real_escape_string($db,$_POST['depDate'])); 

        $newSQL = "UPDATE I_Outgoing SET truckID = '". $subConID ."', depTime = '". $depTime ."', depDate = '". $depDate ."' where invoiceNo = '". $invoiceNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($invoiceNo)) ."', 'Add Trucking for Invoice #". escapeSingleQuote(strtoupper($invoiceNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "new-arrival"){
        $arrinvoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['arrinvoiceNo']));  
        $arrDelivery = filter_var(mysqli_real_escape_string($db,$_POST['arrDelivery']));  
        $arrLoc = filter_var(mysqli_real_escape_string($db,$_POST['arrLoc'])); 
        $arrDate = filter_var(mysqli_real_escape_string($db,$_POST['arrDate']));  
        $arrTime = filter_var(mysqli_real_escape_string($db,$_POST['arrTime'])); 
        $itemNo = filter_var(mysqli_real_escape_string($db,$_POST['itemNo'])); 
        $itemName = filter_var(mysqli_real_escape_string($db,$_POST['itemName'])); 
        $arrSack = filter_var(mysqli_real_escape_string($db,$_POST['arrSack']));  
        $arrWeight = filter_var(mysqli_real_escape_string($db,$_POST['arrWeight'])); 
        $arrDed = filter_var(mysqli_real_escape_string($db,$_POST['arrDed'])); 
        $arrNet = filter_var(mysqli_real_escape_string($db,$_POST['arrNet'])); 
        $arrPrice = filter_var(mysqli_real_escape_string($db,$_POST['arrPrice']));    


        if($arrDelivery == " "){
            $date = new DateTime(date("Y-m-d")); 
            $yearMonth = $date->format('Ym');
    
            $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(deliveryReceipt,'DR". $yearMonth ."-','') AS INT)), 0) AS max_num FROM I_Arrival WHERE deliveryReceipt LIKE '%DR". $yearMonth ."-%'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $ref = $row['max_num'];
                }
     
                if($ref == "0"){
                    $ref = "DR" . $yearMonth . "-00001";
                }
                else{
                    $nextNumber = $ref + 1;
                    $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                    $ref = 'DR' . $yearMonth . '-' . $formattedNumber; 
                } 
            }
            else{
                $ref = "DR" . $yearMonth . "-00001";
            } 
        }
        else{
            $ref = $arrDelivery;
        }

        $newSQL = "MERGE INTO I_Arrival AS target
                    USING (SELECT '" . escapeSingleQuote(strtoupper($ref)) . "' AS deliveryReceipt, 
                                '" . escapeSingleQuote(strtoupper($arrinvoiceNo)) . "' AS invoiceNo,
                                '" . escapeSingleQuote(strtoupper($arrDate)) . "' AS arrDate,
                                '" . escapeSingleQuote(strtoupper($arrTime)) . "' AS arrTime,
                                '" . escapeSingleQuote(strtoupper($itemNo)) . "' AS itemNo,
                                '" . escapeSingleQuote(strtoupper($itemName)) . "' AS itemName,
                                '" . escapeSingleQuote(strtoupper($arrSack)) . "' AS sck,
                                '" . escapeSingleQuote(strtoupper($arrDed)) . "' AS ded,
                                '" . escapeSingleQuote(strtoupper($arrNet)) . "' AS net,
                                '" . escapeSingleQuote(strtoupper($arrWeight)) . "' AS weight,
                                '" . escapeSingleQuote(strtoupper($arrPrice)) . "' AS priceKG,
                                '" . escapeSingleQuote(strtoupper($arrLoc)) . "' AS location) AS source
                    ON target.deliveryReceipt = source.deliveryReceipt AND target.invoiceNo = source.invoiceNo
                    WHEN MATCHED THEN 
                        UPDATE SET 
                            arrDate = source.arrDate, 
                            arrTime = source.arrTime, 
                            itemNo = source.itemNo, 
                            itemName = source.itemName, 
                            sck = source.sck, 
                            ded = source.ded, 
                            net = source.net, 
                            weight = source.weight, 
                            priceKG = source.priceKG, 
                            location = source.location
                    WHEN NOT MATCHED THEN
                        INSERT (deliveryReceipt, invoiceNo, arrDate, arrTime, itemNo, itemName, sck, ded, net, weight, priceKG, location)
                        VALUES (source.deliveryReceipt, source.invoiceNo, source.arrDate, source.arrTime, source.itemNo, source.itemName, source.sck, source.ded, source.net, source.weight, source.priceKG, source.location);";

        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Add Arrival Details Invoice #". escapeSingleQuote(strtoupper($arrinvoiceNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "modify-invoice"){
        $invNo = filter_var(mysqli_real_escape_string($db,$_POST['invNo']));  
        $clientID = filter_var(mysqli_real_escape_string($db,$_POST['clientID']));  
        $clientName = filter_var(mysqli_real_escape_string($db,$_POST['clientName'])); 
        $iDate = filter_var(mysqli_real_escape_string($db,$_POST['iDate']));  
        $iTime = filter_var(mysqli_real_escape_string($db,$_POST['iTime']));  

        $newSQL = "UPDATE I_Outgoing SET clientID = '". escapeSingleQuote(strtoupper($clientID)) ."', clientName = '". escapeSingleQuote(strtoupper($clientName)) ."', outDate = '". escapeSingleQuote(strtoupper($iDate)) ."', outTime = '". escapeSingleQuote(strtoupper($iTime)) ."'  where invoiceNo = '". $invNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($invNo)) ."', 'Modification of Invoice #". escapeSingleQuote(strtoupper($invNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "autocomplete-client"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT CAST(clientID AS VARCHAR(20)) code, clientName FROM G_Client where archiveID = '0' and clientName like '%". escapeSingleQuote(strtoupper($searchTerm)) ."%' ORDER BY clientName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'], 
                    'value' => $row['clientName'] 
                ];
            }
        }  
        echo json_encode($suggestions);
    }
    else if($task == "autocomplete-coa"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT coaGL code, coaName FROM G_Coa where coaName like '%". escapeSingleQuote($searchTerm) ."%' and coaLevel = '5' and archiveID = '0'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'id' => $row['code'],  
                    'value' => $row['coaName']
                ];
            }
        }  
        echo json_encode($suggestions); 
    }
    else if($task == "autocomplete-collection"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT TOP 10 invoiceNo code, clientID, clientName, itemName FROM I_Outgoing source where invoiceNo like '%". escapeSingleQuote($searchTerm) ."%' and status = '1' and (truckID IS NOT NULL and depDate IS NOT NULL and depTime IS NOT NULL) AND EXISTS (SELECT invoiceNo FROM I_Arrival WHERE invoiceNo = source.invoiceNo) GROUP BY invoiceNo, clientName, itemName, clientID UNION ALL SELECT TOP 10 invoiceNo code, clientID, clientName, itemName FROM B_Transaction source where invoiceNo like '%". escapeSingleQuote($searchTerm) ."%' GROUP BY invoiceNo, clientName, itemName, clientID";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'value' => $row['code'],  
                    'clientName' => $row['clientName'],
                    'clientID' => $row['clientID'],
                    'itemName' => $row['itemName']
                ];
            }
        }  
        echo json_encode($suggestions); 
    }
    else if($task == "new-col"){
        $invNo = filter_var(mysqli_real_escape_string($db,$_POST['invNo'])); 
        $orNo = filter_var(mysqli_real_escape_string($db,$_POST['orNo'])); 
        $cID = filter_var(mysqli_real_escape_string($db,$_POST['cID'])); 
        $colDate = filter_var(mysqli_real_escape_string($db,$_POST['colDate'])); 
        $arrGL = filter_var(mysqli_real_escape_string($db,$_POST['arrGL'])); 
        $arrMain = filter_var(mysqli_real_escape_string($db,$_POST['arrMain'])); 
        $totalAmt = filter_var(mysqli_real_escape_string($db,$_POST['totalAmt']));  
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $exist = false;
        $checkSQL = "SELECT * FROM C_Collection WHERE orNo = '". escapeSingleQuote($orNo) ."' and clientID = '". escapeSingleQuote($cID) ."' and statusID <> '3'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            $exist = true;
        } 

        if($exist === true){
            echo json_encode("exist"); 
        }
        else{
            foreach ($tableData as $row) {    
                $newSQL = "INSERT INTO C_Collection (orNo, invoiceNo, coaGL, coaName, coaAmt, statusID, colDate, clientID, entryType) values ('". escapeSingleQuote(strtoupper($orNo)) ."','". escapeSingleQuote(strtoupper($invNo)) ."', '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[2]))) ."','0','". $colDate ."','". $cID ."','E')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();    

                if($row[0] == "11021100"){
                    $checkSQL = "SELECT balanceAmt FROM C_Invoice WHERE invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'";
                    $checkOBJ = $mssql->prepare($checkSQL);
                    $checkOBJ->execute();
                    $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                    if($checkOBJ ->rowCount() > 0){ 
                        foreach($checkRES as $crow){
                            $balanceAmt = $crow['balanceAmt'];
                        }
                    }   

                    $newBal = (float)$balanceAmt + (float)str_replace(",","",$row[2]);

                    $newSQL = "UPDATE C_Invoice SET balanceAmt = '". $newBal ."' where invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();
                
                    $newSQL = "UPDATE C_Invoice SET statusID = '8' where invoiceNo = '". escapeSingleQuote($invNo) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();

                    $newSQL = "UPDATE I_Outgoing SET status = '8' where invoiceNo = '". escapeSingleQuote($invNo) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();
                }        
            }   

            $newSQL = "INSERT INTO C_Collection (orNo, invoiceNo, coaGL, coaName, coaAmt, statusID, colDate, clientID, entryType) values ('". escapeSingleQuote(strtoupper($orNo)) ."','". escapeSingleQuote(strtoupper($invNo)) ."', '". escapeSingleQuote(strtoupper($arrGL)) ."', '". escapeSingleQuote(strtoupper($arrMain)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalAmt))) ."','0','". $colDate ."','". $cID ."','C')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($orNo)) ."', 'Creation of OR Number #". escapeSingleQuote(strtoupper($orNo)) ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 
    
            echo json_encode("saved");
        }
    }
    else if($task == "autocomplete-cashinbank"){
        $searchTerm = $_GET['term'];

        $itemSQL = "SELECT coaName, coaGL code FROM G_Coa where coaName like '%". escapeSingleQuote($searchTerm) ."%' and coaParentID = '11012000' and archiveID = '0' ORDER BY coaName ASC";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $suggestions[] = [
                    'value' => $row['coaName'],  
                    'id' => $row['code'] 
                ];
            }
        }  
        echo json_encode($suggestions); 
    }
    else if($task == "app-col"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 
        $orNo = filter_var(mysqli_real_escape_string($db,$_POST['orNo'])); 

        $newSQL = "UPDATE C_Collection SET statusID = '1' where invoiceNo = '". $invoiceNo ."' and orNo = '". $orNo ."' and statusID = '0'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($orNo)) ."', 'Approving of OR #". escapeSingleQuote(strtoupper($orNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 
        
        echo json_encode("saved");  
    }
    else if($task == "can-col"){
        $invoiceNo = filter_var(mysqli_real_escape_string($db,$_POST['invoiceNo'])); 
        $orNo = filter_var(mysqli_real_escape_string($db,$_POST['orNo'])); 
 
        $checkSQL = "SELECT balanceAmt, billingAmt FROM C_Invoice WHERE invoiceNo = '". escapeSingleQuote($invoiceNo) ."' and statusID <> '3'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $crow){
                $balanceAmt = $crow['balanceAmt'];
                $billingAmt = $crow['billingAmt'];
            }
        } 
        
        $checkSQL = "SELECT coaAmt FROM C_Collection WHERE invoiceNo = '". escapeSingleQuote($invoiceNo) ."' and orNo = '". escapeSingleQuote($orNo) ."' and coaGL = '11021100' and statusID <> '3'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $crow){
                $coaAmt = $crow['coaAmt'];
            }
        } 

        $newBal = (float)$balanceAmt - (float)$coaAmt;

        $newSQL = "UPDATE C_Invoice SET balanceAmt = '". $newBal ."' where invoiceNo = '". escapeSingleQuote($invoiceNo) ."' and statusID <> '3'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();
    
        if($billingAmt == $newBal){
            $newSQL = "UPDATE C_Invoice SET statusID = '1' where invoiceNo = '". escapeSingleQuote($invoiceNo) ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();
    
            $newSQL = "UPDATE I_Outgoing SET status = '1' where invoiceNo = '". escapeSingleQuote($invoiceNo) ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();
        } 

        $newSQL = "UPDATE C_Collection SET statusID = '3' where invoiceNo = '". $invoiceNo ."' and orNo = '". $orNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($orNo)) ."', 'Cancellation of OR #". escapeSingleQuote(strtoupper($orNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 
        
        echo json_encode("saved");  
    }
    else if($task == "modify-col"){
        $invNo = filter_var(mysqli_real_escape_string($db,$_POST['invNo'])); 
        $orNo = filter_var(mysqli_real_escape_string($db,$_POST['orNo'])); 
        $oldorNo = filter_var(mysqli_real_escape_string($db,$_POST['oldorNo'])); 
        $cID = filter_var(mysqli_real_escape_string($db,$_POST['cID'])); 
        $colDate = filter_var(mysqli_real_escape_string($db,$_POST['colDate'])); 
        $arrGL = filter_var(mysqli_real_escape_string($db,$_POST['arrGL'])); 
        $arrMain = filter_var(mysqli_real_escape_string($db,$_POST['arrMain'])); 
        $totalAmt = filter_var(mysqli_real_escape_string($db,$_POST['totalAmt']));  
        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $exist = false;

        if($oldorNo != $orNo){
            $checkSQL = "SELECT orNo FROM C_Collection WHERE orNo = '". escapeSingleQuote($orNo) ."' and clientID = '". escapeSingleQuote($cID) ."' and statusID <> '3'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                $exist = true;
            } 
        } 

        if($exist === true){
            echo json_encode("exist"); 
        }
        else{
            $checkSQL = "SELECT coaAmt FROM C_Collection WHERE coaGL = '11021100' and orNo = '". escapeSingleQuote($orNo) ."' and invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){
                foreach($checkRES as $crow){
                    $origAmt = $crow['coaAmt'];
                }  
            } 

            $checkSQL = "SELECT balanceAmt FROM C_Invoice WHERE invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'";
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $crow){
                    $balanceAmt = $crow['balanceAmt'];
                }
            }   

            $resetBal = $balanceAmt - $origAmt; 

            $newSQL = "UPDATE C_Invoice SET balanceAmt = '". $resetBal ."' where invoiceNo = '". $invNo ."' and statusID <> '3'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  

            $newSQL = "DELETE FROM C_Collection where orNo = '". escapeSingleQuote(strtoupper($orNo)) ."' and invoiceNo = '". escapeSingleQuote(strtoupper($invNo)) ."' and statusID <> '3'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  

            foreach ($tableData as $row) {   
                $newSQL = "INSERT INTO C_Collection (orNo, invoiceNo, coaGL, coaName, coaAmt, statusID, colDate, clientID, entryType) values ('". escapeSingleQuote(strtoupper($orNo)) ."','". escapeSingleQuote(strtoupper($invNo)) ."', '". escapeSingleQuote(strtoupper($row[0])) ."', '". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[2]))) ."','0','". $colDate ."','". $cID ."','E')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();    

                if($row[0] == "11021100"){
                    $checkSQL = "SELECT balanceAmt FROM C_Invoice WHERE invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'";
                    $checkOBJ = $mssql->prepare($checkSQL);
                    $checkOBJ->execute();
                    $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                    if($checkOBJ ->rowCount() > 0){ 
                        foreach($checkRES as $crow){
                            $balanceAmt = $crow['balanceAmt'];
                        }
                    }   

                    $newBal = (float)$balanceAmt + (float)str_replace(",","",$row[2]);

                    $newSQL = "UPDATE C_Invoice SET balanceAmt = '". $newBal ."' where invoiceNo = '". escapeSingleQuote($invNo) ."' and statusID <> '3'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();
                
                    $newSQL = "UPDATE C_Invoice SET statusID = '8' where invoiceNo = '". escapeSingleQuote($invNo) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();

                    $newSQL = "UPDATE I_Outgoing SET status = '8' where invoiceNo = '". escapeSingleQuote($invNo) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();
                }
            }   

            $newSQL = "INSERT INTO C_Collection (orNo, invoiceNo, coaGL, coaName, coaAmt, statusID, colDate, clientID, entryType) values ('". escapeSingleQuote(strtoupper($orNo)) ."','". escapeSingleQuote(strtoupper($invNo)) ."', '". escapeSingleQuote(strtoupper($arrGL)) ."', '". escapeSingleQuote(strtoupper($arrMain)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$totalAmt))) ."','0','". $colDate ."','". $cID ."','C')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();  

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($orNo)) ."', 'Modify of OR Number #". escapeSingleQuote(strtoupper($orNo)) ."', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute(); 
    
            echo json_encode("saved");
        }
    }
    else if($task == "new-contract"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate'])); 
        $pTime = filter_var(mysqli_real_escape_string($db,$_POST['pTime'])); 
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName'])); 
        $iWeight = filter_var(mysqli_real_escape_string($db,$_POST['iWeight'])); 
        $tPrice = filter_var(mysqli_real_escape_string($db,$_POST['tPrice']));  

        $date = new DateTime(date("Y-m-d")); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(refNo,'C". $yearMonth ."-','') AS INT)), 0) AS max_num FROM B_Contract WHERE refNo LIKE '%C". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
 
            if($ref == "0"){
                $ref = "C" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'C' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "C" . $yearMonth . "-00001";
        }  
  
        $newSQL = "INSERT INTO B_Contract (refNo, cDate, cTime, buyerID, buyName, itemNo, itemName, weight, loanAmt, loanBal, status, preparedBy) values ('". escapeSingleQuote(strtoupper($ref)) ."','". escapeSingleQuote(strtoupper($pDate)) ."', '". escapeSingleQuote(strtoupper($pTime)) ."', 'B-". escapeSingleQuote(strtoupper($payeeID)) ."','". escapeSingleQuote(strtoupper($payeeName)) ."', '". escapeSingleQuote(strtoupper($iID)) ."','". escapeSingleQuote(strtoupper($iName)) ."','". escapeSingleQuote(strtoupper($iWeight)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."','0', '". escapeSingleQuote(strtoupper($fullname)) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 
        
        
        $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($ref)) ."','". escapeSingleQuote(strtoupper($pDate)) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."', '0','". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."', 'CONTRACT CREATION')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 


        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Contract Number #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "modify-contract"){
        $refNo = filter_var(mysqli_real_escape_string($db,$_POST['refNo']));
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID'])); 
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName'])); 
        $iWeight = filter_var(mysqli_real_escape_string($db,$_POST['iWeight'])); 
        $tPrice = filter_var(mysqli_real_escape_string($db,$_POST['tPrice']));  
 
        $newSQL = "UPDATE B_Contract SET buyerID = 'B-". escapeSingleQuote(strtoupper($payeeID)) ."',buyName = '". escapeSingleQuote(strtoupper($payeeName)) ."', itemNo = '". escapeSingleQuote(strtoupper($iID)) ."', itemName = '". escapeSingleQuote(strtoupper($iName)) ."', weight = '". escapeSingleQuote(strtoupper($iWeight)) ."', loanAmt = '". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."', loanBal = '". escapeSingleQuote(strtoupper(str_replace(",","",$tPrice))) ."' where refNo = '". $refNo ."'";  
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($refNo)) ."', 'Revision of Contract Number #". escapeSingleQuote(strtoupper($refNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "approve-contract"){
        $cNo = filter_var(mysqli_real_escape_string($db,$_POST['cNo'])); 

        $newSQL = "UPDATE B_Contract SET status = '1' where refNo = '". $cNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($cNo)) ."', 'Approving of Contract #". escapeSingleQuote(strtoupper($cNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-contract"){
        $cNo = filter_var(mysqli_real_escape_string($db,$_POST['cNo'])); 

        $newSQL = "UPDATE B_Contract SET status = '3' where refNo = '". $cNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($cNo)) ."', 'Cancellation of Contract #". escapeSingleQuote(strtoupper($cNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("cancelled");
    }
    else if($task == "disapprove-contract"){
        $cNo = filter_var(mysqli_real_escape_string($db,$_POST['cNo'])); 

        $newSQL = "UPDATE B_Contract SET status = '0' where refNo = '". $cNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($cNo)) ."', 'Disapproving of Contract #". escapeSingleQuote(strtoupper($cNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "cancel-po"){
        $purchaseNo = filter_var(mysqli_real_escape_string($db,$_POST['purchaseNo'])); 

        $newSQL = "UPDATE I_Incoming SET status = '3' where purchaseNo = '". $purchaseNo ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  
         
        $checkSQL = "SELECT itemNo, locNo, SUM(net) net FROM I_Incoming where purchaseNo = '". $purchaseNo ."' GROUP BY itemNo, locNo";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $net = $row['net'];

                // CHECK INVENTORY //
                $checkSQL = "SELECT weights FROM I_Inventory where itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."' and locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'";
                $checkOBJ = $mssql->prepare($checkSQL);
                $checkOBJ->execute();
                $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                if($checkOBJ ->rowCount() > 0){ 
                    foreach($checkRES as $rows){
                        $weights = $rows['weights'];
                    }
                    
                    $tweights = $weights - $net; 
                    $newSQL = "UPDATE I_Inventory SET lastDUpdate = '". escapeSingleQuote(strtoupper(date("m-d-Y"))) ."', weights = ". escapeSingleQuote($tweights) ." where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                    $newOBJ = $mssql->prepare($newSQL);
                    $newOBJ->execute();    

                    // DEDUCTION TO LOCATION CAPACITY //
                    $checkSQL = "SELECT remaining, capacity FROM G_Locations where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and archiveID = '0'";
                    $checkOBJ = $mssql->prepare($checkSQL);
                    $checkOBJ->execute();
                    $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
                    if($checkOBJ ->rowCount() > 0){ 
                        foreach($checkRES as $rows){
                            $remaining = $rows['remaining'];
                        }
                    }

                    $rem = (float)$remaining + $net;
                    
                    if($rem == $rows['capacity']){
                        $newSQL = "DELETE FROM I_Inventory where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."' and itemCode = '". escapeSingleQuote(strtoupper($row['itemNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();  

                        $newSQL = "UPDATE G_Locations SET itemCode = '0', dateFill = NULL, remaining = '". escapeSingleQuote(strtoupper($rows['capacity'])) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();  
                    }
                    else{
                        $newSQL = "UPDATE G_Locations SET remaining = '". escapeSingleQuote(strtoupper($rem)) ."' where locationID = '". escapeSingleQuote(strtoupper($row['locNo'])) ."'"; 
                        $newOBJ = $mssql->prepare($newSQL);
                        $newOBJ->execute();   
                    } 
                }  
            }
        }  

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($purchaseNo)) ."', 'Cancellation of Purchase #". escapeSingleQuote(strtoupper($purchaseNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved");
    }
    else if($task == "rel-contract"){
        $loanerRef = filter_var(mysqli_real_escape_string($db,$_POST['loanerRef'])); 
        $releaseDate = filter_var(mysqli_real_escape_string($db,$_POST['releaseDate']));  
        $lAmt = filter_var(mysqli_real_escape_string($db,$_POST['lAmt']));   

        $caDate = date("Y-m-d"); 
        $particulars = "CONTRACT # ". $loanerRef;   
        $preparedBy = $fullname;  
        $date = new DateTime($caDate); 
        $yearMonth = $date->format('Ym');
        
        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(caRef,'CA". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_CA WHERE caRef LIKE '%CA". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);     
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
        }  
        $nextNumber = $ref + 1;
        $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
        $caRef = 'CA' . $yearMonth . '-' . $formattedNumber;  

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(liqRef,'LIQ". $yearMonth ."-','') AS INT)), 0) AS max_num FROM O_LIQ WHERE liqRef LIKE '%LIQ". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            } 
            if($ref == "0"){
                $ref = "LIQ" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'LIQ' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "LIQ" . $yearMonth . "-00001";
        }    
        
        // CA PREPARATION
        $checkSQL = "SELECT 'E-' + CAST(empID as varchar) payeeID, fullName + ' - EMPLOYEE' payeeName FROM G_Employee where isPayroll = '1'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $payeeID = $row['payeeID'];
                $payeeName = $row['payeeName'];
            }
        }     

        $checkSQL = "SELECT buyerID, buyName FROM B_Contract where refNo = '". escapeSingleQuote(strtoupper($loanerRef)) ."'"; 
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $loanerCode = $row['buyerID'];
                $loanerName = $row['buyName'];
            }
        }    

        $checkSQL = "SELECT glCode, actName FROM G_Activity where isAct = '3' and actName = 'ADVANCES'"; 
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $glCode = $row['glCode'];
                $actName = $row['actName'];
            }
        }    

        $newSQL = "INSERT INTO O_CA (caRef, caDate, particulars, caAmt, balAmt, status, preparedBy, releasedBy, payeeID, payeeName, isCharge) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($caDate)) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."', '0','8','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($preparedBy)) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."','". escapeSingleQuote(strtoupper($loanerName)) ."','0')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $newSQL = "INSERT INTO O_CADet (caRef, glCode, mainAcct, locNo, lName, itemNo, iName, slID, slRef, amount) values ('". escapeSingleQuote(strtoupper($caRef)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','0','','0','','". escapeSingleQuote(strtoupper($loanerCode)) ."', '". escapeSingleQuote(strtoupper($loanerName)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();  

        $newSQL = "INSERT INTO O_LIQ (liqRef, liqDate, particulars, liqAmt, preparedBy, payeeID, payeeName, status, caRef) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper(date("Y-m-d"))) ."', '". escapeSingleQuote(strtoupper($particulars)) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$preparedBy))) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."','". escapeSingleQuote(strtoupper($loanerName)) ."','0','". escapeSingleQuote(strtoupper($caRef)) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $newSQL = "INSERT INTO O_LiqDet (liqRef, glCode, mainAcct, slID, slRef, orNo, amount) values ('". escapeSingleQuote(strtoupper($ref)) ."' , '". escapeSingleQuote(strtoupper($glCode)) ."', '". escapeSingleQuote(strtoupper($actName)) ."','". escapeSingleQuote(strtoupper($loanerCode)) ."', '". escapeSingleQuote(strtoupper($loanerName)) ."','ADVANCES','". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();    

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanerRef)) ."', 'Contract # ". escapeSingleQuote(strtoupper($loanerRef)) ." Released', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        $newSQL = "UPDATE B_Contract SET status = '8', releaseDate = '". escapeSingleQuote(strtoupper($releaseDate)) ."', caRef = '". escapeSingleQuote(strtoupper($caRef)) ."' where refNo = '". escapeSingleQuote(strtoupper($loanerRef)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();     

        $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($loanerRef)) ."' , '". escapeSingleQuote(strtoupper($releaseDate)) ."', '". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."','0', '". escapeSingleQuote(strtoupper(str_replace(",","",$lAmt))) ."','CONTRACT RELEASED')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        echo json_encode("release");   
    }
    else if($task == "get-contractbal"){
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));

        $itemSQL = "SELECT FORMAT(loanBal, 'N2') loanBal FROM B_Contract where refNo = '". escapeSingleQuote(strtoupper($loanRef)) ."' and status = '8'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        }  
        echo json_encode($data);
    }
    else if($task == "get-contractloan"){
        $loanerID = filter_var(mysqli_real_escape_string($db,$_POST['loanerID']));

        $itemSQL = "SELECT refNo loanRef FROM B_Contract where buyerID = 'B-". escapeSingleQuote(strtoupper($loanerID)) ."' and loanBal <> '0.0000' and status = '8'";  
        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
        if($itemOBJ ->rowCount() > 0){ 
            foreach($itemRES as $row){
                $data[] = $row;
            }
        }  
        else{
            $data[] = null;
        }
        echo json_encode($data);
    }
    else if($task == "new-cadj"){
        $loanRef = filter_var(mysqli_real_escape_string($db,$_POST['loanRef']));
        $loanBal = filter_var(mysqli_real_escape_string($db,$_POST['loanBal']));
        $adjType = filter_var(mysqli_real_escape_string($db,$_POST['adjType']));
        $mopType = filter_var(mysqli_real_escape_string($db,$_POST['mopType']));
        $loanerDate = filter_var(mysqli_real_escape_string($db,$_POST['loanerDate']));
        $loanerAmt = filter_var(mysqli_real_escape_string($db,$_POST['loanerAmt']));
   
        if($mopType == "cash") $isCash = "1";
        else if($mopType == "salary") $isCash = "2";
        else if($mopType == "item") $isCash = "3";
        else if($mopType == "others") $isCash = "0";

        if($adjType == "deduct") {
            $bal = $loanBal - $loanerAmt;  
            if($bal < 0){
                echo json_encode("less");  
            }else{
                $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($loanRef)) ."' , '". escapeSingleQuote(strtoupper($loanerDate)) ."', '". escapeSingleQuote(strtoupper($loanerAmt)) ."','". $isCash ."', '". escapeSingleQuote(strtoupper($bal)) ."','ADJUSTMENT - DEDUCT TO CONTRACT')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $newSQL = "UPDATE B_Contract SET loanBal = '". $bal ."' where  refNo = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Adjustment for Contract #". escapeSingleQuote(strtoupper($loanRef)) ."', '". $ipAddress ."')"; 
                $logsOBJ = $mssql->prepare($logSQL);
                $logsOBJ->execute(); 

                echo json_encode("saved");  
            }    
        }
        else if($adjType == "add"){
            $checkSQL = "SELECT loanAmt FROM L_Loans where loanRef = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
            $checkOBJ = $mssql->prepare($checkSQL);
            $checkOBJ->execute();
            $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
            if($checkOBJ ->rowCount() > 0){ 
                foreach($checkRES as $row){
                    $loanTotal = $row['loanAmt'];
                }
            } 

            $bal = $loanBal + $loanerAmt;  

            if($bal > $loanTotal){
                echo json_encode("greater");  
            }else{
                $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($loanRef)) ."' , '". escapeSingleQuote(strtoupper($loanerDate)) ."', '". escapeSingleQuote(strtoupper($loanerAmt)) ."','0', '". escapeSingleQuote(strtoupper($bal)) ."','ADJUSTMENT - ADD TO CONTRACT')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $newSQL = "UPDATE B_Contract SET loanBal = '". $bal ."' where  refNo = '". escapeSingleQuote(strtoupper($loanRef)) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();

                $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($loanRef)) ."', 'Adjustment for Contract #". escapeSingleQuote(strtoupper($loanRef)) ."', '". $ipAddress ."')"; 
                $logsOBJ = $mssql->prepare($logSQL);
                $logsOBJ->execute();   

                echo json_encode("saved");  
            }
        }     
    } 
    else if($task == "new-ctransaction"){
        $payeeID = filter_var(mysqli_real_escape_string($db,$_POST['payeeID'])); 
        $payeeName = filter_var(mysqli_real_escape_string($db,$_POST['payeeName'])); 
        $buyerID = filter_var(mysqli_real_escape_string($db,$_POST['buyerID'])); 
        $buyerName = filter_var(mysqli_real_escape_string($db,$_POST['buyerName']));
        $pDate = filter_var(mysqli_real_escape_string($db,$_POST['pDate']));  
        $cNo = filter_var(mysqli_real_escape_string($db,$_POST['cNo']));
        $loanBal = filter_var(mysqli_real_escape_string($db,$_POST['loanBal']));   

        $iID = filter_var(mysqli_real_escape_string($db,$_POST['iID']));
        $iName = filter_var(mysqli_real_escape_string($db,$_POST['iName']));  

        $tableDataJson = $_POST['tableData'];   
        $tableData = json_decode($tableDataJson, true);

        $date = new DateTime(date("Y-m-d")); 
        $yearMonth = $date->format('Ym');

        $checkSQL = "SELECT ISNULL(MAX(CAST(REPLACE(invoiceNo,'TC". $yearMonth ."-','') AS INT)), 0) AS max_num FROM B_Transaction WHERE invoiceNo LIKE '%TC". $yearMonth ."-%'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $ref = $row['max_num'];
            }
 
            if($ref == "0"){
                $ref = "TC" . $yearMonth . "-00001";
            }
            else{
                $nextNumber = $ref + 1;
                $formattedNumber = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
                $ref = 'TC' . $yearMonth . '-' . $formattedNumber; 
            } 
        }
        else{
            $ref = "TC" . $yearMonth . "-00001";
        }    

        foreach ($tableData as $row) {    
            $newSQL = "INSERT INTO B_Transaction (contractNo, invoiceNo, clientID, clientName, buyerID, buyerName,  transactionDate, itemNo, itemName, coaGL, charges, weight, priceKG, totalPrice, status) values ('". escapeSingleQuote(strtoupper($cNo)) ."', '". escapeSingleQuote(strtoupper($ref)) ."', '". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."', '". escapeSingleQuote(strtoupper($buyerID)) ."', '". escapeSingleQuote(strtoupper($buyerName)) ."' , '". escapeSingleQuote(strtoupper($pDate)) ."','". escapeSingleQuote(strtoupper(strtoupper($iID))) ."','". escapeSingleQuote(strtoupper(strtoupper($iName))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[0]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[1]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[4]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[5]))) ."','". escapeSingleQuote(strtoupper(str_replace(",","",$row[6]))) ."','0')"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   

            if(strtoupper(str_replace(",","",$row[1])) == "ADVANCES"){
                $newBal =  (float)strtoupper(str_replace(",","",$loanBal)) + (float)strtoupper(str_replace(",","",$row[5]));
                $pAmt = (float)strtoupper(str_replace(",","",$row[5])) * -1;

                $newSQL = "UPDATE B_Contract SET loanBal = '". escapeSingleQuote($newBal) ."' where refNo = '". escapeSingleQuote(strtoupper($cNo)) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   

                $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($cNo)) ."' , '". escapeSingleQuote(strtoupper($pDate)) ."', '". escapeSingleQuote(strtoupper($pAmt)) ."','3', '". escapeSingleQuote(strtoupper($newBal)) ."','TRANSACTION - DEDUCT TO CONTRACT')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();
            }

            $tAmt = $tAmt + $pAmt;
        } 

        $invSQL = "INSERT INTO C_Invoice (invoiceNo, clientID, clientName, billingAmt, balanceAmt, statusID, dateCreated) values ('". escapeSingleQuote(strtoupper($ref)) ."', '". escapeSingleQuote(strtoupper($payeeID)) ."', '". escapeSingleQuote(strtoupper($payeeName)) ."',  '". escapeSingleQuote(strtoupper($tAmt)) ."', '". escapeSingleQuote(strtoupper($tAmt)) ."', '0', '". escapeSingleQuote(strtoupper($pDate)) ."')";
        $invOBJ = $mssql->prepare($invSQL);
        $invOBJ->execute();  

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Creation of Transaction Contract #". escapeSingleQuote(strtoupper($ref)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved"); 
    }
    else if($task == "cancel-transaction"){
        $cNo = filter_var(mysqli_real_escape_string($db,$_POST['cNo'])); 
        
        $checkSQL = "SELECT totalPrice, contractNo FROM B_Transaction where invoiceNo = '". escapeSingleQuote(strtoupper($cNo)) ."' and charges = 'ADVANCES'";
        $checkOBJ = $mssql->prepare($checkSQL);
        $checkOBJ->execute();
        $checkRES = $checkOBJ->fetchAll(PDO::FETCH_BOTH);
        if($checkOBJ ->rowCount() > 0){ 
            foreach($checkRES as $row){
                $contract = $row['contractNo']; 
                $tPrice = ((float)$row['totalPrice'] * -1);
            } 

            $balSQL = "SELECT loanBal FROM B_Contract where refNo = '". escapeSingleQuote(strtoupper($contract)) ."'";
            $balOBJ = $mssql->prepare($balSQL);
            $balOBJ->execute();
            $balRES = $balOBJ->fetchAll(PDO::FETCH_BOTH);
            if($balOBJ ->rowCount() > 0){ 
                foreach($balRES as $bal){
                    $loanBal = $bal['loanBal'];  
                } 
            }  

            $cancelledAmt = (float)$loanBal + (float)$tPrice; 

            $newSQL = "UPDATE B_Contract SET loanBal = '".  escapeSingleQuote(strtoupper($cancelledAmt))  ."' where refNo = '". escapeSingleQuote(strtoupper($contract)) ."'"; 
            $newOBJ = $mssql->prepare($newSQL);
            $newOBJ->execute();   
        }   

        $newSQL = "UPDATE B_Transaction SET status = '3' where invoiceNo = '". escapeSingleQuote(strtoupper($cNo)) ."'"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute();   

        $newSQL = "INSERT INTO B_History (refNo, pDate, pAmt, isCash, runningBal, aType) values ('". escapeSingleQuote(strtoupper($contract)) ."' , '". escapeSingleQuote(strtoupper($otherFormat)) ."', '". escapeSingleQuote(strtoupper($tPrice)) ."','0', '". escapeSingleQuote(strtoupper($cancelledAmt)) ."','TRANSACTION - CANCELLED')"; 
        $newOBJ = $mssql->prepare($newSQL);
        $newOBJ->execute(); 

        $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '". escapeSingleQuote(strtoupper($ref)) ."', 'Cancellation of Transaction Contract #". escapeSingleQuote(strtoupper($cNo)) ."', '". $ipAddress ."')"; 
        $logsOBJ = $mssql->prepare($logSQL);
        $logsOBJ->execute(); 

        echo json_encode("saved"); 
    }

    // NOT USED //
    else if($task == "reset-activity"){ 
        $empID = $_GET['empID'];    
        $min_date = $_GET['min'];    

        $itemSQL = "SELECT empID, UPPER(fullname) fullname, act.isPresent, act.timeIn, act.timeOut, act.actID, act.actName, act.repitition, act.rate, act.fixRate, act.salary, act.locationName FROM G_Employee source OUTER APPLY (SELECT attDate, isPresent, CASE WHEN timeIn IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeIn, 24) END timeIn, CASE WHEN timeOut IS NULL THEN NULL ELSE CONVERT(VARCHAR, timeOut, 24) END timeOut, actID, actName, FORMAT(repitition, '#,##0') repitition, FORMAT(rate, '#,##0.00') rate, FORMAT(fixRate, '#,##0.00') fixRate, FORMAT(((repitition * rate) + fixRate), '#,##0.00') salary, locs.locationName FROM T_Activities acts INNER JOIN G_Locations locs ON acts.locID = locs.locationID where empID = source.empID and attDate = '". $min_date ."') act where source.archiveID = '0'"; 

        $itemOBJ = $mssql->prepare($itemSQL);
        $itemOBJ->execute();
        $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);

        header('Content-Type: application/json');
        echo json_encode($itemRES);  
    }
?>

