<?php 
    require_once '../vendors/phpword/autoload.php';

    // Creating the new document...
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    
    include_once('../modules/connect.php');

    $cNo  = $_GET['cNo']; 

    function floatvalue($val){
        $val = str_replace(",",".",$val);
        $val = preg_replace('/\.(?=.*\.)/', '', $val);
        return floatval($val);
    }  

    $caSQL = "SELECT refNo, FORMAT(cDate,'MM-dd-yyyy') cDate, cTime, buyerID, buyName, itemNo, itemName, FORMAT(weight,'N2') weight, FORMAT(loanAmt,'N2') loanAmt, caRef, preparedBy  FROM B_Contract where refNo = '". $cNo ."'";  
    $caOBJ = $mssql->prepare($caSQL);
    $caOBJ->execute();

    $caRES = $caOBJ->fetchAll(PDO::FETCH_BOTH);

    if($caOBJ ->rowCount() > 0){  
        foreach($caRES as $row){  
            $caRef = $row['caRef'];
            $refNo = $row['refNo'];
            $buyerID = $row['buyerID']; 
            $buyName = str_replace('&', 'and', $row['buyName']); 
            $cDate = $row['cDate'];
            $cTime = $row['cTime'];
            $itemNo = $row['itemNo'];
            $itemName = $row['itemName'];
            $weight = $row['weight'];
            $loanAmt = $row['loanAmt']; 
            $preparedBy = $row['preparedBy']; 
        }   
    }  

    $section = $phpWord->addSection([
        'pageSizeH' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(5.5),
        'pageSizeW' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(8.5),
        'marginLeft' => 600,
        'marginRight' => 600
    ]);

    $topBorderCell =
    [
        'borderTopColor' =>'000000',
        'borderTopSize' => 20
    ]; 

    $bottomBorderCell =
    [ 
        'borderBottomColor' =>'000000',
        'borderBottomSize' => 20 
    ];   

    $header = $section->createHeader(); 

    // -- HEADER MLE -- //
    $header->addText(
        'MLE TRADING',
        array('name' => 'Arial', 'size' => 12,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0))
    );       
    $header->addText(
        'BUYING STATION CONTRACT',
        array('name' => 'Arial', 'size' => 9,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0)
    ); 
    $header->addTextBreak(); 
     
    $table = $header->addTable();  
  
    // -- PARTNER DETAILS -- //
    $table->addRow();
    $table->addCell(3000)->addText('Contract:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($refNo), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('Date:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText($cDate, array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $table->addRow();
    $table->addCell(3000)->addText('Cash Advance:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($caRef), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
  
    $table->addRow();
    $table->addCell(3000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false, 'italic'=> true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $section->addTextBreak(); 

    $table = $section->addTable();   
    $table->addRow();
    $table->addCell(2000)->addText('Item:',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($itemName),array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table->addRow();
    $table->addCell(2000)->addText('Weight:',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($weight),array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
  
    $table->addRow();
    $table->addCell(2000)->addText('Amount:',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($loanAmt),array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000)->addText('',array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
 
    $section->addTextBreak(1);

    $footer = $section->createFooter(); 
  
    $table1 = $footer->addTable();

    $table1->addRow(); 
    $table1->addCell(6000)->addText('Prepared By:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('Buying Station:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('Approver:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText(strtoupper($preparedBy), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText(strtoupper($buyName), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('MLE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
 
    $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007'); 
    header("Content-Disposition: attachment; filename=".strtoupper(str_replace(',', '', $refNo)).".docx");
    $objWriter->save("php://output");
?>