<?php 
    require_once '../vendors/phpword/autoload.php';

    // Creating the new document...
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    
    include_once('../modules/connect.php');

    $liqRef  = $_GET['r']; 

    function floatvalue($val){
        $val = str_replace(",",".",$val);
        $val = preg_replace('/\.(?=.*\.)/', '', $val);
        return floatval($val);
    } 

    $caSQL = "SELECT source.liqRef, source.payeeName, source.preparedBy, source.payeeID, source.liqDate, source.particulars, det.glCode, det.mainAcct, det.slID, det.slRef,  det.amount, det.orNo, source.caRef  FROM O_Liq source INNER JOIN O_LiqDet det ON source.liqRef = det.liqRef where source.liqRef = '". $liqRef ."' ORDER BY CASE WHEN det.mainAcct = 'ADVANCES' THEN 2 ELSE 1 END, det.slID ASC"; 
    $caOBJ = $mssql->prepare($caSQL);
    $caOBJ->execute();

    $caRES = $caOBJ->fetchAll(PDO::FETCH_BOTH);

    if($caOBJ ->rowCount() > 0){  
        foreach($caRES as $row){  
            $caRef = $row['liqRef'];
            $payeeID = $row['payeeID'];
            $payeeName = str_replace('&', 'and', $row['payeeName']); 
            $liqDate = $row['liqDate'];
            $particulars = $row['particulars'];
            $preparedBy = $row['preparedBy'];
            $caRef = $row['caRef'];
            
            $glCode[] = $row['glCode'];
            $mainAcct[] = $row['mainAcct'];
            $slID[] = $row['slID'];
            $slRef[] = $row['slRef'];
            $amount[] = $row['amount']; 
            $orNo[] = $row['orNo']; 
        }   
    }  

    $section = $phpWord->addSection([
        'pageSizeH' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(5.5),
        'pageSizeW' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(8.5),
        'marginLeft' => 600,
        'marginRight' => 600
    ]);

    $topBorderCell =
    [
        'borderTopColor' =>'000000',
        'borderTopSize' => 20
    ]; 

    $bottomBorderCell =
    [ 
        'borderBottomColor' =>'000000',
        'borderBottomSize' => 20 
    ];   

    $header = $section->createHeader(); 

    // -- HEADER MLE -- //
    $header->addText(
        'MLE TRADING',
        array('name' => 'Arial', 'size' => 12,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0))
    );       
    $header->addText(
        'LIQUIDATION',
        array('name' => 'Arial', 'size' => 9,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0)
    ); 
    $header->addTextBreak(); 
     
    $table = $header->addTable();  
  
    // -- PARTNER DETAILS -- //
    $table->addRow();
    $table->addCell(3000)->addText('LIQ Reference:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($liqRef), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('CA Reference:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText($caRef, array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $table->addRow();
    $table->addCell(3000)->addText('Partner Name:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($payeeID) .' '.strtoupper($payeeName), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('Date', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText($liqDate, array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
  
    $table->addRow();
    $table->addCell(3000)->addText('Remarks', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($particulars), array('name' => 'Arial', 'size' => 8.5,'bold' => false, 'italic'=> true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $section->addTextBreak(); 

    $table = $section->addTable();
    $table->addRow();
    $table->addCell(1500,$bottomBorderCell)->addText('GL CODE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(7000,$bottomBorderCell)->addText('CHARGES', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000,$bottomBorderCell)->addText('SL REF', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2500,$bottomBorderCell)->addText('OR NO', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000,$bottomBorderCell)->addText('AMOUNT', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
  
    $totalAmt = 0;
    for($x = 0;$x < count($glCode);$x++){
        $table->addRow(); 
        $table->addCell(1500)->addText($glCode[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(7000)->addText($mainAcct[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(9000)->addText($slID[$x] .' '. $slRef[$x] , array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(2500)->addText($orNo[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(3000)->addText(number_format((float)$amount[$x], 2, '.', ','), array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    
        $totalAmt = $totalAmt + floatvalue($amount[$x]);
    }

    $table->addRow();
    $table->addCell(1500)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(7000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2500)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table->addRow(); 
    $table->addCell(1500)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(7000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2500)->addText('TOTAL AMOUNT', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(3000)->addText(number_format((float)$totalAmt, 2, '.', ','), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $section->addTextBreak(1);

    $footer = $section->createFooter(); 
  
    $table1 = $footer->addTable();

    $table1->addRow(); 
    $table1->addCell(6000)->addText('Prepared By:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('Approved By:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText(strtoupper($preparedBy), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('MLE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
 
    $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007'); 
    header("Content-Disposition: attachment; filename=".strtoupper(str_replace(',', '', $liqRef)).".docx");
    $objWriter->save("php://output");
?>