<?php
    error_reporting(0);
    include_once('../modules/session-handler.php'); 
 
    $first =   $_SESSION['firstName'];
    $last =   $_SESSION['lastName'];
    $fullname = $_SESSION['firstName'] . ' ' . $_SESSION['lastName'];
    $position = ''; 
    $userid = $_SESSION['userID']; 
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="../build/images/favicon.ico" type="image/ico" />
        <style>
             table td[contenteditable="true"] {
                text-align: right; /* Aligns text to the right for numbers */
                cursor: pointer;   /* Changes cursor to indicate editability */
            }

            .date-controls {
                margin-bottom: 20px;
            }  

            .header-controls {
                margin-bottom: 10px; 
            } 

            .header-controls input[type="checkbox"] {
                margin-right: 10px;
            } 

            table {
                width: 100%;
                border-collapse: collapse;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                transition: box-shadow 0.3s ease;
            }  

            table:hover {
                box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
            }

            th, td {
                border: 1px solid #ddd;
                padding: 12px;
                text-align: left;
                transition: background-color 0.3s ease, transform 0.3s ease;
            }

            th {
                background-color: #f2f2f2;
                cursor: pointer;
            }   
         
 

            /* Allow rows to have variable heights */
            table tr {
                height: auto;
            }

            .checkbox-cell input[type="checkbox"] {
                transition: transform 0.2s ease;
            }

            .checkbox-cell input[type="checkbox"]:checked {
                transform: scale(1.2);
            }

            .checkbox-cell input[type="checkbox"]:not(:checked) {
                transform: scale(1);
            } 

            table th{
                vertical-align: middle; /* Centers the content vertically */
                text-align: center;      /* Optionally centers the text horizontally */
                padding: 8px;           /* Adds some padding around the text */
            }
            .checkbox-cell{
                text-align: center;
            }
            .non-editable {
                background-color: #f9f9f9;
                text-align: center;
            }
            /* Ensure the 6th column (Loan Deduction) is right-aligned */
            .table td:nth-child(6) {
                text-align: right; /* Align text to the right */
                vertical-align: middle; /* Center vertically */
            }
        </style>

        <title>IMS</title>

        <link href="../vendors/jquery.ui/css/jquery-ui.css" rel="stylesheet" />
        <!-- Bootstrap -->
        <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
        <!-- Font Awesome -->
        <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
        <!-- NProgress -->
        <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
        <!-- iCheck -->
        <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
	
        <!-- bootstrap-progressbar -->
        <link href="../vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css" rel="stylesheet">
        <!-- JQVMap -->
        <link href="../vendors/jqvmap/dist/jqvmap.min.css" rel="stylesheet"/>
        <!-- bootstrap-daterangepicker -->
        <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
        <!--Sweet Alert-->
        <link href="../vendors/sweetalert/sweetalert.css" rel="stylesheet" />
       
       
        <!-- Custom Theme Style -->
        <link href="../build/css/custom.min.css" rel="stylesheet">
    </head>

    <?php include_once('../modules/profile.php'); ?>
    <?php include_once('../modules/sidebar.php'); ?> 
    <?php include_once('../modules/top-nav.php'); ?> 

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Salary <small>Releasing of Salary</small></h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <input class="form-control" type="hidden" id="fullname" value="<?php echo $fullname; ?>" name="fullName">
                            <div class="col-md-2 col-sm-12 col-xs-12"> 
                                <label><b>Start Date </b></label> 
                                <input class="form-control" type="date" id="startDate" name="startDate">
                            </div>
                            <div class="col-md-2 col-sm-12 col-xs-12"> 
                                <label><b>End Date </b></label> 
                                <input class="form-control" type="date" id="endDate" name="endDate"> 
                            </div>
                            <div class="col-md-1 col-sm-12 col-xs-12"> 
                                <label><b> </b></label><br/>
                                <button type="button" onclick="genEmployee();" class="btn btn-md btn-success">Generate </button>
                            </div>  
                            <div class="col-md-7 col-sm-12 col-xs-12"> 
                                <label><b> </b></label><br/>
                                <button type="button" onclick="release();" class="btn btn-md btn-info" style="float:right;">Release </button>
                            </div>  
                            <div class="clearfix"></div>
                            <br/>
                            <div class="col-md-12 col-sm-12 col-xs-12 form-group">
                                <table id="editableTable" class="display table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Employee Name</th>
                                            <th>Release  
                                                <div class="header2-controls">   
                                                    <input type="checkbox" id="selectAllHeader2" onclick="toggleAllCheckboxes('header2')"> 
                                                </div>
                                            </th>
                                            <th>Total Gross Salary</th>
                                            <th>Deduction  
                                                <div class="header3-controls"> 
                                                    <input type="checkbox" id="selectAllHeader3" onclick="toggleAllCheckboxes('header3')"> 
                                                </div>
                                            </th>
                                            <th>Loan Deduction</th>
                                            <th>Total Net Salary</th> 
                                        </tr>
                                    </thead>
                                    <tbody id="tableBody">
                                        <!-- Data will be inserted here by JavaScript -->
                                    </tbody>
                                </table> 
                            </div>
                        </div>  
                    </div>  
                </div>    
            </div>             
        </div>
        <!-- /page content -->
        <?php include_once('../modules/footer.php'); ?>        
    </div>  
    
    <!-- jQuery -->
    <script src="../vendors/jquery/dist/jquery.min.js"></script>
    <script src="../vendors/jquery.ui/js/jquery-ui.js"></script>  
    <!-- Bootstrap -->
    <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- FastClick -->
    <script src="../vendors/fastclick/lib/fastclick.js"></script>
    <!-- NProgress -->
    <script src="../vendors/nprogress/nprogress.js"></script>
    <!-- Chart.js -->
    <script src="../vendors/Chart.js/dist/Chart.min.js"></script>
    <!-- gauge.js -->
    <script src="../vendors/gauge.js/dist/gauge.min.js"></script>
    <!-- bootstrap-progressbar -->
    <script src="../vendors/bootstrap-progressbar/bootstrap-progressbar.min.js"></script>
    <!-- iCheck -->
    <script src="../vendors/iCheck/icheck.min.js"></script>
    <!-- Skycons -->
    <script src="../vendors/skycons/skycons.js"></script>
    <!-- Flot -->
    <script src="../vendors/Flot/jquery.flot.js"></script>
    <script src="../vendors/Flot/jquery.flot.pie.js"></script>
    <script src="../vendors/Flot/jquery.flot.time.js"></script>
    <script src="../vendors/Flot/jquery.flot.stack.js"></script>
    <script src="../vendors/Flot/jquery.flot.resize.js"></script>
    <!-- Flot plugins -->
    <script src="../vendors/flot.orderbars/js/jquery.flot.orderBars.js"></script>
    <script src="../vendors/flot-spline/js/jquery.flot.spline.min.js"></script>
    <script src="../vendors/flot.curvedlines/curvedLines.js"></script>
    <!-- DateJS -->
    <script src="../vendors/DateJS/build/date.js"></script>
    <!-- JQVMap -->
    <script src="../vendors/jqvmap/dist/jquery.vmap.js"></script>
    <script src="../vendors/jqvmap/dist/maps/jquery.vmap.world.js"></script>
    <script src="../vendors/jqvmap/examples/js/jquery.vmap.sampledata.js"></script>
    <!-- bootstrap-daterangepicker -->
    <script src="../vendors/moment/min/moment.min.js"></script>
    <script src="../vendors/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- Datatables -->
    <script src="../vendors/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="../vendors/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    <script src="../vendors/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="../vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js"></script>
    <script src="../vendors/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="../vendors/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="../vendors/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="../vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js"></script>
    <script src="../vendors/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
    <script src="../vendors/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="../vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js"></script>
    <script src="../vendors/datatables.net-scroller/js/dataTables.scroller.min.js"></script>
    <script src="../vendors/jszip/dist/jszip.min.js"></script>
    <script src="../vendors/pdfmake/build/pdfmake.min.js"></script>
    <script src="../vendors/pdfmake/build/vfs_fonts.js"></script>
    <script src="../vendors/sweetalert/sweetalert.min.js"></script>

    <!-- Custom Theme Scripts -->
    <script src="../build/js/custom.min.js"></script>
    <script src="../build/js/index.js"></script>
    <script>
        var today = new Date().toISOString().split('T')[0];
        $("#startDate").val(today);
        $("#endDate").val(today);  

        function genEmployee(){
            var startDateStr = document.getElementById('startDate').value; 
            var endDateStr = document.getElementById('endDate').value; 

            // Convert the input strings to Date objects
            const startDate = new Date(startDateStr);
            const endDate = new Date(endDateStr);

            // Check if the start date is greater than the end date
            if (startDate > endDate) {
                swal("Error", 'Start Date should not be greater than End Date', "error");
                return; // Exit the function early
            } 

            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {startDateStr: startDateStr, endDateStr: endDateStr, task: "check-semp"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    populateTable(data);
                } 
            }); 
        }   

        function release(){ 
            const checkedValues = [];
            const table = document.getElementById('editableTable');
            var startDate = document.getElementById('startDate').value;
            var endDate = document.getElementById('endDate').value;
            var fullname = document.getElementById('fullname').value;

            // Ensure the table exists
            if (!table) {
                console.error('Table element with id "editableTable" not found.');
                return;
            }

            // Get all rows in the table body
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
            
            // Iterate through the rows, starting from index 0 to include all rows
            for (let i = 0; i < rows.length; i++) { 
                const cells = rows[i].cells;

                // Ensure there are enough cells in the row
                if (cells.length < 8) {
                    console.warn(`Row ${i} does not have enough cells.`);
                    continue;
                }
                
                const cellWithCheckbox = cells[2];
                const checkbox = cellWithCheckbox.querySelector('input[type="checkbox"]');
                
                // Check if the checkbox exists, is checked, is visible, and if the value in cell 3 is not 0.00
                if (checkbox && checkbox.checked && isElementVisible(checkbox)) {
                    const valueCell4 = cells[3]; // This should be the cell with the numeric value (Total Gross Salary)
                    const valueText4 = valueCell4.textContent || valueCell4.innerText;
                    const valueNumber4 = parseFloat(valueText4);

                    // Check if the value in the fourth cell is not 0.00
                    if (!isNaN(valueNumber4) && valueNumber4 !== 0.00) {
                        // Extract values from cells
                        const empID = cells[0].textContent || cells[0].innerText;
                        const empName = cells[1].textContent || cells[1].innerText;
                        const totalGross = cells[3].textContent || cells[3].innerText;
                        
                        // Determine if the checkbox in column 5 is checked (boolean)
                        const cellDedWithCheckbox = cells[4];
                        const checkDbox = cellDedWithCheckbox.querySelector('input[type="checkbox"]');
                        const activeDed = checkDbox ? checkDbox.checked : false;

                        const deduction = cells[5].textContent || cells[5].innerText;
                        const totalNet = cells[6].textContent || cells[6].innerText;
                        const loanRef = cells[7].textContent || cells[7].innerText;
                        
                        // Push collected data into the checkedValues array
                        checkedValues.push({
                            empID,
                            empName,
                            totalGross,
                            activeDed,
                            deduction,
                            totalNet,
                            loanRef
                        });
                    }
                }
            } 

            if (checkedValues.length > 0) {
                swal({
                    title: "<h6><b>IMS</b></h6>",
                    text: "Release Salary?",
                    html: true,
                    type: "info", 
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    closeOnEsc: false,
                    confirmButtonColor: "#DD6B55", 
                    confirmButtonText: "YES", 
                    cancelButtonText: "NO",
                    closeOnConfirm: false,
                }, function (isConfirm) {
                    if (isConfirm) {   
                        $.ajax({
                            url: "../modules/ims-process.php",
                            type: "POST",
                            data: {checkedValues: checkedValues, startDate: startDate, endDate: endDate, fullname: fullname, task: "convert-salary"},
                            async: true,
                            dataType: 'json',
                            cache: false,  
                            success: function(data)
                            {
                                if (JSON.stringify(data) === "\"saved\"") {
                                    swal({
                                        title: "<h6><b>Success</b></h6>",
                                        text: "Salary Released!",
                                        html: true,
                                        type: "success"
                                    }, function() {
                                        document.location.reload(true);
                                    });
                                }   
                                else {
                                    swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                                }
                            } 
                        });  
                    }
                });
            } else {
                // Ensure SweetAlert library is included in your project
                swal("Error", "Please Select an Employee for Releasing of Salary", "error");
            }
        }

        // Utility function to check if an element is visible
        // function isElementVisible(element) {
        //     const style = window.getComputedStyle(element);
        //     return style.display !== 'none' && style.visibility !== 'hidden' && style.opacity !== '0';
        // }  

        function isElementVisible(element) {
            if (!(element instanceof Element)) {
                console.error('Argument is not a DOM element');
                return false;
            }
            const style = window.getComputedStyle(element);
            return style.display !== 'none' &&
                style.visibility !== 'hidden' &&
                parseFloat(style.opacity) > 0 &&
                style.position !== 'absolute';
        }

        $(document).ready(function() {
            $('#tableBody').on('blur keydown', '[contenteditable]', function(e) {
                if (e.type === 'blur' || (e.type === 'keydown' && e.key === 'Enter')) {
                    e.preventDefault(); // Prevent default Enter key behavior
                    updateNetSalary($(this).closest('tr'));
                    $(this).blur(); // Trigger blur event to remove focus
                }
            });

            $('#tableBody').on('keypress', '[contenteditable]', function(e) {
                // Allow only numbers and comma, prevent others
                if (!/[0-9,]/.test(e.key)) {
                    e.preventDefault();
                }
            });
        });

        function populateTable(data) {
            var tableBody = $('#tableBody');
            tableBody.empty(); // Clear existing rows

            data.forEach(function(row, index) {
                var grossSalId = 'grossSal_' + (index + 1);
                var loanDeductionId = 'loanDeduction_' + (index + 1);
                var netSalaryId = 'netSalary_' + (index + 1);
                var hiddenValuesId = 'hiddenValues_' + (index + 1);

                // Convert loanDeductionValue to a number
                var loanDeductionValue = parseFloat(row.loanDeductionValue) || 0;

                // Determine if the loan deduction cell should be editable
                var isEditable = loanDeductionValue !== 0;
                var isCheckboxVisible = loanDeductionValue !== 0;

                var hiddenValues = row.loanRef;

                var rowHtml = `
                    <tr>
                        <td class="non-editable">${row.empID.toUpperCase()}</td>
                        <td class="non-editable" style="text-align:left;">${row.fullname.toUpperCase()}</td>
                        <td class="checkbox-cell">
                            <input type="checkbox" class="header2-checkbox" data-real-value="${row.grossSalValue}" onclick="updateValue(this, '${grossSalId}', ${row.grossSalValue})">
                        </td>
                        <td class="non-editable" style="text-align:right;" id="${grossSalId}">0.00</td>
                        <td class="checkbox-cell" ${isCheckboxVisible ? '' : 'style="visibility:hidden;"'}>
                            <input type="checkbox" class="header3-checkbox" data-real-value="${loanDeductionValue}" onclick="updateValue(this, '${loanDeductionId}', ${loanDeductionValue})">
                        </td>
                        <td class="${isEditable ? 'editable-cell' : 'non-editable'}" contenteditable="${isEditable}" id="${loanDeductionId}" data-real-value="${loanDeductionValue}">0.00</td>
                        <td class="non-editable" style="text-align:right;" id="${netSalaryId}">0.00</td>
                        <td id="${hiddenValuesId}" data-hidden-values="${JSON.stringify(hiddenValues).replace(/"/g, '')}" style="display:none;">${JSON.stringify(hiddenValues).replace(/"/g, '')}</td>  
                    </tr>
                `;
                tableBody.append(rowHtml);
            });
        } 

        function updateValue(checkbox, fieldId, realValue) {
            var field = $('#' + fieldId);
            var row = $(checkbox).closest('tr');
            var netSalaryCell = row.find('[id^=netSalary_]');

            // Check if the checkbox is checked or not
            if (checkbox.checked) {
                field.text(formatNumber(realValue.toFixed(2)));
            } else {
                field.text('0.00'); // Set loan deduction to 0 when unchecked
            }

            updateNetSalary(row);
        }

        function updateNetSalary(row) {
            var grossSalText = row.find('[id^=grossSal_]').text().replace(/,/g, '') || '0';
            var loanDeductionText = row.find('[id^=loanDeduction_]').text().replace(/,/g, '') || '0';
            var netSalaryCell = row.find('[id^=netSalary_]');

            var grossSal = parseFloat(grossSalText) || 0;
            var loanDeduction = parseFloat(loanDeductionText) || 0;

            var netSalary = (grossSal - loanDeduction).toFixed(2);
            netSalaryCell.text(formatNumber(netSalary));
        }

        function formatNumber(num) {
            var parts = num.toString().split(".");
            return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",") + (parts[1] ? "." + parts[1] : "");
        }

        function toggleAllCheckboxes(className) {
            var selectAllCheckbox = document.getElementById('selectAll' + className.charAt(0).toUpperCase() + className.slice(1));
            if (!selectAllCheckbox) {
                console.error('Select All checkbox with ID "selectAll' + className.charAt(0).toUpperCase() + className.slice(1) + '" not found.');
                return;
            }

            var checkboxes = document.querySelectorAll('.' + className + '-checkbox');
            var isChecked = selectAllCheckbox.checked;

            checkboxes.forEach(function(checkbox) {
                if (isElementVisible(checkbox)) {
                    var row = checkbox.closest('tr');
                    var cellId = (className === 'header2' ? 'grossSal_' : 'loanDeduction_') + (Array.from(row.parentNode.children).indexOf(row) + 1);
                    var realValue = parseFloat(checkbox.getAttribute('data-real-value')) || 0;

                    checkbox.checked = isChecked;
                    updateValue(checkbox, cellId, realValue);
                }
            });
        }


        // function toggleAllCheckboxes(className) {
        //     var selectAllCheckbox = $('#' + 'selectAll' + className.charAt(0).toUpperCase() + className.slice(1));
        //     if (!selectAllCheckbox.length) {
        //         console.error('Select All checkbox with ID "selectAll' + className.charAt(0).toUpperCase() + className.slice(1) + '" not found.');
        //         return;
        //     }
        //     var checkboxes = $('.' + className + '-checkbox');
        //     var isChecked = selectAllCheckbox.prop('checked');

        //     checkboxes.each(function() {
        //         var checkbox = $(this);
        //         var row = checkbox.closest('tr');
        //         var cellId = (className === 'header2' ? 'grossSal_' : 'loanDeduction_') + (checkbox.closest('tr').index() + 1);
        //         var realValue = parseFloat(checkbox.data('real-value')) || 0;

        //         checkbox.prop('checked', isChecked);
        //         updateValue(this, cellId, realValue);
        //     });
        // }
    </script> 
  </body>
</html>
