
// -- GENERAL -- //
function isNumber(evt) {
    // evt = (evt) ? evt : window.event;
    // var charCode = (evt.which) ? evt.which : evt.keyCode;
    // if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)) {
    //     return false;
    // }
    // return true;
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;

    // Allow numbers, backspace, delete, and the minus sign
    if (charCode != 46 && charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }

    // Allow only one minus sign at the beginning
    if (charCode == 45) {
        var input = evt.target.value;
        if (input.length > 0 || input.indexOf('-') > -1) {
            return false; // Disallow multiple minus signs or minus signs not at the start
        }
    }

    return true;
}  

function isValidDate(value) {
    const date = new Date(value);
    return date instanceof Date && !isNaN(date.getTime());
}

function isStringNullOrUndefined(str) {
    return str === null || str === undefined;
}

function areDatesValidAndComparing(mindate, maxdate) {
    if (isValidDate(mindate) && isValidDate(maxdate)) {
        const minDateObj = new Date(mindate);
        const maxDateObj = new Date(maxdate);
        
        return minDateObj.getTime() > maxDateObj.getTime();
    } else {
        throw new Error('One or both dates are invalid.');
    }
}

function parseCurrency(value) {
    // Remove commas and convert to a float
    return parseFloat(value.replace(/,/g, ''));
}

// Function to remove single quotes from input
function removeSingleQuote(input) {
    input.value = input.value.replace(/'/g, "");
}

// Event handler for keypress
function disableSingleQuote(event) {
    if (event.key === "'") {
        event.preventDefault();
    }
}

// Event handler for paste and input events
function onPasteOrInput(event) {
    removeSingleQuote(event.target);
}
 
// ITEM 
function newItem(){
    var itemCode = document.getElementById('itemCode').value;
    var itemName = document.getElementById('itemName').value;
    var chartCode = document.getElementById('chartCode').value;  
    var hchartCode = document.getElementById('hchartCode').value;  

    const checkbox = document.getElementById('existGL');
    var setup = '', chartName = '';
    // Check if the checkbox is checked
    if (checkbox.checked) {
        setup = 'exist';
        var d = document.getElementById("cType");
        chartName = d.options[d.selectedIndex].value; 

        var e = document.getElementById("hType");
        hchartName = e.options[e.selectedIndex].value; 
        
    } else {
        setup = 'new';
        var chartName = document.getElementById('chartName').value;
        var hchartName = document.getElementById('hchartName').value;
    }
 
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + itemName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {itemCode: itemCode, itemName: itemName, chartCode: chartCode, chartName: chartName, hchartName: hchartName, hchartCode: hchartCode, setup: setup, task: "new-item"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Item Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'item.php';
                        });
                    }
                    else if(JSON.stringify(data) == "\"duplicated\""){
                        swal({
                            title:"<h6><b>Error</b></h6>", 
                            text:"Item Code Exist!", 
                            html: true,
                            type: "error"
                        }, function () { 
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}  
function editItem(itemCode){
    window.location.href = 'modify-item.php?' + "itemCode="+ itemCode;
} 
function modifyItem(){
    var itemCode = document.getElementById('itemCode').value;
    var nitemName = document.getElementById('nitemName').value;
    var oitemName = document.getElementById('oitemName').value;

    var chartCode = document.getElementById('chartCode').value;  
    var hchartCode = document.getElementById('hchartCode').value;  
 
    var d = document.getElementById("cType");
    chartName = d.options[d.selectedIndex].value; 
    
    var e = document.getElementById("hType");
    hchartName = e.options[e.selectedIndex].value; 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + oitemName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {itemCode: itemCode, nitemName: nitemName, oitemName: oitemName, chartCode: chartCode, hchartCode: hchartCode, chartName: chartName, hchartName: hchartName, task: "revise-item"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Item Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'item.php';
                        });
                    }
                    else if(JSON.stringify(data) == "\"duplicated\""){
                        swal({
                            title:"<h6><b>Error</b></h6>", 
                            text:"Item Code Exist!", 
                            html: true,
                            type: "error"
                        }, function () { 
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteItem (id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Item?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-item"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Item Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
} 

// LOCATION
function newLocation(){
    var locationName = document.getElementById('locationName').value;
    var location = document.getElementById('location').value;
    var capacity = document.getElementById('capacity').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + locationName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {locationName: locationName, location: location, capacity: capacity, task: "new-location"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Location Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'location.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editLocation(locCode){
    window.location.href = 'modify-location.php?' + "locCode="+ locCode;
} 
function modifyLocation(){
    var locationID = document.getElementById('locationID').value;
    var locationName = document.getElementById('locationName').value;
    var location = document.getElementById('location').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + locationName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {locationID: locationID, locationName: locationName, location: location, task: "revise-location"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Location Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'location.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteLocation (id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Location?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-location"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Location Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
} 

// SUPPLIER
function newSupp(){ 
    var buying = document.getElementById('buying').value;
    var tinNo = document.getElementById('tinNo').value; 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + buying + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {buying: buying, tinNo: tinNo, task: "new-supplier"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Supplier Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'supplier.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editSupp(buyID){
    window.location.href = 'modify-supplier.php?' + "buyingID="+ buyID;
} 
function modifySupp(){
    var buying = document.getElementById('buying').value;
    var tinNo = document.getElementById('tinNo').value;
    var buyingID = document.getElementById('buyingID').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + buying + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {buyingID: buyingID, buying: buying, tinNo: tinNo, task: "revise-supplier"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Supplier Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'supplier.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteSupp(id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Supplier?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-supplier"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Supplier Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

// BUYING STATION
function newBuying(){ 
    var buying = document.getElementById('buying').value;
    var tinNo = document.getElementById('tinNo').value;
     
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + buying + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {buying: buying, tinNo: tinNo, task: "new-bs"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Buying Station Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'buying.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editBuying(buyID){
    window.location.href = 'modify-buying.php?' + "buyingID="+ buyID;
} 
function modifyBuying(){
    var buying = document.getElementById('buying').value;
    var tinNo = document.getElementById('tinNo').value;
    var buyingID = document.getElementById('buyingID').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + buying + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {buyingID: buyingID, buying: buying, tinNo: tinNo, task: "revise-bs"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Buying Station Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'buying.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteBuying(id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Buying Station?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-bs"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Buying Station Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

// CLIENT
function newClient(){ 
    var client = document.getElementById('client').value;
    var tinNo = document.getElementById('tinNo').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + client + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {client: client, tinNo: tinNo, task: "new-client"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Client Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'client.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editClient(clientID){
    window.location.href = 'modify-client.php?' + "clientID="+ clientID;
} 
function modifyClient(){
    var client = document.getElementById('client').value;
    var tinNo = document.getElementById('tinNo').value;
    var clientID = document.getElementById('clientID').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + client + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {clientID: clientID, client: client, tinNo: tinNo, task: "revise-client"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Client Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'client.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteClient (id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Client?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-client"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Client Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}
 
// EMPLOYEE
function newEmp(){ 
    var first = document.getElementById('first').value;
    var middle = document.getElementById('middle').value;
    var last = document.getElementById('last').value; 
    var rate = document.getElementById('rate').value;

    var f = document.getElementById("posName");
    var posName = f.options[f.selectedIndex].value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + first + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {first: first, middle: middle, last: last, rate: rate, posName: posName, task: "new-employee"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Employee Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'employee.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editEmp(empID){
    window.location.href = 'modify-employee.php?' + "empID="+ empID;
} 
function modifyEmp(){ 
    var empID = document.getElementById('empID').value;
    var first = document.getElementById('first').value;
    var middle = document.getElementById('middle').value;
    var last = document.getElementById('last').value; 
    var rate = document.getElementById('rate').value;

    var f = document.getElementById("posName");
    var posName = f.options[f.selectedIndex].value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + first + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {empID: empID, first: first, middle: middle, last: last, rate: rate, posName: posName, task: "revise-employee"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Employee Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'employee.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteEmp(id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Employee?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-employee"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Employee Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

// TRUCK
function newTruck(){ 
    var subCon = document.getElementById('subCon').value;
    var truckName = document.getElementById('truckName').value;
    var plateNumber = document.getElementById('plateNumber').value;   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + truckName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {subCon: subCon, truckName: truckName, plateNumber: plateNumber, task: "new-truck"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Truck Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'truck.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editTruck(truckID){
    window.location.href = 'modify-truck.php?' + "truckID="+ truckID;
}  
function modifyTruck(){  
    var truckID = document.getElementById('truckID').value;
    var subCon = document.getElementById('subCon').value;
    var truckName = document.getElementById('truckName').value;
    var plateNumber = document.getElementById('plateNumber').value;    

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + truckName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {truckID: truckID, subCon: subCon, truckName: truckName, plateNumber: plateNumber, task: "revise-truck"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Truck Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'truck.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteTruck(id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Truck?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-truck"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Truck Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

// USER
function newUser(){ 
    var first = document.getElementById('first').value; 
    var last = document.getElementById('last').value; 
    var uName = document.getElementById('uName').value;
    var pWord = document.getElementById('pWord').value; 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + uName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {first: first, uName: uName, last: last, pWord: pWord, task: "new-user"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"User Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'employee.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editUser(userID){
    window.location.href = 'modify-user.php?' + "userID="+ userID;
} 

//TEST//
function modifyUser(){ 
    var empID = document.getElementById('empID').value;
    var first = document.getElementById('first').value;
    var middle = document.getElementById('middle').value;
    var last = document.getElementById('last').value; 
    var rate = document.getElementById('rate').value;

    var f = document.getElementById("posName");
    var posName = f.options[f.selectedIndex].value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Revise " + first + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {empID: empID, first: first, middle: middle, last: last, rate: rate, posName: posName, task: "revise-employee"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Employee Modify!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'user.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function deleteUser(id){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove User?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {id: id,task: "archive-user"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"User Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

// COA
function newCOA(){
    var cLevel = document.getElementById('cLevel').value; 
    var cType = document.getElementById('cType').value; 
    var cName = document.getElementById('cName').value;
    var cCode = document.getElementById('cCode').value; 
    var cParent = document.getElementById('cParent').value;
  
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + cName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {cName: cName, cType: cType, cLevel: cLevel, cCode: cCode, cParent: cParent, task: "new-coa"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"COA Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'coa.php';
                        });
                    } 
                    else if(JSON.stringify(data) == "\"duplicate\""){
                        swal({
                            title:"<h6><b>Error</b></h6>", 
                            text:"There is already an existing GL Code based on your entry!", 
                            html: true,
                            type: "error"
                        }, function () { 
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
} 
function editCOA(code){
    window.location.href = 'modify-coa.php?' + "coaCode="+ code;
} 
function modifyCOA(){
    var cLevel = document.getElementById('cLevel').value; 
    var cType = document.getElementById('cType').value; 
    var cName = document.getElementById('cName').value;
    var cCode = document.getElementById('cCode').value; 
    var cParent = document.getElementById('cParent').value;
    var cID = document.getElementById('coaID').value;

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify " + cName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {cID: cID, cName: cName, cType: cType, cLevel: cLevel, cCode: cCode, cParent: cParent, task: "modify-coa"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"COA Revised!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'coa.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function removeCOA(code){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove COA?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {code: code,task: "archive-coa"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"COA Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}
function uploadCOA(data){
    const jsonData = JSON.stringify(data);

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Upload Excel?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/upload-process.php",
                type: "POST",
                contentType: 'application/json', 
                data: JSON.stringify({ data: data }),
                async: true,
                dataType: 'json', 
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"COA Uploaded!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }  
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}

function newAct(){
    var actName = document.getElementById('actName').value; 
    var coaGL = document.getElementById('coaGL').value;  
    var coaGLid = document.getElementById('coaGLid').value;  
 
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + actName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {coaGL: coaGL, coaGLid: coaGLid, actName: actName, task: "new-act"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Activity Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'activity.php';
                        });
                    }  
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function editActs(code){
    window.location.href = 'modify-act.php?' + "actCode="+ code;
} 
function modifyAct(){
    var actName = document.getElementById('actName').value; 
    var coaGL = document.getElementById('coaGLid').value;   
    var actCode = document.getElementById('actCode').value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify " + actName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {actName: actName, actCode: actCode, coaGL: coaGL, task: "modify-act"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Activity Revised!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'activity.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function removeAct(code){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Activity?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {code: code,task: "archive-act"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Activity Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

function newCharges(){
    var chargesName = document.getElementById('chargesName').value; 
    var coaGL = document.getElementById('coaGLid').value;  
 
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + chargesName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {coaGL: coaGL, chargesName: chargesName, task: "new-charges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'charges.php';
                        });
                    }  
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function editCharges(code){
    window.location.href = 'modify-charges.php?' + "chargeCode="+ code;
} 
function modifyCharges(){
    var chargesName = document.getElementById('actName').value; 
    var coaGL = document.getElementById('coaGLid').value;  
    var actCode = document.getElementById('actCode').value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify " + chargesName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {chargesName: chargesName, actCode: actCode, coaGL: coaGL, task: "modify-charges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Revised!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'charges.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function removeCharges(code){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Charges?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {code: code,task: "archive-charges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
}

function newiCharges(){
    var chargesName = document.getElementById('chargesName').value; 
    var coaGL = document.getElementById('coaGLid').value;  
 
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save " + chargesName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {coaGL: coaGL, chargesName: chargesName, task: "new-icharges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Saved!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'icharges.php';
                        });
                    }  
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function editiCharges(code){
    window.location.href = 'modify-icharges.php?' + "chargeCode="+ code;
} 
function modifyiCharges(){
    var chargesName = document.getElementById('actName').value; 
    var coaGL = document.getElementById('coaGLid').value;  
    var actCode = document.getElementById('actCode').value;  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify " + chargesName + "?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {chargesName: chargesName, actCode: actCode, coaGL: coaGL, task: "modify-icharges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"saved\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Revised!", 
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = 'icharges.php';
                        });
                    } 
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}
function removeiCharges(code){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Charges?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {code: code,task: "archive-icharges"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Charges Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    }); 
} 

function resAct(empID){
    var min = document.getElementById('min-date').value; 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Reset Activity?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {empID: empID, min: min, task: "reset-activity"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"User Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    });      
}
 
// WORKLOAD
function grpaddAct(){
    var selectedValues = $('#empName').val();
    var selectedTexts = []; 
  
    // Loop through each selected value and get the corresponding text
    selectedValues.forEach(function(value) {
      var optionText = $('#empName option[value="' + value + '"]').text();
      selectedTexts.push(optionText);
    });
    
    // // Display the selected values and their corresponding text
    // alert( "Selected Values: " + selectedValues.join(', ') + "\n" + "Selected Texts: " + selectedTexts.join(', '));

    var aID = selectedValues.join(', ');
    var aName = selectedTexts.join(', ');
    var aDate = document.getElementById("aDate").value;
    var dRate = document.getElementById("dRate").value;
    var aAct = document.getElementById("aAct").value;
    var aActGL = document.getElementById("aActGL").value;
    var aRep = document.getElementById("aRep").value;
    var aRate = document.getElementById("aRate").value;
    var aTotal = document.getElementById("aTotal").value;
    var lID = document.getElementById("lID").value;
    var iID = document.getElementById("iID").value;
    var gTotal = document.getElementById("gTotal").value;
    var lName = document.getElementById("lName").value;
    var iName = document.getElementById("iName").value;
    var aActID = document.getElementById("aActID").value;
    var mIn = document.getElementById("mIn").value;
    var mOut = document.getElementById("mOut").value;

    var button = document.getElementById('saveBTN');
    var buttonText = button.textContent || button.innerText; 
 
    if(buttonText.trim() === "Save"){
        swal({
            title: "<h6><b>IMS</b></h6>",
            text: "Save Workload?",
            html: true,
            type: "info", 
            showCancelButton: true,
            showLoaderOnConfirm: true,
            closeOnEsc: false,
            confirmButtonColor: "#DD6B55", 
            confirmButtonText: "YES", 
            cancelButtonText: "NO",
            closeOnConfirm: false,
        }, function (isConfirm) {
            if (isConfirm) {    
                $.ajax({
                    url: "../modules/ims-process.php",
                    type: "POST",
                    data: {mIn: mIn, mOut: mOut, aActID: aActID, aID: aID, aName: aName, aDate: aDate, dRate: dRate, aAct: aAct, aActGL: aActGL, aRep: aRep, aRate: aRate, aTotal: aTotal, lID: lID, iID: iID, gTotal: gTotal, lName: lName, iName: iName, task: "new-groupworkload"},
                    async: true,
                    dataType: 'json',
                    cache: false,  
                    success: function(data)
                    {
                        if(JSON.stringify(data) == "\"saved\""){
                            swal({
                                title:"<h6><b>Success</b></h6>", 
                                text:"Workload Saved!", 
                                html: true,
                                type: "success"
                            }, function () { 
                                loadAct();
                            });
                        } 
                        else{
                            swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                        }
                    },
                    error: function (jqXHR, exception) { 
                        if (jqXHR.status === 0) {
                            swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 404) {
                            swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 500) {
                            swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'parsererror') { 
                            swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'timeout') { 
                            swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'abort') { 
                            swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                        } else { 
                            swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                        }
                    }
                }); 
            }
        });
    }  
}

function addAct(){
    var aID = document.getElementById("aID").value;
    var aName = document.getElementById("aName").value;
    var aDate = document.getElementById("aDate").value;
    var dRate = document.getElementById("dRate").value;
    var aAct = document.getElementById("aAct").value;
    var aActGL = document.getElementById("aActGL").value;
    var aRep = document.getElementById("aRep").value;
    var aRate = document.getElementById("aRate").value;
    var aTotal = document.getElementById("aTotal").value;
    var lID = document.getElementById("lID").value;
    var iID = document.getElementById("iID").value;
    var gTotal = document.getElementById("gTotal").value;
    var lName = document.getElementById("lName").value;
    var iName = document.getElementById("iName").value;
    var aActID = document.getElementById("aActID").value;
     
    var button = document.getElementById('saveBTN');
    var buttonText = button.textContent || button.innerText; 
 
    if(buttonText.trim() === "Save"){
        swal({
            title: "<h6><b>IMS</b></h6>",
            text: "Save Workload of " + aName + "?",
            html: true,
            type: "info", 
            showCancelButton: true,
            showLoaderOnConfirm: true,
            closeOnEsc: false,
            confirmButtonColor: "#DD6B55", 
            confirmButtonText: "YES", 
            cancelButtonText: "NO",
            closeOnConfirm: false,
        }, function (isConfirm) {
            if (isConfirm) {    
                $.ajax({
                    url: "../modules/ims-process.php",
                    type: "POST",
                    data: {aActID: aActID, aID: aID, aName: aName, aDate: aDate, dRate: dRate, aAct: aAct, aActGL: aActGL, aRep: aRep, aRate: aRate, aTotal: aTotal, lID: lID, iID: iID, gTotal: gTotal, lName: lName, iName: iName, task: "new-workload"},
                    async: true,
                    dataType: 'json',
                    cache: false,  
                    success: function(data)
                    {
                        if(JSON.stringify(data) == "\"saved\""){
                            swal({
                                title:"<h6><b>Success</b></h6>", 
                                text:"Workload Saved!", 
                                html: true,
                                type: "success"
                            }, function () {
                                document.location.reload(true);
                            });
                        } 
                        else{
                            swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                        }
                    },
                    error: function (jqXHR, exception) { 
                        if (jqXHR.status === 0) {
                            swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 404) {
                            swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 500) {
                            swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'parsererror') { 
                            swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'timeout') { 
                            swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'abort') { 
                            swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                        } else { 
                            swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                        }
                    }
                }); 
            }
        });
    } 
    else{
        swal({
            title: "<h6><b>IMS</b></h6>",
            text: "Modify Workload of " + aName + "?",
            html: true,
            type: "info", 
            showCancelButton: true,
            showLoaderOnConfirm: true,
            closeOnEsc: false,
            confirmButtonColor: "#DD6B55", 
            confirmButtonText: "YES", 
            cancelButtonText: "NO",
            closeOnConfirm: false,
        }, function (isConfirm) {
            if (isConfirm) {    
                var workID = document.getElementById("workID").value;
                $.ajax({
                    url: "../modules/ims-process.php",
                    type: "POST",
                    data: {workID: workID, aActID: aActID, aID: aID, aName: aName, aDate: aDate, dRate: dRate, aAct: aAct, aActGL: aActGL, aRep: aRep, aRate: aRate, aTotal: aTotal, lID: lID, iID: iID, gTotal: gTotal, lName: lName, iName: iName, task: "modify-workload"},
                    async: true,
                    dataType: 'json',
                    cache: false,  
                    success: function(data)
                    {
                        if(JSON.stringify(data) == "\"saved\""){
                            swal({
                                title:"<h6><b>Success</b></h6>", 
                                text:"Workload Saved!", 
                                html: true,
                                type: "success"
                            }, function () {
                                document.location.reload(true);
                            });
                        } 
                        else{
                            swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                        }
                    },
                    error: function (jqXHR, exception) { 
                        if (jqXHR.status === 0) {
                            swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 404) {
                            swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 500) {
                            swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'parsererror') { 
                            swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'timeout') { 
                            swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'abort') { 
                            swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                        } else { 
                            swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                        }
                    }
                }); 
            }
        });
    }
}

function editAct(workID){  
    $.ajax({
        url: "../modules/ims-process.php",
        type: "POST",
        data: {workID: workID, task: "check-workload"},
        async: true,
        dataType: 'json',
        cache: false,  
        success: function(data)
        {   
            if (data.length > 0) { 
                const json = data[0];
                
                document.getElementById('workID').value = json.workID;
                document.getElementById('aActID').value = json.actID;
                document.getElementById('aActGL').value = json.glCode;
                document.getElementById('aAct').value = json.actName;
                document.getElementById('aRep').value = json.repitition;
                document.getElementById('aRate').value = json.rate;
                document.getElementById('aTotal').value = json.totalRate; 

                if(json.locID == "0") document.getElementById('lID').value = '';
                else document.getElementById('lID').value = json.locID;
                
                if(json.itemCode == "0") document.getElementById('iID').value = '';
                else document.getElementById('iID').value = json.itemCode;  

                document.getElementById('lName').value = json.locationName;
                document.getElementById('iName').value = json.itemName; 

                var button = document.getElementById('saveBTN'); 
                button.childNodes.forEach(function(node) {
                    if (node.nodeType === Node.TEXT_NODE) {
                        node.textContent = ' Update';
                    }
                }); 
            }
        },
        error: function (jqXHR, exception) { 
            if (jqXHR.status === 0) {
                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
            } else if (jqXHR.status == 404) {
                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
            } else if (jqXHR.status == 500) {
                    swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
            } else if (exception === 'parsererror') { 
                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
            } else if (exception === 'timeout') { 
                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
            } else if (exception === 'abort') { 
                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
            } else { 
                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
            }
        } 
    }); 
}
function cancelAct(){
    document.location.reload(true);
}
function deleteAct(workID){  
    var aName = document.getElementById('aName').value;
    var aDate = document.getElementById('aDate').value; 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Remove Activity?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {workID: workID, aName: aName, aDate: aDate, task: "remove-activity"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Activity Removed!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    });   
}
function genAct(){
    var mindate = document.getElementById('min-date').value;
    var maxdate = document.getElementById('max-date').value; 

    try {
        if (areDatesValidAndComparing(mindate, maxdate)) {
            swal("Error", 'Please Check for Valid Date!', "error");
        } else {
            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Generate Activity Report?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {    
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {mindate: mindate, maxdate: maxdate, task: "gen-workload"},
                        async: true,
                        dataType: 'json',
                        cache: false,  
                        success: function(data)
                        {  
                            if (Array.isArray(data) && data.length > 0) {
                                const json = data[0];
                                swal({
                                    title: "<h6><b>Success</b></h6>",
                                    text: "Workload Generated!",
                                    html: true,
                                    type: "success"
                                }, function () {
                                    window.location.href = '../modules/gen-act.php?min=' + encodeURIComponent(json.min) + '&max=' + encodeURIComponent(json.max);
                                });
                            } else {
                                swal("Error", "Unexpected response format.", "error");
                            }
                        },
                        error: function (jqXHR, exception) { 
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') { 
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') { 
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') { 
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else { 
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        }
    } catch (e) {
        swal("Error", 'Please Check for Valid Date!', "error");
    } 
}

// LOAN
function newLoan(){ 
    var loanerID = document.getElementById("loanerID").value;
    var loanerName = document.getElementById("loanerName").value;
    var loanerDate = document.getElementById("loanerDate").value;
    var loanerAmt = document.getElementById("loanerAmt").value;
    var loanerDed = document.getElementById("loanerDed").value;

    if(isValidDate(loanerDate)){
        if(loanerAmt == null || loanerAmt === ''){ 
            swal("Error", "Insert Amount!", "error"); 
        }
        else{
            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Save Loan of " + loanerName + "?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {     
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {loanerID: loanerID, loanerName: loanerName, loanerDate: loanerDate, loanerAmt: loanerAmt, loanerDed: loanerDed, task: "new-loan"},
                        async: true,
                        dataType: 'json',
                        cache: false,  
                        success: function(data)
                        {
                            if(JSON.stringify(data) == "\"saved\""){
                                swal({
                                    title:"<h6><b>Success</b></h6>", 
                                    text:"Loan Saved!", 
                                    html: true,
                                    type: "success"
                                }, function () {
                                    window.location.href = 'l-loans.php';
                                });
                            } 
                            else if(JSON.stringify(data) == "\"existing\""){
                                swal({
                                    title:"<h6><b>Error</b></h6>", 
                                    text:"Loaner has an existing Loan Please finish the first Loan!", 
                                    html: true,
                                    type: "error"
                                }, function () {
                                    document.location.reload(true);
                                });
                            } 
                            else{
                                swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                            }
                        },
                        error: function (jqXHR, exception) { 
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') { 
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') { 
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') { 
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else { 
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        }
    }
    else{
        swal("Error", "Date Invalid!", "error");
    }
}
function release(){
    var loanerRef = document.getElementById("loanerRef").value;
    var releaseDate = document.getElementById("releaseDate").value;
    var lAmt = document.getElementById("lAmt").value;

    if(isValidDate(releaseDate)){ 
        swal({
            title: "<h6><b>IMS</b></h6>",
            text: "Release Loan # " + loanerRef + "?",
            html: true,
            type: "info", 
            showCancelButton: true,
            showLoaderOnConfirm: true,
            closeOnEsc: false,
            confirmButtonColor: "#DD6B55", 
            confirmButtonText: "YES", 
            cancelButtonText: "NO",
            closeOnConfirm: false,
        }, function (isConfirm) {
            if (isConfirm) {     
                $.ajax({
                    url: "../modules/ims-process.php",
                    type: "POST",
                    data: {loanerRef: loanerRef, releaseDate: releaseDate, lAmt: lAmt, task: "rel-loan"},
                    async: true,
                    dataType: 'json',
                    cache: false,  
                    success: function(data)
                    {
                        if(JSON.stringify(data) == "\"release\""){
                            swal({
                                title:"<h6><b>Success</b></h6>", 
                                text:"Loan Released!", 
                                html: true,
                                type: "success"
                            }, function () {
                                document.location.reload(true);
                            });
                        } 
                        else{
                            swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                        }
                    },
                    error: function (jqXHR, exception) { 
                        if (jqXHR.status === 0) {
                            swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 404) {
                            swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 500) {
                            swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'parsererror') { 
                            swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'timeout') { 
                            swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'abort') { 
                            swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                        } else { 
                            swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                        }
                    }
                }); 
            }
        });
    }
    else{
        swal("Error", "Date Invalid!", "error");
    }
}  

function modifyLoan(){
    var loanerID = document.getElementById("loanerID").value;
    var loanRef = document.getElementById("loanRef").value;
    var loanerName = document.getElementById("loanerName").value;
    var loanerDate = document.getElementById("loanerDate").value;
    var loanerAmt = document.getElementById("loanerAmt").value;
    var loanerDed = document.getElementById("loanerDed").value;

    if(isValidDate(loanerDate)){
        if(loanerAmt == null || loanerAmt === ''){ 
            swal("Error", "Insert Amount!", "error"); 
        }
        else{
            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Modify Loan of " + loanerName + "?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {     
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {loanRef: loanRef, loanerID: loanerID, loanerName: loanerName, loanerDate: loanerDate, loanerAmt: loanerAmt, loanerDed: loanerDed, task: "modify-loan"},
                        async: true,
                        dataType: 'json',
                        cache: false,  
                        success: function(data)
                        {
                            if(JSON.stringify(data) == "\"saved\""){
                                swal({
                                    title:"<h6><b>Success</b></h6>", 
                                    text:"Loan Modify!", 
                                    html: true,
                                    type: "success"
                                }, function () {
                                    window.location.href = 'l-loans.php';
                                });
                            } 
                            else{
                                swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                            }
                        },
                        error: function (jqXHR, exception) { 
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') { 
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') { 
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') { 
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else { 
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        }
    }
    else{
        swal("Error", "Date Invalid!", "error");
    }
}
function canLoan(loanRef){   
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Loan?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {  
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {loanRef: loanRef, task: "remove-loan"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {
                    if(JSON.stringify(data) == "\"archive\""){
                        swal({
                            title:"<h6><b>Success</b></h6>", 
                            text:"Loan Cancelled!", 
                            html: true,
                            type: "success"
                        }, function () {
                            document.location.reload(true);
                        });
                    }
                    else{
                        swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });
        }
    });                   
}

// ADJ

function newAdj(){ 
    var loanRef = document.getElementById("loanRef").value;
    var loanBal = document.getElementById("loanBal").value; 

    var f = document.getElementById("adjType");
    var adjType = f.options[f.selectedIndex].value;  

    var f = document.getElementById("mopType");
    var mopType = f.options[f.selectedIndex].value;  
 
    var loanerDate = document.getElementById("loanerDate").value;
    var loanerAmt = document.getElementById("loanerAmt").value;

    if(isValidDate(loanerDate)){
        if(loanerAmt == null || loanerAmt === ''){ 
            swal("Error", "Insert Amount!", "error"); 
        }
        else{ 
            if(Number(loanerAmt) > Number(loanBal) && adjType == 'deduct'){
                swal("Error", "Payment should not exist with remaining Balance!", "error"); 
            }
            else  {
                swal({
                    title: "<h6><b>IMS</b></h6>",
                    text: "Save Adjustment of " + loanRef + "?",
                    html: true,
                    type: "info", 
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    closeOnEsc: false,
                    confirmButtonColor: "#DD6B55", 
                    confirmButtonText: "YES", 
                    cancelButtonText: "NO",
                    closeOnConfirm: false,
                }, function (isConfirm) {
                    if (isConfirm) {     
                        $.ajax({
                            url: "../modules/ims-process.php",
                            type: "POST",
                            data: {loanRef: loanRef, loanBal: loanBal, adjType: adjType, mopType: mopType, loanerDate: loanerDate, loanerAmt: loanerAmt, task: "new-adj"},
                            async: true,
                            dataType: 'json',
                            cache: false,  
                            success: function(data)
                            {
                                if(JSON.stringify(data) == "\"saved\""){
                                    swal({
                                        title:"<h6><b>Success</b></h6>", 
                                        text:"Adjusment Saved!", 
                                        html: true,
                                        type: "success"
                                    }, function () {
                                        window.location.href = 'l-adj.php';
                                    });
                                } 
                                else if(JSON.stringify(data) == "\"less\""){
                                    swal({
                                        title:"<h6><b>Error</b></h6>", 
                                        text:"Deduction should not be less than remaining balance!", 
                                        html: true,
                                        type: "error"
                                    }, function () {
                                        document.location.reload(true);
                                    });
                                }
                                else if(JSON.stringify(data) == "\"greater\""){
                                    swal({
                                        title:"<h6><b>Error</b></h6>", 
                                        text:"Adjustment can't be greater than Loan Amount!", 
                                        html: true,
                                        type: "error"
                                    }, function () {
                                        document.location.reload(true);
                                    });
                                }
                                else{
                                    swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                                }
                            },
                            error: function (jqXHR, exception) { 
                                if (jqXHR.status === 0) {
                                    swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                                } else if (jqXHR.status == 404) {
                                    swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                                } else if (jqXHR.status == 500) {
                                    swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'parsererror') { 
                                    swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'timeout') { 
                                    swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'abort') { 
                                    swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                                } else { 
                                    swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                                }
                            }
                        }); 
                    }
                });
            }
        }
    }
    else{
        swal("Error", "Date Invalid!", "error");
    }
}

function genHistory(){
    var loanRef = document.getElementById('loanRef').value; 
    var loanerID = document.getElementById('loanerID').value;  

    try {
        if (isStringNullOrUndefined(loanRef)) {
            swal("Error", 'Please select Loan Reference', "error");
        } else {
            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Generate Loan History?",
                html: true,
                type: "info", 
                showCancelButton: true, 
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {    
                    swal.close();
                    window.location.href = '../modules/gen-loan.php?r=' + loanRef + '&n=' + loanerID; 
                }
            });
        }
    } catch (e) {
        swal("Error", 'Please Check for Valid Date!', "error");
    } 
} 

// CA
function newCA(){
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;
    var caDate = document.getElementById("caDate").value;
    var particulars = document.getElementById("particulars").value;
    var preparedBy = document.getElementById("preparedBy").value;
    var totalcaAmt = document.getElementById("totalcaAmt").value;

    const rows = document.querySelectorAll('#ca-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !caDate || !particulars || !preparedBy || !totalcaAmt) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    } 

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
             if (index < 10) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    }); 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    payeeID: payeeID,
                    payeeName: payeeName,
                    caDate: caDate,
                    particulars: particulars,
                    preparedBy: preparedBy,
                    totalcaAmt: totalcaAmt,
                    tableData: JSON.stringify(tableData),  
                    task: "new-ca"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'adv-operating.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}

function modifyCA(){
    var caRef = document.getElementById("caRef").value;
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;
    var caDate = document.getElementById("caDate").value;
    var particulars = document.getElementById("particulars").value;
    var preparedBy = document.getElementById("preparedBy").value;
    var totalcaAmt = document.getElementById("totalcaAmt").value;

    const rows = document.querySelectorAll('#ca-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    // Check if any field is blank or null
    if (!caRef || !payeeID || !payeeName || !caDate || !particulars || !preparedBy || !totalcaAmt) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    } 

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
             if (index < 10) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    }); 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    caRef: caRef,
                    payeeID: payeeID,
                    payeeName: payeeName,
                    caDate: caDate,
                    particulars: particulars,
                    preparedBy: preparedBy,
                    totalcaAmt: totalcaAmt,
                    tableData: JSON.stringify(tableData),  
                    task: "modify-ca"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Modified!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'adv-operating.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}

function canCA(caRef){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    caRef: caRef, 
                    task: "cancel-ca"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Cancelled!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });    
}

function relCA(caRef) {     
    var fName = document.getElementById("fName").value;   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Release Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    caRef: caRef, 
                    fName: fName,
                    task: "release-ca"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Released!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });   
}  

function unrelCA(caRef) {     
    var fName = document.getElementById("fName").value;   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Unrelease Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    caRef: caRef, 
                    fName: fName,
                    task: "unrelease-ca"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Unreleased!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });   
}  

// LIQ
function newLiq(){
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value; 
    var caRef = document.getElementById("caRef").value; 
    var particulars = document.getElementById("particulars").value;
    var preparedBy = document.getElementById("preparedBy").value;
    var totalBAL = document.getElementById("totalBAL").value;
    var totalLIQ = document.getElementById("totalcaAmt").value;

    const rows = document.querySelectorAll('#ca-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !particulars || !preparedBy || !totalLIQ) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    } 

    const value1 = parseFloat(totalBAL);
    const value2 = parseFloat(totalLIQ);

    if (!isNaN(value1) && !isNaN(value2)) {
        if (value1 >= value2) {
            const tableData = [];
            rows.forEach(row => {
                const rowData = [];
                row.querySelectorAll('td').forEach((cell, index) => {
                    if (index < 7) {
                        rowData.push(cell.textContent.trim());
                    }
                });
                tableData.push(rowData);
            }); 

            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Save Liquidation?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {     
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {
                            payeeID: payeeID,
                            payeeName: payeeName, 
                            caRef: caRef,
                            particulars: particulars,
                            preparedBy: preparedBy,
                            totalBAL: totalBAL,
                            totalLIQ: totalLIQ,
                            tableData: JSON.stringify(tableData),  
                            task: "new-liq"
                        },
                        async: true,
                        dataType: 'json',
                        cache: false,
                        success: function(data) {
                            if (JSON.stringify(data) === "\"saved\"") {
                                swal({
                                    title: "<h6><b>Success</b></h6>",
                                    text: "Liquidation Saved!",
                                    html: true,
                                    type: "success"
                                }, function() {
                                    window.location.href = 'liq-operating.php';
                                });
                            }   
                            else {
                                swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                            }
                        },
                        error: function(jqXHR, exception) {
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') {
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') {
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') {
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else {
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        } 
        else if (value1 < value2) {
            swal("Error", "Liquidation should not be greater than existing balance!", "error");
            return;    
        }    
    } 
    else {
        swal("Error", "Invalid Entry!", "error");
        return;  
    } 
}

function modifyLiq(){
    var liqRef = document.getElementById("liqRef").value;
    var liqDate = document.getElementById("liqDate").value;  
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value; 
    var caRef = document.getElementById("caRef").value; 
    var caDate = document.getElementById("caDate").value;  
    var particulars = document.getElementById("particulars").value;
    var preparedBy = document.getElementById("preparedBy").value;
    var totalBAL = document.getElementById("totalBAL").value;
    var existingLiq = document.getElementById("existingLiq").value; 
    var totalLIQ = document.getElementById("totalcaAmt").value;

    const rows = document.querySelectorAll('#ca-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !particulars || !preparedBy || !totalLIQ) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    } 

    const value1 = parseFloat(totalBAL);
    const value2 = parseFloat(totalLIQ);
    const value3 = parseFloat(existingLiq);
  
    if (!isNaN(value1) && !isNaN(value2) && !isNaN(value3)) {
        if (value1 + value3 >= value2) {
            const tableData = [];
            rows.forEach(row => {
                const rowData = [];
                row.querySelectorAll('td').forEach((cell, index) => {
                    if (index < 7) {
                        rowData.push(cell.textContent.trim());
                    }
                });
                tableData.push(rowData);
            }); 

            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Modify Liquidation?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {     
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {
                            liqRef: liqRef,
                            liqDate: liqDate,
                            payeeID: payeeID,
                            payeeName: payeeName, 
                            caRef: caRef,
                            caDate: caDate,
                            particulars: particulars,
                            preparedBy: preparedBy,
                            totalBAL: totalBAL,
                            existingLiq: existingLiq,
                            totalLIQ: totalLIQ,
                            tableData: JSON.stringify(tableData),  
                            task: "modify-liq"
                        },
                        async: true,
                        dataType: 'json',
                        cache: false,
                        success: function(data) {
                            if (JSON.stringify(data) === "\"saved\"") {
                                swal({
                                    title: "<h6><b>Success</b></h6>",
                                    text: "Liquidation Revised!",
                                    html: true,
                                    type: "success"
                                }, function() {
                                    window.location.href = 'liq-operating.php';
                                });
                            }   
                            else {
                                swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                            }
                        },
                        error: function(jqXHR, exception) {
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') {
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') {
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') {
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else {
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        } 
        else if (value1 + value3 < value2) {
            swal("Error", "Liquidation should not be greater than existing balance!", "error");
            return;    
        }    
    } 
    else {
        swal("Error", "Invalid Entry!", "error");
        return;  
    } 
}

function canLiq(liqRef){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Liquidation?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    liqRef: liqRef, 
                    task: "cancel-liq"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"cancelled\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Liquidation Cancelled!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });    
}

function appLiq(liqRef){
    var fName = document.getElementById("fName").value;   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Approve Liquidation?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    liqRef: liqRef,  
                    task: "approve-liq"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Liquidation Approved!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });   
} 

function newIncoming(){
    const rows = document.querySelectorAll('#incomingTable tbody tr');
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;  
    var pDate = document.getElementById("pDate").value;
    var pTime = document.getElementById("pTime").value; 
    var iParticular = document.getElementById("iParticular").value; 
    var deduction = document.getElementById("deduction").value; 
    var totalExp = document.getElementById("totalExp").value; 
    const checkbox = document.getElementById("showLoans");

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    if(parseFloat(totalExp) < 0){
        swal("Error", "Charges should be greater than deduction set.", "error");
        return;  
    }

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !iParticular) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  
  
    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
            if (index < 11) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    });            

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Purchase?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    checks: checkbox.checked,
                    deduction: deduction,
                    payeeID: payeeID,
                    payeeName: payeeName, 
                    pDate: pDate,
                    pTime: pTime,
                    iParticular: iParticular, 
                    tableData: JSON.stringify(tableData),  
                    task: "new-po"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Purchased Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'i-incoming.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function cancelPurchase(purchaseNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Purchase?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    purchaseNo: purchaseNo, 
                    task: "cancel-po"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Purchase Cancelled!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}  

function updateIncoming(){
    var poNo = document.getElementById("poNo").value;
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;  
    var pDate = document.getElementById("pDate").value;
    var pTime = document.getElementById("pTime").value; 
    var iParticular = document.getElementById("iParticular").value; 

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !iParticular) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify Purchase?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    poNo: poNo,
                    payeeID: payeeID,
                    payeeName: payeeName, 
                    pDate: pDate,
                    pTime: pTime,
                    iParticular: iParticular,    
                    task: "modify-po"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Purchased Modify!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function appPurchase(purchaseNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Approve Purchase?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    purchaseNo: purchaseNo, 
                    task: "approve-po"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Purchase Approve!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function conPurchase(){
    var payeeID = document.getElementById("payeeID").value;
    var poNo = document.getElementById("poNo").value; 
    var payeeName = document.getElementById("payeeName").value;
    var caDate = document.getElementById("caDate").value;
    var particulars = document.getElementById("particulars").value;
    var preparedBy = document.getElementById("preparedBy").value;
    var totalcaAmt = document.getElementById("totalcaAmt").value;

    const rows = document.querySelectorAll('#ca-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !caDate || !particulars || !preparedBy || !totalcaAmt) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    } 

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
             if (index < 10) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    }); 

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Cash Advance?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    poNo: poNo,
                    payeeID: payeeID,
                    payeeName: payeeName,
                    caDate: caDate,
                    particulars: particulars,
                    preparedBy: preparedBy,
                    totalcaAmt: totalcaAmt,
                    tableData: JSON.stringify(tableData),  
                    task: "con-purchase"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Cash Advanced Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'adv-operating.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function disPurchase(purchaseNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Disapprove Purchase?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    purchaseNo: purchaseNo, 
                    task: "disapprove-po"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Purchase Disapproved!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}  

function genDisbursement(){
    var mindate = document.getElementById('min-date').value;
    var maxdate = document.getElementById('max-date').value; 

    try {
        if (areDatesValidAndComparing(mindate, maxdate)) {
            swal("Error", 'Please Check for Valid Date!', "error");
        } else {
            swal({
                title: "<h6><b>IMS</b></h6>",
                text: "Generate Disbursement Report?",
                html: true,
                type: "info", 
                showCancelButton: true,
                showLoaderOnConfirm: true,
                closeOnEsc: false,
                confirmButtonColor: "#DD6B55", 
                confirmButtonText: "YES", 
                cancelButtonText: "NO",
                closeOnConfirm: false,
            }, function (isConfirm) {
                if (isConfirm) {    
                    $.ajax({
                        url: "../modules/ims-process.php",
                        type: "POST",
                        data: {mindate: mindate, maxdate: maxdate, task: "gen-disbursement"},
                        async: true,
                        dataType: 'json',
                        cache: false,  
                        success: function(data)
                        {  
                            if (Array.isArray(data) && data.length > 0) {
                                const json = data[0];
                                swal({
                                    title: "<h6><b>Success</b></h6>",
                                    text: "Disbursement Generated!",
                                    html: true,
                                    type: "success"
                                }, function () {
                                    window.location.href = '../modules/gen-disbursement.php?min=' + encodeURIComponent(json.min) + '&max=' + encodeURIComponent(json.max);
                                });
                            } else {
                                swal("Error", "Unexpected response format.", "error");
                            }
                        },
                        error: function (jqXHR, exception) { 
                            if (jqXHR.status === 0) {
                                swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 404) {
                                swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                            } else if (jqXHR.status == 500) {
                                swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'parsererror') { 
                                swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'timeout') { 
                                swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                            } else if (exception === 'abort') { 
                                swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                            } else { 
                                swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                            }
                        }
                    }); 
                }
            });
        }
    } catch (e) {
        swal("Error", 'Please Check for Valid Date!', "error");
    } 
}

function genSumExp(){
    var f = document.getElementById("slCMB");
    var slCMB = f.options[f.selectedIndex].value;   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Generate Summary of Expense Report?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {    
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {slCMB: slCMB, task: "gen-summary-exp"},
                async: true,
                dataType: 'json',
                cache: false,  
                success: function(data)
                {  
                    if (Array.isArray(data) && data.length > 0) {
                        const json = data[0];
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Summary of Expenses Generated!",
                            html: true,
                            type: "success"
                        }, function () {
                            window.location.href = '../modules/gen-sum-exp.php?slCMB=' + encodeURIComponent(json.slCMB);
                        });
                    } else {
                        swal("Error", "Unexpected response format.", "error");
                    }
                },
                error: function (jqXHR, exception) { 
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') { 
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') { 
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') { 
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else { 
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });
}

function newOutgoing(){
    const rows = document.querySelectorAll('#incomingTable tbody tr');
    const payeeID = document.getElementById('payeeID').value;
    const payeeName = document.getElementById('payeeName').value;
    const pDate = document.getElementById('pDate').value;
    const pTime = document.getElementById('pTime').value;  
    const lID = document.getElementById('lID').value;
    const lName = document.getElementById('lName').value;
    const iID = document.getElementById('iID').value;
    const iName = document.getElementById('iName').value; 
    const dFill = document.getElementById('dFill').value; 
    const totalExp = document.getElementById('totalExp').value; 

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    } 

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !pDate || !pTime) {
        swal("Error", 'Please Complete Entry!', "error");
        return;
    }   
  
    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
            if (index < 10) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    });            

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Invoice?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    payeeID: payeeID,
                    payeeName: payeeName,
                    pDate: pDate,
                    pTime: pTime,  
                    lID: lID,
                    lName: lName,
                    iID: iID,
                    iName: iName, 
                    dFill: dFill,  
                    totalExp: totalExp,
                    tableData: JSON.stringify(tableData),  
                    task: "new-invoice"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Invoice Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'i-outgoing.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function appInvoice(invoiceNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Approve Invoice?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    invoiceNo: invoiceNo, 
                    task: "approve-invoice"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Invoice Approve!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function disInvoice(invoiceNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Disapproved Invoice?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    invoiceNo: invoiceNo, 
                    task: "disapprove-invoice"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Invoice Disapprove!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function canInvoice(invoiceNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Invoice?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    invoiceNo: invoiceNo, 
                    task: "cancel-invoice"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"cancel\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Invoice Cancel!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function saveTrucking(){
    const invoiceNo = document.getElementById('invoiceNo').value;
    const subConID = document.getElementById('subConID').value;
    const depTime = document.getElementById('depTime').value;
    const depDate = document.getElementById('depDate').value;

    if (!subConID || !depTime || !depDate) { 
        swal("Error", "Complete requirements!", "error");
        return;  
    }   

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Add Trucking?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    invoiceNo: invoiceNo, 
                    subConID: subConID,
                    depDate: depDate,
                    depTime: depTime,
                    task: "save-trucking"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Trucking Added!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function newArrival(){
    const arrinvoiceNo = document.getElementById('arrinvoiceNo').value;
    const arrDelivery = document.getElementById('arrDelivery').value;
    const arrLoc = document.getElementById('arrLoc').value;
    const arrDate = document.getElementById('arrDate').value;  
    const arrTime = document.getElementById('arrTime').value;
    const itemNo = document.getElementById('itemNo').value;
    const itemName = document.getElementById('itemName').value;
    const arrSack = document.getElementById('arrSack').value; 
    const arrWeight = document.getElementById('arrWeight').value; 
    const arrDed = document.getElementById('arrDed').value; 
    const arrNet = document.getElementById('arrNet').value; 
    const arrPrice = document.getElementById('arrPrice').value;  

    // Check if any field is blank or null
    if (!arrinvoiceNo || !arrDelivery || !arrLoc || !arrDate || !arrTime || !itemNo || !itemName || !arrSack || !arrWeight || !arrDed || !arrNet || !arrPrice) {
        swal("Error", 'Please Complete Entry!', "error");
        return;
    }
    
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Arrival Details?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    arrinvoiceNo: arrinvoiceNo,
                    arrDelivery: arrDelivery,
                    arrLoc: arrLoc,
                    arrDate: arrDate,  
                    arrTime: arrTime,
                    itemNo: itemNo,
                    itemName: itemName,
                    arrSack: arrSack, 
                    arrWeight: arrWeight,  
                    arrDed: arrDed,
                    arrNet: arrNet,  
                    arrPrice: arrPrice, 
                    task: "new-arrival"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Arrival Details Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'i-outgoing.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function updateOutgoing(){
    var invNo = document.getElementById("invNo").value;
    var clientID = document.getElementById("clientID").value;
    var clientName = document.getElementById("clientName").value;  
    var iDate = document.getElementById("iDate").value;
    var iTime = document.getElementById("iTime").value;  

    // Check if any field is blank or null
    if (!invNo || !clientID || !clientName || !iDate || !iTime) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify Invoice?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    invNo: invNo,
                    clientID: clientID,
                    clientName: clientName, 
                    iDate: iDate,
                    iTime: iTime,  
                    task: "modify-invoice"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Invoice Modify!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function newCol(){
    var invNo = document.getElementById("invNo").value;
    var cName = document.getElementById("cName").value;
    var orNo = document.getElementById("orNo").value;
    var cID = document.getElementById("cID").value;
    var iName = document.getElementById("iName").value;
    var arrGL = document.getElementById("arrGL").value;
    var arrMain = document.getElementById("arrMain").value;
    var totalAmt = document.getElementById("totalAmt").value;  
    var colDate = document.getElementById("colDate").value;  
    
    const rows = document.querySelectorAll('#col-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    if(parseFloat(totalAmt) < 0){
        swal("Error", "Total should not be negative", "error");
        return;  
    }

    // Check if any field is blank or null
    if (!invNo || !cName || !iName || !cID || !arrGL || !arrMain || !colDate || !orNo) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
            if (index < 3) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    });  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Collection?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: { 
                    invNo: invNo,
                    cID: cID,
                    totalAmt: totalAmt, 
                    arrGL: arrGL,
                    arrMain: arrMain,
                    colDate: colDate,
                    orNo: orNo,
                    tableData: JSON.stringify(tableData),  
                    task: "new-col"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Collection Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'pro-collection.php';
                        });
                    }  
                    else if (JSON.stringify(data) === "\"exist\"") {
                        swal("Error", 'OR No Exist!', "error");
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function modifyCol(){
    var invNo = document.getElementById("invNo").value;
    var cName = document.getElementById("cName").value;
    var orNo = document.getElementById("orNo").value;
    var cID = document.getElementById("cID").value;
    var iName = document.getElementById("iName").value;
    var arrGL = document.getElementById("arrGL").value;
    var arrMain = document.getElementById("arrMain").value;
    var totalAmt = document.getElementById("totalAmt").value;  
    var colDate = document.getElementById("colDate").value;  
    var oldorNo = document.getElementById("oldorNo").value;   
    
    const rows = document.querySelectorAll('#col-table tbody tr');

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    }

    if(parseFloat(totalAmt) < 0){
        swal("Error", "Total should not be negative", "error");
        return;  
    }

    // Check if any field is blank or null
    if (!invNo || !cName || !iName || !cID || !arrGL || !arrMain || !colDate || !orNo) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
            if (index < 3) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    });  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify Collection?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: { 
                    invNo: invNo,
                    cID: cID,
                    totalAmt: totalAmt, 
                    arrGL: arrGL,
                    arrMain: arrMain,
                    colDate: colDate,
                    orNo: orNo,
                    oldorNo: oldorNo, 
                    tableData: JSON.stringify(tableData),  
                    task: "modify-col"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Collection Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'pro-collection.php';
                        });
                    }  
                    else if (JSON.stringify(data) === "\"exist\"") {
                        swal("Error", 'OR No Exist!', "error");
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
} 

function newContract(){
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;  
    var pDate = document.getElementById("pDate").value;
    var pTime = document.getElementById("pTime").value; 
    var iID = document.getElementById("iID").value;
    var iName = document.getElementById("iName").value; 
    var iWeight = document.getElementById("iWeight").value; 
    var tPrice = document.getElementById("tPrice").value;  

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !iID || !iName || !iWeight || !tPrice) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Contract?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {  
                    payeeID: payeeID,
                    payeeName: payeeName, 
                    pDate: pDate,
                    pTime: pTime,
                    iID: iID, 
                    iName: iName,
                    iWeight: iWeight, 
                    tPrice: tPrice, 
                    task: "new-contract"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Contract Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'c-contract.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function modifyContract(){
    var refNo = document.getElementById("refNo").value;
    var payeeID = document.getElementById("payeeID").value;
    var payeeName = document.getElementById("payeeName").value;  
    var pDate = document.getElementById("pDate").value;
    var pTime = document.getElementById("pTime").value; 
    var iID = document.getElementById("iID").value;
    var iName = document.getElementById("iName").value; 
    var iWeight = document.getElementById("iWeight").value; 
    var tPrice = document.getElementById("tPrice").value;  

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !iID || !iName || !iWeight || !tPrice) { 
        swal("Error", "Complete all requirements!", "error");
        return;  
    }  

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Modify Contract?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {  
                    refNo: refNo,
                    payeeID: payeeID,
                    payeeName: payeeName, 
                    pDate: pDate,
                    pTime: pTime,
                    iID: iID, 
                    iName: iName,
                    iWeight: iWeight, 
                    tPrice: tPrice, 
                    task: "modify-contract"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Contract Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'c-contract.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    }) 
}

function appContract(cNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Approve Contract?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    cNo: cNo, 
                    task: "approve-contract"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Contract Approve!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}

function disContract(cNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Disapprove Contract?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    cNo: cNo, 
                    task: "disapprove-contract"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Contract Disapproved!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
} 

function relContract(){  
    var loanerRef = document.getElementById("loanerRef").value;
    var releaseDate = document.getElementById("releaseDate").value;
    var lAmt = document.getElementById("lAmt").value;

    if(isValidDate(releaseDate)){ 
        swal({
            title: "<h6><b>IMS</b></h6>",
            text: "Release Contract # " + loanerRef + "?",
            html: true,
            type: "info", 
            showCancelButton: true,
            showLoaderOnConfirm: true,
            closeOnEsc: false,
            confirmButtonColor: "#DD6B55", 
            confirmButtonText: "YES", 
            cancelButtonText: "NO",
            closeOnConfirm: false,
        }, function (isConfirm) {
            if (isConfirm) {     
                $.ajax({
                    url: "../modules/ims-process.php",
                    type: "POST",
                    data: {loanerRef: loanerRef, releaseDate: releaseDate, lAmt: lAmt, task: "rel-contract"},
                    async: true,
                    dataType: 'json',
                    cache: false,  
                    success: function(data)
                    {
                        if(JSON.stringify(data) == "\"release\""){
                            swal({
                                title:"<h6><b>Success</b></h6>", 
                                text:"Contract Released!", 
                                html: true,
                                type: "success"
                            }, function () {
                                document.location.reload(true);
                            });
                        } 
                        else{
                            swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                        }
                    },
                    error: function (jqXHR, exception) { 
                        if (jqXHR.status === 0) {
                            swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 404) {
                            swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                        } else if (jqXHR.status == 500) {
                            swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'parsererror') { 
                            swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'timeout') { 
                            swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                        } else if (exception === 'abort') { 
                            swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                        } else { 
                            swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                        }
                    }
                }); 
            }
        });
    }
    else{
        swal("Error", "Date Invalid!", "error");
    } 
}

function newcAdj(){ 
    var loanRef = document.getElementById("loanRef").value;
    var loanBal = document.getElementById("loanBal").value; 

    var f = document.getElementById("adjType");
    var adjType = f.options[f.selectedIndex].value;  

    var f = document.getElementById("mopType");
    var mopType = f.options[f.selectedIndex].value;  
 
    var loanerDate = document.getElementById("loanerDate").value;
    var loanerAmt = document.getElementById("loanerAmt").value;

    if(isValidDate(loanerDate)){
        if(loanerAmt == null || loanerAmt === ''){ 
            swal("Error", "Insert Amount!", "error"); 
        }
        else{ 
            if(Number(loanerAmt) > Number(loanBal) && adjType == 'deduct'){
                swal("Error", "Payment should not exist with remaining Balance!", "error"); 
            }
            else  {
                swal({
                    title: "<h6><b>IMS</b></h6>",
                    text: "Save Adjustment of " + loanRef + "?",
                    html: true,
                    type: "info", 
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    closeOnEsc: false,
                    confirmButtonColor: "#DD6B55", 
                    confirmButtonText: "YES", 
                    cancelButtonText: "NO",
                    closeOnConfirm: false,
                }, function (isConfirm) {
                    if (isConfirm) {     
                        $.ajax({
                            url: "../modules/ims-process.php",
                            type: "POST",
                            data: {loanRef: loanRef, loanBal: loanBal, adjType: adjType, mopType: mopType, loanerDate: loanerDate, loanerAmt: loanerAmt, task: "new-cadj"},
                            async: true,
                            dataType: 'json',
                            cache: false,  
                            success: function(data)
                            {
                                if(JSON.stringify(data) == "\"saved\""){
                                    swal({
                                        title:"<h6><b>Success</b></h6>", 
                                        text:"Adjusment Saved!", 
                                        html: true,
                                        type: "success"
                                    }, function () {
                                        window.location.href = 'c-adj.php';
                                    });
                                } 
                                else if(JSON.stringify(data) == "\"less\""){
                                    swal({
                                        title:"<h6><b>Error</b></h6>", 
                                        text:"Deduction should not be less than remaining balance!", 
                                        html: true,
                                        type: "error"
                                    }, function () {
                                        document.location.reload(true);
                                    });
                                }
                                else if(JSON.stringify(data) == "\"greater\""){
                                    swal({
                                        title:"<h6><b>Error</b></h6>", 
                                        text:"Adjustment can't be greater than Loan Amount!", 
                                        html: true,
                                        type: "error"
                                    }, function () {
                                        document.location.reload(true);
                                    });
                                }
                                else{
                                    swal("Error",JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                                }
                            },
                            error: function (jqXHR, exception) { 
                                if (jqXHR.status === 0) {
                                    swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                                } else if (jqXHR.status == 404) {
                                    swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                                } else if (jqXHR.status == 500) {
                                    swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'parsererror') { 
                                    swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'timeout') { 
                                    swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                                } else if (exception === 'abort') { 
                                    swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                                } else { 
                                    swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                                }
                            }
                        }); 
                    }
                });
            }
        }
    }
    else{
        swal("Error", "Date Invalid!", "error");
    }
}

function newcOutgoing(){
    const rows = document.querySelectorAll('#incomingTable tbody tr');
    const payeeID = document.getElementById('payeeID').value;
    const payeeName = document.getElementById('payeeName').value;
    const buyerID = document.getElementById('buyerID').value;
    const buyerName = document.getElementById('buyerName').value;
    const iID = document.getElementById('iID').value;
    const iName = document.getElementById('iName').value;
    const pDate = document.getElementById('pDate').value;   
    const cNo = document.getElementById('cNo').value;   
    const loanBal = document.getElementById('loanBal').value;   

    if (rows.length === 0) {
        swal("Error", "Please enter charges to proceed", "error");
        return; // Stop further execution
    } 

    // Check if any field is blank or null
    if (!payeeID || !payeeName || !pDate || !buyerID || !buyerName || !cNo) {
        swal("Error", 'Please Complete Entry!', "error");
        return;
    }    

    const table = document.getElementById('incomingTable');
    let total = 0;
    for (let row of table.rows) {
        if (row.rowIndex === 0) continue;
        const cell = row.cells[6];
        let val = String(cell.textContent).replace(/,/g, ''); 
        const value = parseFloat(val); 

        const cellPart = row.cells[1];
        const valuePart = cellPart.textContent;

        if(parseFloat(value) < 0){
            if (!isNaN(parseFloat(value)) && valuePart == "ADVANCES") {
                total += parseFloat(value);
            }
        } 
    }   
 
    let loanBals = String(loanBal).replace(/,/g, '');

    const fNal = total * -1;
    const bal = parseFloat(loanBals);

    if(bal < fNal){
        swal("Error", 'Deduction should not be greater than the balance!', "error");
        return;
    } 

    const tableData = [];
    rows.forEach(row => {
        const rowData = [];
        row.querySelectorAll('td').forEach((cell, index) => {
            if (index < 7) {
                rowData.push(cell.textContent.trim());
            }
        });
        tableData.push(rowData);
    });     

    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Save Transaction?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {                     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    cNo: cNo,
                    payeeID: payeeID,
                    payeeName: payeeName,
                    buyerID: buyerID,
                    buyerName: buyerName,
                    iID: iID,
                    iName: iName,
                    pDate: pDate,   
                    loanBal: loanBal,
                    tableData: JSON.stringify(tableData),  
                    task: "new-ctransaction"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Transaction Saved!",
                            html: true,
                            type: "success"
                        }, function() {
                            window.location.href = 'c-transaction.php';
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            });   
        } 
    })
}

function cancelTransaction(cNo){
    swal({
        title: "<h6><b>IMS</b></h6>",
        text: "Cancel Transaction?",
        html: true,
        type: "info", 
        showCancelButton: true,
        showLoaderOnConfirm: true,
        closeOnEsc: false,
        confirmButtonColor: "#DD6B55", 
        confirmButtonText: "YES", 
        cancelButtonText: "NO",
        closeOnConfirm: false,
    }, function (isConfirm) {
        if (isConfirm) {     
            $.ajax({
                url: "../modules/ims-process.php",
                type: "POST",
                data: {
                    cNo: cNo, 
                    task: "cancel-transaction"
                },
                async: true,
                dataType: 'json',
                cache: false,
                success: function(data) {
                    if (JSON.stringify(data) === "\"saved\"") {
                        swal({
                            title: "<h6><b>Success</b></h6>",
                            text: "Transaction Cancelled!",
                            html: true,
                            type: "success"
                        }, function() {
                            document.location.reload(true);
                        });
                    }   
                    else {
                        swal("Error", JSON.stringify(data) + '\nPlease Contact IT Department', "error");
                    }
                },
                error: function(jqXHR, exception) {
                    if (jqXHR.status === 0) {
                        swal("Error", 'Not connect.\n Verify Network.' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 404) {
                        swal("Error", 'Requested page not found. [404]' + '\nPlease Contact IT Department', "error");
                    } else if (jqXHR.status == 500) {
                        swal("Error", 'Internal Server Error [500].' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'parsererror') {
                        swal("Error", 'Requested JSON parse failed.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'timeout') {
                        swal("Error", 'Time out error.' + '\nPlease Contact IT Department', "error");
                    } else if (exception === 'abort') {
                        swal("Error", 'Ajax request aborted.' + '\nPlease Contact IT Department', "error");
                    } else {
                        swal("Error", 'Uncaught Error.\n' + jqXHR.responseText + '\nPlease Contact IT Department', "error");
                    }
                }
            }); 
        }
    });  
}