<?php
    $mindate = $_GET['min'];
    $maxdate = $_GET['max'];  

    include_once('../modules/connect.php'); 
    session_start();
  
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);

    function getAllDates($startDate, $endDate) {
        try {
            // Create DateTime objects for the start and end dates
            $start = new DateTime($startDate);
            $end = new DateTime($endDate);
    
            // Ensure the end date is inclusive
            $end->modify('+1 day');
    
            // Array to hold all dates
            $allDates = [];
    
            // Loop through each day from start to end
            while ($start < $end) {
                $allDates[] = $start->format('Y-m-d');
                $start->modify('+1 day');
            }
    
            return $allDates;
        } catch (Exception $e) {
            // Handle invalid date formats
            echo 'Error: ' . $e->getMessage();
            return [];
        }
    } 

    function formatDateFromTimestamp($timestamp) {
        // Format the timestamp as MM-dd-yyyy
        return date('m-d-Y', $timestamp);
    }  

    function setCellValueAndStyle($sheet, $cell, $value, $bold = false, $align = 'left') {
        $sheet->setCellValue($cell, $value);
        if ($bold) {
            $sheet->getStyle($cell)->applyFromArray($bold);
        }
        $alignment = $align === 'center' ? $alignCenter : ($align === 'right' ? $alignRight : $alignLeft);
        $sheet->getStyle($cell)->getAlignment()->applyFromArray($alignment);
    }

    function numberToColumnLetter($num) {
        $letter = '';
        while ($num > 0) {
            $num--;
            $letter = chr($num % 26 + 65) . $letter; // Convert to ASCII
            $num = intval($num / 26);
        }
        return $letter;
    }

    use PhpOffice\PhpSpreadsheet\Helper\Sample;
    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    require_once __DIR__ . '/../vendors/phpoffice/phpspreadsheet/src/Bootstrap.php';  

    $helper = new Sample();
    if ($helper->isCli()) {  
        return;
    }
    // Create new Spreadsheet object
    $spreadsheet = new Spreadsheet();  

    $bold = [
        'font' => [ 
            'bold' => true,
        ], 
    ];

    $alignCenter = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
    ];
        
    $alignRight = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,  
    ];

    $alignLeft = [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,  
    ];

    $borderArray = [
        'borders' => [
            'outline' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
            ],
        ],
    ];

    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setName('Arial');
    $spreadsheet->getDefaultStyle()->getFont('A:Z')->setSize('10');

    $spreadsheet->getActiveSheet()->mergeCells("A1:F1"); 
    $spreadsheet->getActiveSheet()->mergeCells("A2:F2"); 


    $spreadsheet->getActiveSheet()->setCellValue('A1', 'MLE TRADING');   
    $spreadsheet->getActiveSheet()->setCellValue('A2', 'Disbursement Report');    

    $mindateTime = new DateTime($mindate);
    $minformattedDate = $mindateTime->format('M d, Y');

    $maxdateTime = new DateTime($mindate);
    $maxformattedDate = $maxdateTime->format('M d, Y');

    $spreadsheet->getActiveSheet()->setCellValue('A3', 'From: ' . $minformattedDate .' to ' . $maxformattedDate);    
   
    $spreadsheet->getActiveSheet()->setCellValue('A5', 'DATE');
    $spreadsheet->getActiveSheet()->setCellValue('B5', 'PARTICULAR');
    $spreadsheet->getActiveSheet()->setCellValue('C5', 'SCK');
    $spreadsheet->getActiveSheet()->setCellValue('D5', 'WT'); 
    $spreadsheet->getActiveSheet()->setCellValue('E5', 'DED');
    $spreadsheet->getActiveSheet()->setCellValue('F5', 'NET');
    $spreadsheet->getActiveSheet()->setCellValue('G5', 'PR');

    $itemSQL = "SELECT UPPER(itemName) itemName FROM G_Items where archiveID = '0'";
    $itemOBJ = $mssql->prepare($itemSQL);
    $itemOBJ->execute(); 
    $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH); 

    $item = [];
    $cell = [];

    if($itemOBJ ->rowCount() > 0){  
        $i = 8;  
        foreach($itemRES as $prow){   
            $columnLetter = numberToColumnLetter($i); 
            $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '5', $prow['itemName']); 
            array_push($item, $prow['itemName']);
            array_push($cell, $i);
            $i++; 
        }
    } 
    $columnLetter = numberToColumnLetter($i++); 
    $advances = $i - 1;
    $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '5', 'ADVANCES');
    $columnLetter = numberToColumnLetter($i++); 
    $general = $i - 1;
    $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '5', 'GENERAL');
    $columnLetter = numberToColumnLetter($i++); 
    $total = $i - 1;
    $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '5', 'TOTAL');
    $columnLetter = numberToColumnLetter($i++); 
    $grand = $i - 1;
    $spreadsheet->getActiveSheet()->setCellValue($columnLetter . '5', 'GRAND TOTAL');
 
    //$itemSQL = "SELECT CASE WHEN incoming.incDate IS NULL THEN source.caDate ELSE incoming.incDate END incDate, 
    // ISNULL(incoming.itemName, source.particulars) itemName, 
    // ISNULL(incoming.sck,0) sck, ISNULL(incoming.weight,0) weight, ISNULL(incoming.ded,0) ded, ISNULL(incoming.net,0) net, ISNULL(incoming.priceKG,0) priceKG,  
    // ISNULL((ISNULL(net,0) * ISNULL(priceKG,0)), source.caAmt) totalAmt 
    // FROM O_CA source INNER JOIN O_CADet det ON source.caRef = det.caRef
    // OUTER APPLY (SELECT sck, ded, net, priceKG, itemName, weight, incDate FROM I_Incoming where caRef = source.caRef) incoming
    // where status <> '3'
    // GROUP BY CASE WHEN incoming.incDate IS NULL THEN source.caDate ELSE incoming.incDate END, incoming.itemName, source.particulars,ISNULL(incoming.itemName, source.particulars), 
    // ISNULL(incoming.sck,0), ISNULL(incoming.weight,0), ISNULL(incoming.ded,0), ISNULL(incoming.net,0), ISNULL(incoming.priceKG,0), source.caAmt 
    // ORDER BY incDate ASC";

    $itemSQL = "SELECT CASE WHEN incoming.incDate IS NULL THEN source.caDate ELSE incoming.incDate END incDate, 
    ISNULL(incoming.itemName, source.particulars) itemName, 
    ISNULL(incoming.sck,0) sck, ISNULL(incoming.weight,0) weight, ISNULL(incoming.ded,0) ded, ISNULL(incoming.net,0) net, ISNULL(incoming.priceKG,0) priceKG,  
    ISNULL((net * priceKG), source.caAmt) totalAmt 
    FROM O_CA source INNER JOIN O_CADet det ON source.caRef = det.caRef
    OUTER APPLY (SELECT sck, ded, net, priceKG, itemName, weight, incDate FROM I_Incoming where caRef = source.caRef) incoming
    where status <> '3'
    GROUP BY CASE WHEN incoming.incDate IS NULL THEN source.caDate ELSE incoming.incDate END, incoming.itemName, source.particulars,ISNULL(incoming.itemName, source.particulars), 
    incoming.sck, incoming.weight, incoming.ded, incoming.net, incoming.priceKG, source.caAmt 
    ORDER BY incDate ASC";
    $itemOBJ = $mssql->prepare($itemSQL);
    $itemOBJ->execute(); 
    $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH); 
 
    $row = 5; $oldDate = ""; $srow = 6; $erow = 5; $tot = 0;

    if($itemOBJ ->rowCount() > 0){   
        foreach($itemRES as $prow){    
            if($prow['incDate'] != $oldDate){  
                if($row != 5) { 
                    $erow = $row - 1;
                    //$spreadsheet->getActiveSheet()->setCellValue($colGrand . $erow, "SUM(T".$srow.":T". $erow .")");  
                    $spreadsheet->getActiveSheet()->getStyle($colGrand . $erow)->getNumberFormat()->setFormatCode('#,##0.00');  
                    $srow = $row;
                }
                
                $row++;
                $dateTime = new DateTime($prow['incDate']);
                $formattedDate = $dateTime->format('M d, Y');
                $spreadsheet->getActiveSheet()->setCellValue('A'. $row, $formattedDate); 
                $oldDate = $prow['incDate'];
            }

            $spreadsheet->getActiveSheet()->setCellValue('B'. $row, $prow['itemName']); 
            $spreadsheet->getActiveSheet()->setCellValue('C'. $row, $prow['sck']); 
            $spreadsheet->getActiveSheet()->setCellValue('D'. $row, $prow['weight']); 
            $spreadsheet->getActiveSheet()->setCellValue('E'. $row, $prow['ded']); 
            $spreadsheet->getActiveSheet()->setCellValue('F'. $row, $prow['net']); 
            $spreadsheet->getActiveSheet()->setCellValue('G'. $row, $prow['priceKG']);
 
            if (in_array($prow['itemName'], $item)) {
                $val = array_search($prow['itemName'], $item);  
                $col = numberToColumnLetter($cell[$val]); 
                $spreadsheet->getActiveSheet()->setCellValue($col . $row, $prow['totalAmt']);  
                $tot = $tot + (float)$prow['totalAmt'];
            } elseif ($prow['itemName'] == "LOAN ADVANCES") {
                $col = numberToColumnLetter($advances);  
                $spreadsheet->getActiveSheet()->setCellValue($col . $row, $prow['totalAmt']); 
                $tot = $tot + (float)$prow['totalAmt'];
            } else {
                $col = numberToColumnLetter($general); 
                $spreadsheet->getActiveSheet()->setCellValue($col . $row, $prow['totalAmt']);  
                $tot = $tot + (float)$prow['totalAmt'];
            }
  
            $colTotal = numberToColumnLetter($total); 
            $sum = numberToColumnLetter($total - 1); 
            $colGrand = numberToColumnLetter($grand); 

            $spreadsheet->getActiveSheet()->setCellValue($colTotal . $row, (string)$tot);    
 
            $range = 'C' . $row . ':'. $colGrand . $row;
            $spreadsheet->getActiveSheet()->getStyle($range)->getNumberFormat()->setFormatCode('#,##0.00');
 
            $row++;
        }

        // $erow = $row - 1;
        // $srow++;
        // $spreadsheet->getActiveSheet()->setCellValue($colGrand . $erow, "=SUM(T".$srow.":T". $erow .")");  
        // $spreadsheet->getActiveSheet()->getStyle($colGrand.$erow)->getNumberFormat()->setFormatCode('#,##0.00');  
 
        // $spreadsheet->getActiveSheet()->getStyle($colTotal.'6:'.$colGrand.$erow)->applyFromArray($bold); 
    }

    $spreadsheet->getActiveSheet()->getStyle('A5:'. $columnLetter .'5')->applyFromArray($borderArray); 

    $spreadsheet->getActiveSheet()->getStyle('A1:'. $columnLetter .'5')->applyFromArray($bold); 
    $spreadsheet->getActiveSheet()->getStyle('A5:'. $columnLetter .'5')->getAlignment()->applyFromArray($alignCenter);  

    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(14);
    $spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(40);
    $spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(10);
    $spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(10);
    $spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('E')->setWidth(10);
    $spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('F')->setWidth(10);
    $spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(false); 
    $spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(12);  
    
    for ($col = 'H'; $col <= 'Z'; $col++) { // Adjust 'Z' as needed
        $spreadsheet->getActiveSheet()->getColumnDimension($col)->setWidth(15);
    }

    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $spreadsheet->setActiveSheetIndex(0);

    // Redirect output to a client’s web browser (Xlsx)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="disbursement-report.xlsx"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');

    // If you're serving to IE over SSL, then the following may be needed
    header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
    header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header('Pragma: public'); // HTTP/1.0

    $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
    $writer->save('php://output');
    exit;   
?>