<?php
    include_once('../modules/connect.php'); 
    session_start();

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);      

    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: Content-Type");
    header('Content-Type: application/json');

    function escapeSingleQuote($input) {
        // Replace every single quote with two single quotes
        return str_replace("'", "''", $input);
    }

    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ipAddress = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipAddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ipAddress = $_SERVER['REMOTE_ADDR'];
    }

    date_default_timezone_set('Asia/Manila');
    $dateToday = date("m-d-Y");
    $timeToday = date("h:i a");   
    $otherFormat = date("Y-m-d"); 

    
    $jsonData = file_get_contents('php://input');

    // Decode the JSON data into a PHP associative array
    $data = json_decode($jsonData, true);
    
    // Check if decoding was successful
    if (json_last_error() !== JSON_ERROR_NONE) {
        die('Invalid JSON data');
    }
    
    // Access the 'data' array
    $dataArray = $data['data'];
    
    // Example: Loop through the array and print the values
    foreach ($dataArray as $index => $row) {
        // Print the headers and values
        if ($index === 0) {
            
        } else {  
            $itemSQL = "SELECT coaGL FROM G_Coa where coaGL = '". escapeSingleQuote(strtoupper($row[1])) ."'";
            $itemOBJ = $mssql->prepare($itemSQL);
            $itemOBJ->execute(); 
            $itemRES = $itemOBJ->fetchAll(PDO::FETCH_BOTH);
    
            if($itemOBJ ->rowCount() > 0){     
                $newSQL = "UPDATE G_Coa SET coaName = '". escapeSingleQuote(strtoupper($row[0])) ."', coaGL = '". escapeSingleQuote(strtoupper($row[1])) ."', coaParentID = '". escapeSingleQuote(strtoupper($row[2])) ."', coaLevel = '". escapeSingleQuote(strtoupper($row[3])) ."', coaType = '". escapeSingleQuote(strtoupper($row[4])) ."' where coaGL = '". escapeSingleQuote(strtoupper($row[1])) ."'"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();   
            } 
            else{
                $newSQL = "INSERT INTO G_Coa (coaName, coaGL, coaParentID, coaLevel, coaType, archiveID) values ('". escapeSingleQuote(strtoupper($row[0])) ."','". escapeSingleQuote(strtoupper($row[1])) ."','". escapeSingleQuote(strtoupper($row[2])) ."','". escapeSingleQuote(strtoupper($row[3])) ."','". escapeSingleQuote(strtoupper($row[4])) ."','0')"; 
                $newOBJ = $mssql->prepare($newSQL);
                $newOBJ->execute();    
            }

            $logSQL = "INSERT INTO G_Logs (userID, dateLog, timeLog, refNo, activityName, ipAddress) values ('". $_SESSION['userID'] ."', '". $dateToday ."', '". $timeToday ."', '', 'Master Data (Upload COA)', '". $ipAddress ."')"; 
            $logsOBJ = $mssql->prepare($logSQL);
            $logsOBJ->execute();  
        }
    }
    echo json_encode("saved");   
?>