<?php 
    require_once '../vendors/phpword/autoload.php';

    // Creating the new document...
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    
    include_once('../modules/connect.php');

    $invoiceNo  = $_GET['inv']; 
 
    include_once('../modules/session-handler.php'); 

    $first =   $_SESSION['firstName'];
    $last =   $_SESSION['lastName'];
    $fullname = $_SESSION['firstName'] . ' ' . $_SESSION['lastName'];
    $position = ''; 
    $userid = $_SESSION['userID']; 

    function floatvalue($val){
        $val = str_replace(",",".",$val);
        $val = preg_replace('/\.(?=.*\.)/', '', $val);
        return floatval($val);
    } 


    $caSQL = "SELECT clientID, clientName, outDate, outTime, locNo, locationName, itemNo, itemName, FORMAT(sck, 'N2') sck, FORMAT(ded, 'N2') ded, FORMAT(net, 'N2') net, FORMAT(priceKG, 'N2') priceKG, coaGL, charges, weight, FORMAT(totalPrice, 'N2') totalPrice FROM I_Outgoing where invoiceNo = '". $invoiceNo ."'"; 
    $caOBJ = $mssql->prepare($caSQL);
    $caOBJ->execute();

    $caRES = $caOBJ->fetchAll(PDO::FETCH_BOTH);

    if($caOBJ ->rowCount() > 0){  
        foreach($caRES as $row){    
            $clientName = str_replace('&', 'and', $row['clientName']); 
            $outDate = $row['outDate']; 
            $clientID = $row['clientID'];
            
            $coaGL[] = $row['coaGL'];
            $charges[] = $row['charges'];
            $weight[] = $row['weight'];
            $sck[] = $row['sck'];
            $ded[] = $row['ded'];
            $net[] = $row['net'];
            $priceKG[] = $row['priceKG'];  
            $locationName[] = $row['locationName']; 
            $itemName[] = $row['itemName']; 
            $totalPrice[] = $row['totalPrice'];
        }   
    }  

    $section = $phpWord->addSection([
        'pageSizeH' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(5.5),
        'pageSizeW' => \PhpOffice\PhpWord\Shared\Converter::inchToTwip(8.5),
        'marginLeft' => 600,
        'marginRight' => 600
    ]);

    $topBorderCell =
    [
        'borderTopColor' =>'000000',
        'borderTopSize' => 20
    ]; 

    $bottomBorderCell =
    [ 
        'borderBottomColor' =>'000000',
        'borderBottomSize' => 20 
    ];   

    $header = $section->createHeader(); 

    // -- HEADER MLE -- //
    $header->addText(
        'MLE TRADING',
        array('name' => 'Arial', 'size' => 12,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0))
    );       
    $header->addText(
        'SALES INVOICE',
        array('name' => 'Arial', 'size' => 9,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0)
    ); 
    $header->addTextBreak(); 
     
    $table = $header->addTable();  
  
    // -- PARTNER DETAILS -- //
    $table->addRow();
    $table->addCell(3000)->addText('Reference:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($invoiceNo), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('Date:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText($outDate, array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $table->addRow();
    $table->addCell(3000)->addText('Partner Name:', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText(strtoupper($clientID) .' '.strtoupper($clientName), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
  
    $table->addRow();
    $table->addCell(3000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(9000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false, 'italic'=> true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(4000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space' => array('line' => 0),'spaceAfter' => 0));
 
    $section->addTextBreak(); 

    $table = $section->addTable();
    $table->addRow();
    $table->addCell(1900,$bottomBorderCell)->addText('CODE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(6000,$bottomBorderCell)->addText('CHARGES', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(2000,$bottomBorderCell)->addText('SACKS', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000,$bottomBorderCell)->addText('DEDUCTION', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000,$bottomBorderCell)->addText('NET', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2100,$bottomBorderCell)->addText('PRICE/KG', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000,$bottomBorderCell)->addText('NET PRICE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'center','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    
    $totalAmt = 0;
    for($x = 0;$x < count($sck);$x++){
        $table->addRow(); 
        $table->addCell(1900)->addText($coaGL[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(6000)->addText($charges[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(2000)->addText($sck[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(2000)->addText($ded[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(2000)->addText($net[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
        $table->addCell(2100)->addText($priceKG[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
        $table->addCell(2000)->addText($totalPrice[$x], array('name' => 'Arial', 'size' => 8.5,'bold' => false),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 

        $totalAmt = $totalAmt + floatvalue($totalPrice[$x]);
    }

    $table->addRow();
    $table->addCell(1900)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(6000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('',array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table->addRow(); 
    $table->addCell(1900)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0)); 
    $table->addCell(2100)->addText('TOTAL AMOUNT',array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space' => array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table->addCell(2000)->addText(number_format((float)$totalAmt, 2, '.', ','), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'right','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
   
    $section->addTextBreak(1);

    $footer = $section->createFooter(); 
  
    $table1 = $footer->addTable();

    $table1->addRow(); 
    $table1->addCell(6000)->addText('Prepared By:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('Approved By:', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('_____________________', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));

    $table1->addRow(); 
    $table1->addCell(6000)->addText(strtoupper($fullname), array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('MLE', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(6000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
    $table1->addCell(5000)->addText('', array('name' => 'Arial', 'size' => 8.5,'bold' => true),array('align' => 'left','space'=> array('line' => 0),'spaceAfter' => 0 ,'lineHeight'=>1.0));
 
    $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007'); 
    header("Content-Disposition: attachment; filename=".strtoupper(str_replace(',', '', $invoiceNo)).".docx");
    $objWriter->save("php://output");
?>